#!/bin/bash

# Init special RANDOM variable
RANDOM=$$$(date +%s)

. fs.sh
. fill.sh
. resize.sh
. check.sh

if [ "$#" -eq 0 ]; then
	echo Usage do_test MAX-SPACE
	exit 1
fi

function clean()
{
	mount | grep EXT2_FS >> /dev/null && sudo umount EXT2_FS
	mount | grep EXT2_FS_BACKUP >> /dev/null && sudo umount EXT2_FS_BACKUP
	for file in EXT2_FS EXT2_FS_BACKUP TEST_IMAGE TEST_IMAGE-BACKUP TEST_IMAGE-BACKUP1; do
		test -e $file && rm -rf $file
	done
}



for step in 1 2 3
do
	size=$1
	total=$(expr $1 \* 3)

	echo
	echo "####"
	echo "# TESTING WITH IMAGE OF $size BYTES (total $total bytes)"
	echo "####"
	echo

	create_image TEST_IMAGE $size && \
		create_ext2_filesystem TEST_IMAGE 1024 256 default ext_attr,^dir_index,^resize_inode && \
		mkdir EXT2_FS && \
		sudo mount -o loop,user_xattr TEST_IMAGE EXT2_FS && \
		create_files EXT2_FS 5 && \
		sudo umount EXT2_FS


	if [ $? -eq 0 ]
	then
		
		more=25

		while true
		do
			to_resize=$[ ($RANDOM % 100) ]	

			if [ $more -eq 0 ]; then
				echo
				echo "[ ERROR ] Could ot find a valid resize percentage" 
				echo 
				clean
				exit 1
			fi

			if resize_ext2_filesystem TEST_IMAGE TEST_IMAGE-BACKUP "${to_resize}%"; then
				break
			else
				let more-=1	
				rm -f TEST_IMAGE-BACKUP
			fi
		done
			
		# Go with first check

		mkdir EXT2_FS_BACKUP && \
			sudo mount -o loop,user_xattr TEST_IMAGE EXT2_FS && \
			sudo mount -o loop,user_xattr TEST_IMAGE-BACKUP EXT2_FS_BACKUP && \
			check_files_content EXT2_FS_BACKUP EXT2_FS && \
			check_extended_attributes EXT2_FS_BACKUP EXT2_FS && \
			sudo umount EXT2_FS && \
			sudo umount EXT2_FS_BACKUP

			
		if [ $? -eq 0 ]; then
			# do repeat resize and compare images with diff
				
			mv TEST_IMAGE-BACKUP TEST_IMAGE-BACKUP1
			cp TEST_IMAGE-BACKUP1 TEST_IMAGE

			# we need to make new resized image to compare because
			# of last mount change time, mount count and mount path
				 
			resize_ext2_filesystem TEST_IMAGE none "${to_resize}%"

			for n in $(seq 1 10); do

				cp TEST_IMAGE-BACKUP1 TEST_IMAGE-BACKUP && \
					resize_ext2_filesystem TEST_IMAGE-BACKUP none "${to_resize}%"

				if [ $? -ne 0 ]; then
					echo "[ ERROR] Internal error"
					clean
					exit 1
				fi
					
				if ! diff TEST_IMAGE TEST_IMAGE-BACKUP; then
					echo
					echo "[ ERROR ] resize images are not equal"
					echo
					clean
					exit 1
				else
					echo "IMAGE COPY TEST $n [ OK ]"
				fi
			done

#				mv TEST_IMAGE-BACKUP1 TEST_IMAGE-BACKUP
				
#				rm -vf TEST_IMAGE && \
#				mv TEST_IMAGE-BACKUP TEST_IMAGE && \
#				resize_ext2_filesystem TEST_IMAGE TEST_IMAGE-BACKUP '99%' && \
#				sudo mount -o loop,user_xattr TEST_IMAGE EXT2_FS && \
#				sudo mount -o loop,user_xattr TEST_IMAGE-BACKUP EXT2_FS_BACKUP && \
#				check_files_content EXT2_FS_BACKUP EXT2_FS && \
#				check_extended_attributes EXT2_FS_BACKUP EXT2_FS
			
			if [ $? -eq 0 ]
			then
				echo 
				echo "###"
				echo "# ALL TEST PASSED"
			else
				echo
				echo "###"
				echo "# Error while resizing/checking filesystem"
				clean 
				exit 1
			fi
		fi
	else
		echo
		echo "###"
		echo "# Error while creating fs"
		clean
		exit 1
	fi
	clean
done

exit 0

