
# random_letters LENGTH
function print_random_letters() 
{ 
	src="abcdefghijklmnopqrstuvwzABCDEFGHIJKLMNOPQRSTUWZ0123456789"
	rnd=

	for i in $(seq 0 $1)
	do
		b=$[ ( $RANDOM % 57 ) + 1 ]
		l=$( echo $src | cut -b $b )
		rnd="$rnd$l"
	done
	echo $rnd
} 

# CREATE FILE
# $1: PATH
# $2: type (r | regular) | (d | directory)
# $3: number of extended attributes
# $4: size
function create_file()
{
	case $2 in
		d | directory)
			mkdir $1 && echo && echo "# CREATED DIRECTORY: $1"
			;;
		r | regular)
			dd if=/dev/urandom of=$1 bs=$4 count=1 status=noxfer 2>> /dev/null && \
				echo && echo "# CREATED FILE: $1 ($4)"
			;;
	esac

	if [ $? -ne 0 ]; then
		return 1
	fi

	nattrs=$[ ( $RANDOM % 6 ) ]
 
	for attr in `seq 1 $nattrs`
	do
		xattr_name=$(print_random_letters 8)
		xattr_value=$(print_random_letters 16)
		
		setfattr -n user.$xattr_name -v $xattr_value $1 || return 1
		echo -e attribute user.$xattr_name set to $xattr_value for $1
	done

	
}

# DELETE RANDOM FILES
# $1 PREFIX
# $2: Number of files to delete
function delete_random_file()
{
	for n in $(seq 1 $2)
	do
#		total_files=$(find $1 -t f | wc -l)
		file_list=$(find $1 -name '*' 2>> /dev/null )
		total_files=$(echo $file_list | sed 's/ /\n/g' | wc -l)
		to_remove=$(echo $file_list | cut -d ' ' -f $[ ( $RANDOM % $total_files ) + 1 ])
		if [ -r $to_remove -a -w $to_remove ]; then
			rm -vf $to_remove 2> /dev/null
		fi
	done
}

# FILL FILESYSTEM
# $1: PATH
function fill()
{
	dirs=0
	files=0

	while [ $? -eq 0 ]
	do
		nfiles=$[ ( $RANDOM % 100 ) ]
		
		dirname="$1/$(print_random_letters 16)"
		create_file $dirname directory 5 || break 
		
		let dirs+=1

		for n in $(seq 1 $nfiles)
		do
			filename=$(print_random_letters 16)
			filesize=$[ ( $RANDOM % 2000 ) ]
			create_file "$dirname/$filename" regular 5 $filesize || break
			let files+=1
		done
	done

	echo
	echo "###"
	echo "# CREATED $dirs directory, $files files"
	echo

}

# CREATE FILES
# $1: prefix (mount point)
# $2: steps
function create_files()
{
	for n in $(seq 1 $2)
	do
		fill $1
		delete_random_file $1 $[ ( $RANDOM % 20 ) ]

	done
	return 0
}


