
# CREATE IMAGE
# $1 = Image path
# $2 = Image size
function create_image()
{
	dd if=/dev/zero of=$1 bs=$2 count=1 status=noxfer 2>> /dev/null
	return $?
}

# CREATE FS
# 	$1: device or file
# 	$2: block size
# 	$3: blocks per group
#       $4: bytes per inode (create one inode for each $4 bytes of filesystem)
#       $5: feature list (Example: resize_inode,dir_index) see mkfs.ext2(8)
function create_ext2_filesystem()
{
	options='-F -q -t ext2'

	parted -s $1 mklabel msdos || return 1

	test "$2" != 'default' && options="$options -b $2"
	test "$3" != 'default' && options="$options -g $3"
	test "$4" != 'default' && options="$options -i $4"
	test -n "$5" && options="$options -O $5"

	mkfs.ext2 $options $1
	return $?
}

