
local LDemux = pd.Class:new():register("ldemux")

function LDemux:initialize(name, atoms)
    local n = atoms[1] or 2 -- default to 2 outlets.
    if type(n) ~= "number" or n < 2 then
        pd.post("ldemux: wrong outlet-count argument, using 2 outlets instead")
        n = 2
    end
    self.outlets = n
    self.inlets = 2
    self.to = 0
    -- second arg, if a number, selects default outlet
    if type(atoms[2]) == "number" then
        self:in_1_float(atoms[2])
    end
    return true
end

function LDemux:in_1_float(f)
    -- clip selection between left- and rightmost outlet
    self.to = math.max(0, math.min(self.outlets - 1, f))
end

function LDemux:in_0(s, m)
  self:outlet(self.to, s, m)
end
