/* Copyright (c) 1997-1999 Miller Puckette and others.
* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.  */


#include <m_pd.h>

/* ------------------------ tabwriteat~ ------------------------- */

static t_class *tabwriteat_class;

typedef struct _tabwriteat
{
    t_object x_obj;
    t_word *x_vec;
    int x_graphperiod;
    int x_graphcount;
    t_symbol *x_arrayname;
    t_float x_f;
} t_tabwriteat;

static void tabwriteat_tick(t_tabwriteat *x);

static void *tabwriteat_new(t_symbol *s)
{
    t_tabwriteat *x = (t_tabwriteat *)pd_new(tabwriteat_class);
    x->x_graphcount = 0;
    x->x_arrayname = s;
    x->x_f = 0;
    // second inlet~ for position to write to:
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);
    return (x);
}

static t_int *tabwriteat_perform(t_int *w)
{
    t_tabwriteat *x = (t_tabwriteat *)(w[1]);
    t_sample *in = (t_sample *)(w[2]);
    t_sample *in2 = (t_sample *)(w[3]);
    int n = w[4];
    t_word *dest = x->x_vec;
    int i = x->x_graphcount;
    if (!x->x_vec) goto bad;

    int destsize;
    int destindex;
    t_garray *a;

    if (!(a = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class)))
    {
        if (*x->x_arrayname->s_name)
        {
            pd_error(x, "tabwriteat~: %s: no such array", x->x_arrayname->s_name);
            goto bad;
        }
    }
    else if (!garray_getfloatwords(a, &destsize, &x->x_vec))
    {
        pd_error(x, "%s: bad template for tabwriteat~", x->x_arrayname->s_name);
        goto bad;
    }

    while (n--)
    {   
        t_sample f = *in++;
        destindex = (int) *in2++;
        // t_sample g = *in2++;
        // destindex = (int)g;
        // destindex = 0;

        if (destindex < 0)
            destindex = 0;
        else if (destindex >= destsize)
            destindex = destsize-1;
        //vec[n].w_float = f;

        if (PD_BIGORSMALL(f))
            f = 0;
         // (dest++)->w_float = f;
         dest[destindex].w_float = f;
    }
    if (!i--)
    {
        t_garray *a = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class);
        if (!a)
            bug("tabwriteat_dsp");
        else garray_redraw(a);
        i = x->x_graphperiod;
    }
    x->x_graphcount = i;
bad:
    return (w+5);
}

static void tabwriteat_dsp(t_tabwriteat *x, t_signal **sp)
{
    int vecsize;
    t_garray *a;

    if (!(a = (t_garray *)pd_findbyclass(x->x_arrayname, garray_class)))
    {
        if (*x->x_arrayname->s_name)
            pd_error(x, "tabwriteat~: %s: no such array", x->x_arrayname->s_name);
    }
    else if (!garray_getfloatwords(a, &vecsize, &x->x_vec))
        pd_error(x, "%s: bad template for tabwriteat~", x->x_arrayname->s_name);
    else
    {
        int n = sp[0]->s_n;
        int ticksper = sp[0]->s_sr/n;
        if (ticksper < 1) ticksper = 1;
        x->x_graphperiod = ticksper;
        if (x->x_graphcount > ticksper) x->x_graphcount = ticksper;
        if (n < vecsize) vecsize = n;
        garray_usedindsp(a);
        // two inlet~s:
        dsp_add(tabwriteat_perform, 4, x, sp[0]->s_vec, sp[1]->s_vec, vecsize);
    }
}

static void tabwriteat_set(t_tabwriteat *x, t_symbol *s)
{
    x->x_arrayname = s;
}

void tabwriteat_tilde_setup(void)
{
    tabwriteat_class = class_new(gensym("tabwriteat~"), (t_newmethod)tabwriteat_new,
        0, sizeof(t_tabwriteat), CLASS_DEFAULT, A_DEFSYM, 0);
    CLASS_MAINSIGNALIN(tabwriteat_class, t_tabwriteat, x_f);
    class_addmethod(tabwriteat_class, (t_method)tabwriteat_dsp, gensym("dsp"), 0);
    class_addmethod(tabwriteat_class, (t_method)tabwriteat_set, gensym("set"),
            A_SYMBOL, 0);
}


