/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-cal-span-diff.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_cal_span_diff
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>


/*
 * Test: pdf_time_cal_span_diff_001
 * Description:
 *   Create object(base_time_object) of type pdf_time_t. Create time spans using structure pdf_time_cal_span_s.Store the result in object of type pdf_time_c *   al_span_s. 
 * Success condition:
 *   Call to pdf_time_cal_span_diff should return PDF_OK
 */
START_TEST (pdf_time_cal_span_diff_001)
{
  
  struct pdf_time_cal_span_s time_span_obj1,time_span_obj2,time_span_result;

  pdf_time_t base_time_object;

  base_time_object=pdf_time_new();/* create base time object */

  time_span_obj1.years=0; /* For First object create time span of 10 hours and 10  mins */

  time_span_obj1.months=0;

  time_span_obj1.days=0;
  
  time_span_obj1.hours=10;

  time_span_obj1.minutes=10;

  time_span_obj1.seconds=0;

  time_span_obj2.years=0; /* for Second object create time span of 5 hours and 0  mins */

  time_span_obj2.months=0;

  time_span_obj2.days=0;
  
  time_span_obj2.hours=5;

  time_span_obj2.minutes=0;

  time_span_obj2.seconds=0;
 
  fail_if((pdf_time_cal_span_diff(time_span_obj1,time_span_obj2,base_time_object,&time_span_result)) != PDF_OK);
  
  pdf_time_destroy(base_time_object);  
}
END_TEST




/*
 * Test case creation function
 */
TCase *
test_pdf_time_cal_span_diff (void)
{
  TCase *tc = tcase_create("pdf_time_cal_span_diff");
  tcase_add_test(tc, pdf_time_cal_span_diff_001);
    	
  return tc;
}

/* End of pdf-time-cal-span-diff.c */
