/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-cmp.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_cmp
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>


/*
 * Test: pdf_time_cmp_001
 * Description:
 *   Create two objects of type pdf_time_t, such that first object containts date older than second object
 * Success condition:
 *     Call to pdf_time_cmp should return 1
 */
START_TEST (pdf_time_cmp_001)
{
  pdf_time_t time_obj_1,time_obj_2;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  struct pdf_time_cal_s time_cal_obj_2; /* Span of March 1 2000-03-01 04:01:01 IST */ 
    
  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  time_cal_obj_2.year=2000;
  
  time_cal_obj_2.month=3;
    
  time_cal_obj_2.day=1;
    
  time_cal_obj_2.dow=1;

  time_cal_obj_2.hour=4;

  time_cal_obj_2.minute=1;

  time_cal_obj_2.gmt_offset=4; /* Offset IST */

  time_cal_obj_2.second=1;
    
  time_obj_2 = pdf_time_new();

  pdf_time_from_cal(time_obj_2,time_cal_obj_2);

  fail_if((pdf_time_cmp(time_obj_1,time_obj_2)) != 1);

  pdf_time_destroy(time_obj_2);

  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST

/*
 * Test: pdf_time_cmp_002
 * Description:
 *   Create two objects of type pdf_time_t, such that second object containts date older than first object
 * Success condition:
 *     Call to pdf_time_cmp should return -1
 */
START_TEST (pdf_time_cmp_002)
{
  pdf_time_t time_obj_1,time_obj_2;
    
  struct pdf_time_cal_s time_cal_obj_2; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  struct pdf_time_cal_s time_cal_obj_1; /* Span of March 1 2000-03-01 04:01:01 IST */ 
    
  time_cal_obj_2.year=2008;
  
  time_cal_obj_2.month=1;
    
  time_cal_obj_2.day=1;
    
  time_cal_obj_2.dow=1;

  time_cal_obj_2.hour=12;

  time_cal_obj_2.minute=10;

  time_cal_obj_2.gmt_offset=4; /* Offset IST */

  time_cal_obj_2.second=10;  

  time_obj_2 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_2,time_cal_obj_2);

  time_cal_obj_1.year=2000;
  
  time_cal_obj_1.month=3;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=4;

  time_cal_obj_1.minute=1;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=1;
    
  time_obj_1 = pdf_time_new();

  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  fail_if((pdf_time_cmp(time_obj_1,time_obj_2)) != -1);

  pdf_time_destroy(time_obj_2);

  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST


/*
 * Test: pdf_time_cmp_003
 * Description:
 *   Duplicate  object of type pdf_time_t
 * Success conditions:
 *   Call to pdf_time_cmp should return 0
 */
START_TEST (pdf_time_cmp_003)
{
  pdf_time_t time_obj_1,time_obj_2;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */
    
  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  time_obj_2 = pdf_time_new();

  time_obj_2=pdf_time_dup(time_obj_1);

  fail_if((pdf_time_cmp(time_obj_1,time_obj_2)) != 0);
      
  pdf_time_destroy(time_obj_2);
  
  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST


/*
 * Test case creation function
 */
TCase *
test_pdf_time_cmp (void)
{
  TCase *tc = tcase_create("pdf_time_cmp");
  tcase_add_test(tc, pdf_time_cmp_001);
  tcase_add_test(tc, pdf_time_cmp_002);
  tcase_add_test(tc, pdf_time_cmp_003);
  	
  return tc;
}

/* End of pdf-time-cmp.c */
