/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-from-cal.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_from_cal
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>
#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_from_cal_001
 * Description:
 *   Set the values of existing time object to valid calender time.
 * Success condition 
 *   Call  to pdf_time_from_cal should return PDF_OK
 */
START_TEST (pdf_time_from_cal_001)
{
  pdf_time_t time_obj;
  
  struct pdf_time_cal_s cal_t;	 
	
  cal_t.year=12;

  cal_t.month=13;

  cal_t.day=31;

  cal_t.dow=7;
 
  cal_t.hour=23;

  cal_t.minute=59;

  cal_t.gmt_offset=5; 

  cal_t.second=59; 				
    
  time_obj=pdf_time_new();

  fail_if((pdf_time_get_utc_cal(time_obj, &cal_t))!=PDF_OK);
  
  pdf_time_destroy(time_obj);
}
END_TEST

/*
 * Test: pdf_time_from_cal_002
 * Description:
 *   Set the values of existing time object to given invalid calender time.
 * Success condition 
 *   Call  to pdf_time_from_cal should NOT return  PDF_OK
 */
START_TEST (pdf_time_from_cal_002)
{
  pdf_time_t time_obj;
  
  struct pdf_time_cal_s cal_t;	 
	
  cal_t.year=12;

  cal_t.month=13;

  cal_t.day=31;

  cal_t.dow=8;
 
  cal_t.hour=23;

  cal_t.minute=45;

  cal_t.gmt_offset=5; 

  cal_t.second=59; 				
    
  time_obj=pdf_time_new();

  fail_if((pdf_time_get_utc_cal(time_obj, &cal_t)) == PDF_OK);
  
  pdf_time_destroy(time_obj);
}
END_TEST



/*
 * Test case creation function
 */
TCase *
test_pdf_time_from_cal (void)
{
  TCase *tc = tcase_create("pdf_time_from_cal");
  tcase_add_test(tc, pdf_time_from_cal_001);
  tcase_add_test(tc, pdf_time_from_cal_002);

  return tc;
}

/* End of pdf-time-from-cal.c */
