/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-new.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_new
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_new_001
 * Description:
 *   Create a new Time Object
 * Success condition:
 *   It should not return NULL value
 */
START_TEST (pdf_time_new_001)
{
  pdf_time_t time_obj;
    
  time_obj=pdf_time_new();

  fail_if( time_obj == NULL);
  
  pdf_time_destroy(time_obj);
}
END_TEST


/*
 * Test case creation function
 */
TCase *
test_pdf_time_new (void)
{
  TCase *tc = tcase_create("pdf_time_new");
  tcase_add_test(tc, pdf_time_new_001);
  
  return tc;
}

/* End of pdf-time-new.c */
