/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-span-diff.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_span_diff
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_span_diff_001
 * Description:
 *   Create two objects of type pdf_time_span_t of which one is positive time span  and other is negative time span and store the result in third object
 * Success condition:
 *    1: Call to pdf_time_span_diff should return PDF_OK
 */
START_TEST (pdf_time_span_diff_001)
{
  pdf_time_span_t time_span_obj_1,time_span_obj_2,time_span_res_obj;
  
  time_span_obj_1 = pdf_time_span_new();

  time_span_obj_2 = pdf_time_span_new();

  time_span_res_obj = pdf_time_span_new();
   	
  pdf_time_span_set_from_i32(&time_span_obj_1,1000); 

  pdf_time_span_set_from_i32(&time_span_obj_2,-1000); 

  fail_if((pdf_time_span_diff(time_span_obj_1,time_span_obj_2, &time_span_res_obj)) != PDF_OK);
  
  pdf_time_span_destroy(&time_span_obj_1);

  pdf_time_span_destroy(&time_span_obj_2);

  pdf_time_span_destroy(&time_span_res_obj);
	
}
END_TEST

/*
 * Test: pdf_time_span_diff_002
 * Description:
 *   Create two objects of type pdf_time_span_t of which both contains  negative time span  and store the result in third  object
 * Success condition:
 *    1: Call to pdf_time_span_diff should return PDF_OK
 */
START_TEST (pdf_time_span_diff_002)
{
  pdf_time_span_t time_span_obj_1,time_span_obj_2,time_span_res_obj;
  
  time_span_obj_1 = pdf_time_span_new();

  time_span_obj_2 = pdf_time_span_new();

  time_span_res_obj = pdf_time_span_new();
   	
  pdf_time_span_set_from_i32(&time_span_obj_1,-1000); 

  pdf_time_span_set_from_i32(&time_span_obj_2,-1000); 

  fail_if((pdf_time_span_diff(time_span_obj_1,time_span_obj_2,&time_span_res_obj)) != PDF_OK);
  
  pdf_time_span_destroy(&time_span_obj_1);

  pdf_time_span_destroy(&time_span_obj_2);

  pdf_time_span_destroy(&time_span_res_obj);
	
}
END_TEST


/*
 * Test: pdf_time_span_diff_003
 * Description:
 *   Create two objects of type pdf_time_span_t of which both are positive time span  and store the result in third object
 * Success condition:
 *    1: Call to pdf_time_span_diff should return PDF_OK
 */
START_TEST (pdf_time_span_diff_003)
{
  pdf_time_span_t time_span_obj_1,time_span_obj_2,time_span_res_obj;
  
  time_span_obj_1 = pdf_time_span_new();

  time_span_obj_2 = pdf_time_span_new();

  time_span_res_obj = pdf_time_span_new();
   	
  pdf_time_span_set_from_i32(&time_span_obj_1,1000); 

  pdf_time_span_set_from_i32(&time_span_obj_2,1000); 

  fail_if((pdf_time_span_diff(time_span_obj_1,time_span_obj_2,&time_span_res_obj)) != PDF_OK);
  
  pdf_time_span_destroy(&time_span_obj_1);

  pdf_time_span_destroy(&time_span_obj_2);

  pdf_time_span_destroy(&time_span_res_obj);
	
}
END_TEST



/*
 * Test case creation function
 */
TCase *
test_pdf_time_span_diff (void)
{
  TCase *tc = tcase_create("pdf_time_span_diff");
  tcase_add_test(tc, pdf_time_span_diff_001);
  tcase_add_test(tc, pdf_time_span_diff_002);
  tcase_add_test(tc, pdf_time_span_diff_003); 
	
  return tc;
}

/* End of pdf-time-span-diff.c */
