/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-add-cal-span.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_sub_cal_span
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_sub_cal_span_001
 * Description:
 *   Substract valid  time span from existing time object .
 * Success condition:
 *   Call to pdf_time_sub_cal_span should return PDF_OK
 */
START_TEST (pdf_time_sub_cal_span_001)
{
  pdf_time_t time_obj;

  struct pdf_time_cal_span_s time_cal_obj;
 
  time_cal_obj.years=0; /* Create  object create time span of 10 hours and 10  mins */

  time_cal_obj.months=0;

  time_cal_obj.days=0;

  time_cal_obj.hours=10;

  time_cal_obj.minutes=10;

  time_cal_obj.seconds=0;
    
  time_obj=pdf_time_new();

  fail_if((pdf_time_sub_cal_span(time_obj, time_cal_obj))!=PDF_OK);
  
  pdf_time_destroy(time_obj);
}
END_TEST



/*
 * Test case creation function
 */
TCase *
test_pdf_time_sub_cal_span (void)
{
  TCase *tc = tcase_create("pdf_time_sub_cal_span");
  tcase_add_test(tc, pdf_time_sub_cal_span_001);
  
  return tc;
}

/* End of pdf-time-sub-cal-span.c */
