/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-to-string.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_to_string
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_to_string_001
 * Description:
 *   Create object of type pdf_time_t and print it in PDF_TIME_FORMAT_PDF
 * Success condition:
 *    Call to pdf_time_to_string should not return NULL
 */
START_TEST (pdf_time_to_string_001)
{
  pdf_time_t time_obj_1;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  fail_if((pdf_time_to_string(time_obj_1,PDF_TIME_FORMAT_PDF)) == NULL);
 
  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST


/*
 * Test: pdf_time_to_string_002
 * Description:
 *   Create object of type pdf_time_t and print it in PDF_TIME_FORMAT_ISO_8601
 * Success condition:
 *    Call to pdf_time_to_string should not return NULL
 */
START_TEST (pdf_time_to_string_002)
{
  pdf_time_t time_obj_1;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  fail_if((pdf_time_to_string(time_obj_1,PDF_TIME_FORMAT_ISO_8601)) == NULL);
 
  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST


/*
 * Test: pdf_time_to_string_003
 * Description:
 *   Create object of type pdf_time_t and print it in PDF_TIME_FORMAT_ASN1
 * Success condition:
 *    Call to pdf_time_to_string should not return NULL
 */
START_TEST (pdf_time_to_string_003)
{
  pdf_time_t time_obj_1;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  fail_if((pdf_time_to_string(time_obj_1,PDF_TIME_FORMAT_ASN1)) == NULL);
 
  pdf_time_destroy(time_obj_1);
	
}
END_TEST

/*
 * Test: pdf_time_to_string_004
 * Description:
 *   Create object of type pdf_time_t and print it in PDF_TIME_FORMAT_GENERALIZED_ASN1
 * Success condition:
 *    Call to pdf_time_to_string should not return NULL
 */
START_TEST (pdf_time_to_string_004)
{
  pdf_time_t time_obj_1;
    
  struct pdf_time_cal_s time_cal_obj_1; /* Span of Jan 1 2008-01-01 12:10:10 IST */

  time_cal_obj_1.year=2008;
  
  time_cal_obj_1.month=1;
    
  time_cal_obj_1.day=1;
    
  time_cal_obj_1.dow=1;

  time_cal_obj_1.hour=12;

  time_cal_obj_1.minute=10;

  time_cal_obj_1.gmt_offset=4; /* Offset IST */

  time_cal_obj_1.second=10;  

  time_obj_1 = pdf_time_new();
  
  pdf_time_from_cal(time_obj_1,time_cal_obj_1);

  fail_if((pdf_time_to_string(time_obj_1,PDF_TIME_FORMAT_GENERALIZED_ASN1)) == NULL);
 
  pdf_time_destroy(time_obj_1);		   
	
}
END_TEST

/*
 * Test case creation function
 */
TCase *
test_pdf_time_to_string (void)
{
  TCase *tc = tcase_create("pdf_time_to_string");
  tcase_add_test(tc, pdf_time_to_string_001);
  tcase_add_test(tc, pdf_time_to_string_002);
  tcase_add_test(tc, pdf_time_to_string_003);
  tcase_add_test(tc, pdf_time_to_string_004);
  	
  return tc;
}

/* End of pdf-time-to-string.c */
