#ifndef PDF_TIME_TEST_COMMON_H
#define PDF_TIME_TEST_COMMON_H

#include <pdf.h>

/* Size of pdf_time_cal_span_s calspan[] table */
#define DAY_TIME_SPAN_SIZE 32
#define YEAR_MONTH_SIZE 30

#define DATES_SIZE 86

#define SEC_IN_DAY 24*60*60
#define SEC_IN_LEEP_YEAR 366*SEC_IN_DAY
#define SEC_IN_NOLEEP_YEAR 365*SEC_IN_DAY

#define DATE_01_01_1970 0
#define DATE_05_03_1970 (31 + 28 + 5)*SEC_IN_DAY
#define DATE_01_01_2000 946684800

#define DATE_01_01_2009 1230768000
#define DATE_01_12_2009 DATE_01_01_2009 + SEC_IN_NOLEEP_YEAR - 31*SEC_IN_DAY
#define DATE_01_01_1950 -631152000

//void print_pdf_time_cal(pdf_time_t t);

#endif
