#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>


#include "iThread.h"






/*
	Starts executing the thread. Needs to clean up memory a tad better.
*/

void ithread_run(myperl_iThread* thread) {
	SV* thread_tid_ptr;
	SV* thread_ptr;
	PERL_SET_CONTEXT(thread->interp);
	
	PL_perl_destruct_level = 2;
	pthread_mutex_lock(&thread_list_mutex);
	PERL_SET_CONTEXT(shared_sv_space);
	thread_tid_ptr = Perl_newSViv(shared_sv_space, (IV) thread->tid);
	thread_ptr = Perl_newSViv(shared_sv_space, (IV) thread);	
	Perl_hv_store_ent(shared_sv_space,hv_threads, thread_tid_ptr, thread_ptr,0);
   SvREFCNT_dec(thread_tid_ptr);
	PERL_SET_CONTEXT(thread->interp);
	pthread_mutex_unlock(&thread_list_mutex);


	{
		dTHXa(thread->interp);
		AV* params;
		I32 len;
		int i;
		dSP;
		params = (AV*) SvRV(thread->init_params);
		len = av_len(params);
		ENTER;
		SAVETMPS;
		PUSHMARK(SP);
		if(len > -1) {
			for(i = 0; i < len + 1; i++) {
				XPUSHs(av_shift(params));
			}	
		}
		PUTBACK;
	 	call_sv(thread->thread_function_start, G_DISCARD);
		FREETMPS;
		LEAVE;

		SvREFCNT_dec(thread->thread_function_start);

	}



	pthread_mutex_lock(thread->mutex);
 	perl_destruct(thread->interp);	
	perl_free(thread->interp);
	thread->active = 0;
//	if(thread->detached) {
//		Safefree(thread->init_params);
//		Safefree(thread->thread_function_start);
//		Safefree(thread->mutex);
//	  	Safefree(thread);
//		thread->clean = 1;	
//	}
//	thread->clean = 1;
	pthread_mutex_unlock(thread->mutex);
   pthread_exit(0);
}



/*
	iThread->create();
*/

SV* ithread_create(char* class, SV* function_to_call, SV* params) {
	myperl_iThread* thread = malloc(sizeof(myperl_iThread));
   SV*      obj_ref;
   SV*      obj;
	SV*		temp_store;
   I32		result;
	PerlInterpreter *current_perl;

	pthread_mutex_lock(&create_mutex);  
	obj_ref = newSViv(0);
	obj = newSVrv(obj_ref, class);
   sv_setiv(obj, (IV)thread);
   SvREADONLY_on(obj);


   current_perl = Perl_get_context();	

	/*
		here we put the values of params and function to call onto namespace, this is so perl will properly 		clone them when we call perl_clone.
	*/
	


	temp_store = Perl_get_sv(current_perl, "iThread::paramtempstore", TRUE | GV_ADDMULTI);
	Perl_sv_setsv(current_perl, temp_store,params);
	params = NULL;
	temp_store = NULL;

	temp_store = Perl_get_sv(current_perl, "iThread::calltempstore", TRUE | GV_ADDMULTI);
	Perl_sv_setsv(current_perl,temp_store, function_to_call);
	function_to_call = NULL;
	temp_store = NULL;
	


	thread->interp = perl_clone(current_perl,0);

	result = Perl_call_pv(thread->interp,"iThread::Shared::clone_vars",G_VOID | G_DISCARD | G_NOARGS);

	thread->thread_function_start = newSVsv(Perl_get_sv(thread->interp, "iThread::calltempstore",FALSE));
	thread->init_params = newSVsv(Perl_get_sv(thread->interp, "iThread::paramtempstore",FALSE));



	/*
		And here we make sure we clean up the data we put in the namespace of iThread, both in the new and the calling inteprreter
	*/

	

	temp_store = Perl_get_sv(thread->interp,"iThread::paramtempstore",FALSE);
	Perl_sv_setsv(thread->interp,temp_store, &PL_sv_undef);

	temp_store = Perl_get_sv(thread->interp,"iThread::calltempstore",FALSE);
	Perl_sv_setsv(thread->interp,temp_store, &PL_sv_undef);


		
	
	PERL_SET_CONTEXT(current_perl);


	temp_store = Perl_get_sv(current_perl,"iThread::paramtempstore",FALSE);
	Perl_sv_setsv(current_perl, temp_store, &PL_sv_undef);


	temp_store = Perl_get_sv(current_perl,"iThread::calltempstore",FALSE);
	Perl_sv_setsv(current_perl, temp_store, &PL_sv_undef);



	thread->active = 1;
	thread->detached = 0;

	thread->mutex = (pthread_mutex_t*) malloc(sizeof(pthread_mutex_t));
	pthread_mutex_init(thread->mutex,NULL);



	pthread_create( &thread->tid, NULL, (void *) &ithread_run, thread);
	pthread_mutex_unlock(&create_mutex);	



  return obj_ref;
}

/*
	returns the id of the thread
*/
int ithread_tid (SV* obj) {
   myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
	return thread->tid;
}

SV* ithread_self (char* class) {
   SV*      obj_ref;
   SV*      obj;
	SV*		thread_tid_ptr;
	SV*		thread_ptr;
	HE*		thread_entry;
	PerlInterpreter*	old_context;

	old_context = Perl_get_context();
	PERL_SET_CONTEXT(shared_sv_space);
	thread_tid_ptr = Perl_newSViv(shared_sv_space, (IV) pthread_self());

	pthread_mutex_lock(&thread_list_mutex);
	thread_entry = Perl_hv_fetch_ent(shared_sv_space,hv_threads, thread_tid_ptr, 0,0);
	thread_ptr = HeVAL(thread_entry);
	SvREFCNT_dec(thread_tid_ptr);
	pthread_mutex_unlock(&thread_list_mutex);
	
	PERL_SET_CONTEXT(old_context);
	

	obj_ref = newSViv(0);
	obj = newSVrv(obj_ref, class);
   sv_setsv(obj, thread_ptr);
   SvREADONLY_on(obj);
	return obj_ref;
}

/*
	joins the thread
	this code needs to take the returnvalue from the call_sv and send it back
*/

void ithread_join(SV* obj) {
	void *retval;
 	myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
  	pthread_join(thread->tid, &retval);
}


/*
	detaches a thread
	needs to better clean up memory
*/

void ithread_detach(SV* obj) {
	myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
	//pthread_mutex_lock(thread->mutex);
	//thread->detached = 1;
	pthread_detach(thread->tid);
	//pthread_mutex_unlock(thread->mutex);
}



void ithread_DESTROY (SV* obj) {
	myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
	return;
//	pthread_mutex_lock(thread->mutex);
//	if(thread->detached == 1) {
//		printf("We are detached");
//		pthread_mutex_unlock(thread->mutex);
//	}	else if(thread->active == 1) {
//		printf("Detatching thread\n");
//	pthread_mutex_unlock(thread->mutex);
//		ithread_detach(obj);
	
//	} else if(thread->clean == 1) {
//		pthread_mutex_unlock(thread->mutex);
//	} else {
//		printf("Freeing stuff\n");
//		pthread_mutex_unlock(thread->mutex);
//
//		Safefree(thread->init_params);
//		Safefree(thread->thread_function_start);
//		Safefree(thread->mutex);
//  	Safefree(thread);

//	}
}

void ithread_cleanup () {
	PerlInterpreter* old_context = Perl_get_context();
	if(Perl_get_context() == first_interpreter) {
		PERL_SET_CONTEXT(shared_sv_space);
//		printf("Cleaning up!\n");
	
//		perl_destruct(shared_sv_space);
//		perl_free(shared_sv_space);
		PERL_SET_CONTEXT(old_context);
	}
}

void ithread_refcnt_dec_fix (SV* ref) {
	SvREFCNT_dec(SvRV(ref));
}

SV* ithread_shared_sv__new(char* class) { /* Creates a new iThread::Shared::SV */
	dTHX;
	ithread_shared_sv* object = malloc(sizeof(ithread_shared_sv));
	SV* obj_ref;
	SV* obj;
	obj_ref = newSViv(0);
	obj = newSVrv(obj_ref, class);
   sv_setiv(obj, (IV)object);
   SvREADONLY_on(obj);
	object->lock = (pthread_mutex_t*) malloc(sizeof(pthread_mutex_t));
   pthread_mutex_init(object->lock,NULL);
	object->cond = (pthread_cond_t*) malloc(sizeof(pthread_cond_t));
	pthread_cond_init(object->cond,NULL);
	return obj_ref;
}

SV* ithread_shared_sv_new(char* class) {
	PerlInterpreter *old_context = Perl_get_context();
	SV* obj;
	ithread_shared_sv* object;
	{
		dTHX;
		obj = ithread_shared_sv__new(class);
		{
			object = (ithread_shared_sv*)SvIV(SvRV(obj));
			
		}
	}
	PERL_SET_CONTEXT(shared_sv_space);
	object->sv = Perl_newSVsv(shared_sv_space, (SV*) &PL_sv_undef);
	PERL_SET_CONTEXT(old_context);
	return obj;
}

SV* ithread_shared_av_new(char* class) {
	dTHX;
	SV* obj = ithread_shared_sv__new(class);
	{
		ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
		object->sv = (SV*) Perl_newAV(shared_sv_space);;
	}
	return obj;
}

SV* ithread_shared_hv_new(char* class) {
	dTHX;
	SV* obj = ithread_shared_sv__new(class);
	ithread_shared_sv_set(obj,(SV*)Perl_newHV(shared_sv_space));
	return obj;
}

void ithread_shared_av_push(SV* obj, SV* shared_obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PerlInterpreter* old_context = Perl_get_context();
	PERL_SET_CONTEXT(shared_sv_space);
	Perl_av_push(shared_sv_space,(AV*) object->sv, Perl_newSViv(shared_sv_space,SvIV(shared_obj)));
	PERL_SET_CONTEXT(old_context);

}

void ithread_shared_av_unshift(SV* obj, SV* shared_obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PerlInterpreter *old_context = Perl_get_context();
	PERL_SET_CONTEXT(shared_sv_space);
	Perl_av_unshift(shared_sv_space,(AV*) object->sv,1);
	SvREFCNT_inc(shared_obj);
	Perl_av_store(shared_sv_space,(AV*) object->sv,0,Perl_newSViv(shared_sv_space,SvIV(shared_obj)));	
	PERL_SET_CONTEXT(old_context);
}

SV* ithread_shared_av_shift(SV* obj) {
	dTHX;
	SV* retval;
	PerlInterpreter *old_context = Perl_get_context();
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PERL_SET_CONTEXT(shared_sv_space);
	retval = Perl_av_shift(shared_sv_space,(AV*) object->sv);	
	PERL_SET_CONTEXT(old_context);
	retval = newSVsv(retval);
	return retval;	
}

SV* ithread_shared_av_pop(SV* obj) {
	dTHX;
	SV* retval;
	PerlInterpreter *old_context = Perl_get_context();
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PERL_SET_CONTEXT(shared_sv_space);
	retval = Perl_av_pop(shared_sv_space,(AV*) object->sv);	
	PERL_SET_CONTEXT(old_context);
	retval = newSVsv(retval);
	return retval;	
}

void ithread_shared_av_store(SV* obj, I32 index,SV* shared_obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PerlInterpreter *old_context = Perl_get_context();
	PERL_SET_CONTEXT(shared_sv_space);
	SvREFCNT_inc(shared_obj);
	Perl_av_store(shared_sv_space,(AV*) object->sv,index,Perl_newSViv(shared_sv_space,SvIV(shared_obj)));	
	PERL_SET_CONTEXT(old_context);
}

void ithread_shared_sv_set(SV* obj, SV* value) {
	dTHX;
 	PerlInterpreter* old_context = Perl_get_context();
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PERL_SET_CONTEXT(shared_sv_space);	
	Perl_sv_setsv(shared_sv_space, object->sv, value);
	PERL_SET_CONTEXT(old_context);
}

SV* ithread_shared_sv_get(SV* obj) {
	dTHX;
	SV* retval;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	return newSVsv(object->sv);
}



SV* ithread_shared_sv_attach(char* class, SV* ptr) {
	dTHX;
	
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(ptr);	
	SV* obj_ref;
	SV* obj;
	if(SvIV(ptr) == 0) {
		Perl_croak(Perl_get_context(),"fuck");
	}
	obj_ref = newSViv(0);
	if(SvTYPE(object->sv) == SVt_PVAV) {
			obj = newSVrv(obj_ref, ithread_shared_av_class);
	}	else {
			obj = newSVrv(obj_ref, ithread_shared_sv_class);
	}
	sv_setiv(obj, SvIV(ptr));
   	SvREADONLY_on(obj);
	return obj_ref;
}

void ithread_shared_sv_dump(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));	
	Perl_sv_dump(shared_sv_space,object->sv);
}	

SV* ithread_shared_sv_ref(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
//	return Perl_newRV(shared_sv_space,object->sv);
	return Perl_newRV(Perl_get_context(),object->sv);
}

void ithread_shared_sv_refinc(SV* obj) {
	dTHX;
	PerlInterpreter *old_context = Perl_get_context();
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	PERL_SET_CONTEXT(shared_sv_space);
	SvREFCNT_inc(object->sv);
	PERL_SET_CONTEXT(old_context);
}

void ithread_shared_sv_refdec(SV* obj) {
	dTHX;
	PerlInterpreter *old_context = Perl_get_context();
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));


	PERL_SET_CONTEXT(shared_sv_space);
	if(SvREFCNT(object->sv) == 1) {
		SvREFCNT_dec(object->sv);
		Safefree(object->lock);
		Safefree(object->cond);
		Safefree(object);
	//	printf("DESTRUCT\n");
	} else {
		SvREFCNT_dec(object->sv);
	}
	PERL_SET_CONTEXT(old_context);
}

void ithread_shared_sv_lock(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	pthread_mutex_lock(object->lock);
}

void ithread_shared_sv_unlock(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	pthread_mutex_unlock(object->lock);
}

void ithread_shared_sv_cond_wait(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	pthread_cond_wait(object->cond, object->lock);
}

void ithread_shared_sv_cond_signal(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	pthread_cond_signal(object->cond);
}

void ithread_shared_sv_cond_broadcast(SV* obj) {
	dTHX;
	ithread_shared_sv* object = (ithread_shared_sv*)SvIV(SvRV(obj));
	pthread_cond_broadcast(object->cond);
}

MODULE = iThread		PACKAGE = iThread		
BOOT:
   first_interpreter = Perl_get_context();
	shared_sv_space = perl_clone(first_interpreter,0);
/*   shared_sv_space = perl_alloc();
   perl_construct(shared_sv_space); */
	PERL_SET_CONTEXT(shared_sv_space); 
	PL_perl_destruct_level = 2;
	hv_threads = Perl_newHV(shared_sv_space);
   PERL_SET_CONTEXT(first_interpreter);
	PL_perl_destruct_level = 2;



PROTOTYPES: DISABLE

SV *
create (class, function_to_call, ...)
        char *  class
        SV *    function_to_call
		CODE:
			AV* params = newAV();
			if(items > 2) {
				int i;
				for(i = 2; i < items ; i++) {
					av_push(params, ST(i));
				}
			}
			RETVAL = ithread_create(class, function_to_call, newRV_noinc((SV*) params));
			OUTPUT:
			RETVAL

SV *
self (class)
		char* class
	CODE:
		RETVAL = ithread_self(class);
	OUTPUT:
		RETVAL

int
tid (obj)	
		SV *	obj;
	CODE:
		RETVAL = ithread_tid(obj);
	OUTPUT:
	RETVAL

void
join (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        ithread_join(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */

void
detach (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        ithread_detach(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */





void
DESTROY (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        ithread_DESTROY(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */

void
cleanup()
        		PPCODE:
				ithread_cleanup();
			   XSRETURN_EMPTY;

void
refcnt_dec_fix(obj)
				SV* obj
        		PPCODE:
				ithread_refcnt_dec_fix(obj);
			   XSRETURN_EMPTY;


MODULE =	iThread		PACKAGE = iThread::Shared::SV



SV*
new_sv(class)
				char* class
				CODE:
				RETVAL = ithread_shared_sv_new(class);
				OUTPUT:
				RETVAL

	
SV*
new_av(class)
				char* class
				CODE:
				RETVAL = ithread_shared_av_new(class);
				OUTPUT:
				RETVAL

SV*
new_hv(class)
				char* class
				CODE:
				RETVAL = ithread_shared_hv_new(class);
				OUTPUT:
				RETVAL


SV*
get(obj)
				SV* obj
				CODE:
				RETVAL = ithread_shared_sv_get(obj);
				OUTPUT:
				RETVAL


SV*
ref(obj)
				SV* obj
				CODE:
				RETVAL = ithread_shared_sv_ref(obj);
				OUTPUT:
				RETVAL

SV*
attach(class,ptr)
				char* class
				SV* ptr
				CODE:
				RETVAL = ithread_shared_sv_attach(class,ptr);
				OUTPUT:
				RETVAL

void
dump(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_dump(obj);
			   XSRETURN_EMPTY;





void
set(obj, value)
				SV* obj
				SV* value
        		PPCODE:
				ithread_shared_sv_set(obj, value);
			   XSRETURN_EMPTY;



void
thrcnt_inc(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_refinc(obj);
			   XSRETURN_EMPTY;



void
thrcnt_dec(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_refdec(obj);
			   XSRETURN_EMPTY;

void
lock(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_lock(obj);
			   XSRETURN_EMPTY;

void
unlock(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_unlock(obj);
			   XSRETURN_EMPTY;

void
cond_wait(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_wait(obj);
			   XSRETURN_EMPTY;

void
cond_signal(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_signal(obj);
			   XSRETURN_EMPTY;

void
cond_broadcast(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_broadcast(obj);
			   XSRETURN_EMPTY;



MODULE =	iThread		PACKAGE = iThread::Shared::AV


SV*
new(class)
				char* class
				CODE:
				RETVAL = ithread_shared_av_new(class);
				OUTPUT:
				RETVAL


void
push(obj, value)
				SV* obj
				SV* value
				PPCODE:
				ithread_shared_av_push(obj,value);
				XSRETURN_EMPTY;

void
unshift(obj, value)
				SV* obj
				SV* value
				PPCODE:
				ithread_shared_av_unshift(obj,value);
				XSRETURN_EMPTY;



SV*
shift(obj)
				SV* obj
				CODE:
				RETVAL = ithread_shared_av_shift(obj);
				OUTPUT:
				RETVAL

SV*
pop(obj)
				SV* obj
				CODE:
				RETVAL = ithread_shared_av_pop(obj);
				OUTPUT:
				RETVAL

void
store(obj, index, value)
				SV* obj
				I32 index
				SV* value
				PPCODE:
				ithread_shared_av_store(obj,index,value);
				XSRETURN_EMPTY;

void
lock(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_lock(obj);
			   XSRETURN_EMPTY;

void
unlock(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_unlock(obj);
			   XSRETURN_EMPTY;

void
cond_wait(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_wait(obj);
			   XSRETURN_EMPTY;

void
cond_signal(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_signal(obj);
			   XSRETURN_EMPTY;

void
cond_broadcast(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_cond_broadcast(obj);
			   XSRETURN_EMPTY;

SV*
ref(obj)
				SV* obj
				CODE:
				RETVAL = ithread_shared_sv_ref(obj);
				OUTPUT:
				RETVAL


void
thrcnt_inc(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_refinc(obj);
			   XSRETURN_EMPTY;



void
thrcnt_dec(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_refdec(obj);
			   XSRETURN_EMPTY;

void
dump(obj)
				SV* obj
        		PPCODE:
				ithread_shared_sv_dump(obj);
			   XSRETURN_EMPTY;