
package iThread::Shared;

use iThread::Shared::Lock;
use strict;
use Scalar::Util qw(weaken isweak);
require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(MODIFY_SCALAR_ATTRIBUTES 
		 MODIFY_ARRAY_ATTRIBUTES
		 lock unlock cond_wait cond_broadcast cond_signal share);

our %shared;
use Carp;
use attributes qw(reftype);


use fields qw(
	      value
	      locks
	      lock_real
	      lock_object
	      );

sub new {
    my __PACKAGE__ $self = shift;
    $self->{locks} = 0;
    $self->{lock_real} = 0;
    $self->{lock_object} = 0;
#    print "Add ${$self->{value}} $self $self->{value}\n";
    my $ptr = $self->{value}; $ptr = $$ptr;
#    print "Adding $ptr\n";
    $shared{$ptr} = $self;
    weaken( $shared{$ptr});
    return $self;
}




	      
sub MODIFY_SCALAR_ATTRIBUTES {
    my $class = shift;
    my $value = shift;
    tie $$value, 'iThread::Shared::Scalar';
    return ();
}

sub MODIFY_ARRAY_ATTRIBUTES {
    my $class = shift;
    my $value = shift;
    tie @$value, 'iThread::Shared::Array';
    return ();
}

sub lock(\$) {
    my $ref = shift;
    my $self = iThread::Shared->shared_ref($ref);
    croak("Cannot call lock on $ref") unless(UNIVERSAL::isa($self,'iThread::Shared'));
    my $context = wantarray;
    die "Cannot be called in list context" if(wantarray);
    if(defined(wantarray)) {
	return iThread::Shared::Lock->new($self);
    } else {
	$self->{lock_real}++;
	$self->_lock();
	return undef;
    }
}

sub _lock {
    my __PACKAGE__ $self = shift;
    $self->{locks}++;
    return if($self->{locks} > 1);
#    print "Lock\n";
#    print "Lock ${$self->{value}} $self\n";
    $self->{value}->lock();
#    print "Locked ${$self->{value}}\n";
}



sub unlock(\$) {
    my $ref = shift;
    my $self = iThread::Shared->shared_ref($ref);
    die("Cannot call unlock on $ref") unless(UNIVERSAL::isa($self,'iThread::Shared'));
    $self->{lock_real}--;
    $self->_unlock();
}

sub _unlock {
    my __PACKAGE__ $self = shift;
    $self->{locks}--;
    return if($self->{locks});
#    print "Unlock ${$self->{value}}\n";
    $self->{value}->unlock();
}

sub cond_wait (\$) {
    my $ref = shift;
    my $self = iThread::Shared->shared_ref($ref);
    die("Cannot call unlock on $ref") unless(UNIVERSAL::isa($self,'iThread::Shared'));
    $self->{value}->cond_wait();
}

sub cond_signal (\$) {
    my $ref = shift;
    my $self = iThread::Shared->shared_ref($ref);
    die("Cannot call unlock on $ref") unless(UNIVERSAL::isa($self,'iThread::Shared'));
    $self->{value}->cond_signal();
}

sub cond_broadcast (\$) {
    my $ref = shift;
    my $self = iThread::Shared->shared_ref($ref);
    die("Cannot call unlock on $ref") unless(UNIVERSAL::isa($self,'iThread::Shared'));
    $self->{value}->cond_broadcast();
}

sub DESTROY {
    my __PACKAGE__ $self = shift;
    my $ptr = $self->{value};
    $ptr = $$ptr;
#    print "Delete $ptr\n";
    delete($shared{$ptr});
    $self->{value}->thrcnt_dec();
#   print "Delete ${$self->{value}}\n";
}

sub clone_vars {
    foreach my $ptr (keys %shared) {
	iThread::refcnt_dec_fix($shared{$ptr});
	  $shared{$ptr}->{value}->thrcnt_inc();
    }
}

sub shared_ref {
    my __PACKAGE__ $self = shift;
    my $value = shift;
    return undef unless(ref($value));
    my $ref = reftype($value);
    if($ref eq 'REF') {
	$value = $$value;
	$ref = reftype($value);
    }
    return $value if(UNIVERSAL::isa($value,'iThread::Shared'));
    return tied $$value if($ref eq 'SCALAR' && tied $$value);
    return tied @$value if($ref eq 'ARRAY' && tied @$value);
    return undef;
#   die "Unknown ref of type $ref for value $value\n";
}



sub share {
    my __PACKAGE__ $self;
    if(@_ == 1) {
	$self = __PACKAGE__;
    } else {
	$self = shift;
    }
    my $value = shift;
    return $value if($self->shared_ref($value));
    if(my $foo = ref($value)) {
	if($foo eq 'ARRAY') {
	    my @array;
	    tie @array, 'iThread::Shared::Array';
	    foreach my $entry (@$value) {
		push @array, $self->share($entry);
	    }
	    return \@array;
	}
	die "We cannot share $foo refs, share the damn ref instead\n";

    } else {
	my $string;
	tie $string, 'iThread::Shared::Scalar';
	$string = $value;
	return \$string;
    }
}


sub attach {
    my __PACKAGE__ $self = shift;
    my $ptr = shift;
  Carp::confess("pointer $ptr can't be 0") unless($ptr);
    my $var;
#    print "Check pointer $ptr\n";
    if(exists($shared{$ptr})) {
#	print "It already exists!!\n";
	$var = $shared{$ptr};
    } else {
	$var = iThread::Shared::SV->attach($ptr);
	if(ref($var) eq 'iThread::Shared::SV') {
	    $var = iThread::Shared::Scalar->new($var);
	    $var->{value}->thrcnt_inc();
	} elsif(ref($var) eq 'iThread::Shared::AV') {
	    $var = iThread::Shared::Array->new($var);
	    $var->{value}->thrcnt_inc();
	}	
    }
    
    if(ref($var) eq 'iThread::Shared::Scalar') {
	my $string;
	tie $string, 'iThread::Shared::Scalar', $var;
	return (\$string,$var);
	
    } elsif(ref($var) eq 'iThread::Shared::Array') {
	my $array = [];
	tie @$array,'iThread::Shared::Array', $var;
	return ($array, $var);
    }
    
    return $var;
}


package iThread::Shared::Scalar;
use base 'iThread::Shared';


sub new {
    my __PACKAGE__ $self = fields::new(shift);
    my $value = shift;
    if($value) {
	$self->{value} = $value;
    } else {
	$self->{value} = iThread::Shared::SV->new_sv();
    }
    $self->SUPER::new();
    return $self;
}

sub TIESCALAR {
    my $class = shift;
    my $value = shift;
    if(ref($value)) {
	return $value;
    }
    my $self = $class->new();
    return $self;
}

sub STORE {
    my __PACKAGE__ $self = shift;
    my $value = shift;
    $self->_lock();
    $self->{value}->set($value);
    $self->_unlock();
}

sub FETCH {
    my __PACKAGE__ $self = shift;
    $self->_lock();
    my $return = $self->{value}->get();
    $self->_unlock();
    return $return;
}

package iThread::Shared::Array;
use base 'iThread::Shared';

use Devel::Peek qw(Dump SvREFCNT_inc);

sub new {
    my __PACKAGE__ $self = fields::new(shift);
    my $value = shift;
    if($value) {
	$self->{value} = $value;
    } else {
	$self->{value} = iThread::Shared::AV->new();
    }
    $self->SUPER::new();
    return $self;
}

sub TIEARRAY {
    my $class = shift;
    my $value = shift;
    if(ref($value)) {
	return $value;
    }
    return $class->new();
}

sub CLEAR {
    my __PACKAGE__ $self = shift;
    $self->_lock();
    my $av = $self->{value}->ref();

    my $return = @$av = ();
    undef($av);
    $self->_unlock();
    return $return;
}

sub EXTEND {
#    print @_;
#    print "FOO\n";
}

sub FETCH {
    my __PACKAGE__ $self = shift;
    my $index = shift;
#    print "FETCH $self $index\n";
    $self->_lock();
    my ($return,$tied);
    my $av = $self->{value}->ref();
    $return = $av->[$index];
    undef($av);
    $self->_unlock();
    return undef if(!defined($return));
    ($return,$tied) = $self->attach($return);
    if(ref($return) eq 'SCALAR') {
	return $$return;
    } else {
	return $return;
    }
}

sub STORE {
    my __PACKAGE__ $self = shift;
    my $index = shift;
    my $value = shift;
    my $tied = $self->shared_ref($self->share($value));
    $self->_lock();
    my $return;
    my $ptr = $tied->{value};
    $ptr = $$ptr;
    $self->{value}->store($index,$ptr);
    $tied->{value}->thrcnt_inc();
    $self->_unlock();
    return $return;
}



sub PUSH {
    my __PACKAGE__ $self = shift;
    my $value = shift;
    my $tied = $self->shared_ref($self->share($value));
    $self->_lock();
    my $return;

    my $ptr = $tied->{value};
    $ptr = $$ptr;
    $self->{value}->push($ptr);
    $tied->{value}->thrcnt_inc();
    $self->_unlock();
    return $return;
}

sub UNSHIFT {
    my __PACKAGE__ $self = shift;
    my $value = shift;
    my $tied = $self->shared_ref($self->share($value));
    $self->_lock();
    my $return;

    my $ptr = $tied->{value};
    $ptr = $$ptr;
    $self->{value}->unshift($ptr);
    $tied->{value}->thrcnt_inc();
    $self->_unlock();
    return $return;
}

sub SHIFT {
    my __PACKAGE__ $self = shift;
    my($val,$return,$tied);
    $self->_lock();
    $val = $self->{value}->shift();
    $self->_unlock();
    ($return,$tied) = $self->attach($val);
    $tied->{value}->thrcnt_dec();
    if(ref($return) eq 'SCALAR') {
	return $$return;    
    } else {
	return $return;    
    }
}

sub POP {
    my __PACKAGE__ $self = shift;
    my($val,$return,$tied);
    $self->_lock();
    $val = $self->{value}->pop();
    $self->_unlock();
    ($return,$tied) = $self->attach($val);
    $tied->{value}->thrcnt_dec();
    if(ref($return) eq 'SCALAR') {
	return $$return;    
    } else {
	return $return;    
    }
}

sub FETCHSIZE {
    my __PACKAGE__ $self = shift;
    $self->_lock();
    my $av = $self->{value}->ref();
    my $return = scalar @$av;
    undef($av);
    $self->_unlock();
    return $return;
    
}

sub iThread::Shared::AV::DESTROY {
#    print "Destroy ${$_[0]} $_[0]\n";
}

sub iThread::Shared::SV::DESTROY {
#    print "Destroy $_[0]\n";
}


package iThread::Shared;



1;












