package Rx;
use strict;
no strict 'refs';

# An atomic rule imcc code  enters from the start  falls thru in case of success
# We special case it; so at the price of some more code, we get leaner imcc.

my $_dbg = '_dbg' if $::mode =~ m/dbg/;

our $AUTOLOAD;

sub AUTOLOAD {
    die qq|Undefined routine $AUTOLOAD| unless $AUTOLOAD =~ m/_ep$/;
#    print "$AUTOLOAD\n";    
     *$AUTOLOAD = \&lit_ep;
     &$AUTOLOAD
}

my $indent;

sub indent { 
  local ($_) = @_;

   s/(.*)$/ ('    ' x $indent) . $1 /mge;
   $_;
}


my %atomic = ( 
  lit => 'rx_literal s, i'
);


sub suf {
  my ($id, $win, $fail, $sufnm, @arg) = @_;
  $indent++;
  my ($kid1, $id1, @arg1) =  @{$arg[0]};
  if ( $sufnm eq '?' ) {
    return (&$kid1($id1, $win, $fail, @arg1));
  }
  if ( $sufnm eq '??' ) {
    return (&$kid1($id1, $win, $fail, @arg1));
  }
  if ( $sufnm eq '*') {
    my $imcc_kid = indent $atomic{$kid1} ?
      qq|  $atomic{$kid1}, "$arg1[0]", $win\n| :
      &$kid1($id1, "rx_star_$id", "rx_more_$id", @arg1);

  $indent--;
  return indent <<"EOF";
# suf $sufnm $id
rx_init_$id:
  .rx_pushmark$_dbg()
rx_star_$id:
  .rx_pushindex$_dbg(i)
  $imcc_kid
  goto rx_star_$id
rx_more_$id:
  .rx_popindex$_dbg(i, $fail)
  goto $win
EOF

  }

  if ( $sufnm eq '*?') {
      my $imcc_kid = indent &$kid1($id1, $win, "rx_fail_kid_$id", @arg1);

  $indent--;
  return indent <<"EOF";
# suf $sufnm $id
rx_init_$id:
  .rx_pushmark$_dbg()
  goto $win
rx_fail_kid_$id:
  .rx_popindex$_dbg(i, $fail)
rx_more_$id:
#  .rx_pushindex$_dbg(i)
  $imcc_kid
  goto $win
# end suf $sufnm $id
EOF


  }

}

sub suf_ep {
  my ($id, $sufnm, @arg) = @_;
#  my ($nm1, @arg1) = @{$arg[1]};
  if ( $sufnm eq '*?') {
      return "rx_init_$id", "rx_more_$id";
  }
  if ( $sufnm eq '*') {
      return "rx_init_$id", "rx_more_$id";
  }
#      &{"${nm1}_ep"}(@arg1);
}


sub seq_ep {   
  my ($id, @arg) = @_;
  my ($nm0, @arg0) = @{$arg[0]};
  &{"${nm0}_ep"}(@arg0);
}

sub lit_ep { my ($id) = @_;
  "rx_init_$id", "rx_more_$id";
}

sub not_ep {
  my (undef, $arg) = @_;
  my ($nm0, @arg0) = @$arg;
  return &{"${nm0}_ep"}(@arg0);
}

sub not {
  my ($id, $win, $fail, $arg) = @_;
  my ($nm1, $id1, @arg1) =  @$arg;
  &$nm1($id1, $fail, $win,     @arg1);
}


*altern_ep = \&seq_ep;
# *backslashed_ep = \&lit_ep;

sub seq { 
  my ($id, $win, $fail, @arg) = @_;
  my ($nm1, $id1, @arg1) =  @{$arg[0]};
  my ($nm2, $id2, @arg2) =  @{$arg[1]};
  my $more_id1 = (&{"${nm1}_ep"}($id1, @arg1))[1];
  my $init_id2 = (&{"${nm2}_ep"}($id2, @arg2))[0];

  return                    indent( "# seq $id\n")                             .
                (++$indent, indent(&$nm1($id1, $init_id2, $fail,     @arg1)) ) .
                (++$indent,  indent(&$nm2($id2, $win,      $more_id1, @arg2))) .
                (--$indent, indent( "# seq $id end\n")                       )

}

sub altern { 
  my ($id, $win, $fail, @arg) = @_;
  my ($nm1, $id1, @arg1) =  @{$arg[0]};
  my ($nm2, $id2, @arg2) =  @{$arg[1]};
  my $init_id2 = (&{"${nm2}_ep"}($id2, @arg2))[0];
  return              indent( "# altern $id\n")                       .
         ( ++$indent, indent (&$nm1($id1, $win, $init_id2, @arg1))  ) .
         ( --$indent, indent( "# altern $id (follow up)\n")         ) .
         ( ++$indent, indent(&$nm2($id2, $win,        $fail, @arg2))) .
         ( --$indent, indent( "# altern $id end\n")                 )

}



sub win {
   my ($id, $win, $fail,  @arg) = @_;
   return " goto $win\n";
}

sub fail {
   my ($id, $win, $fail,  @arg) = @_;
   return " goto $fail\n";
}

my %backslashed = (
  d => '.rx_is_d',
  D => '.rx_is_D'
);

sub backslashed {
  my ($id, $win, $fail, $char) = @_;
   my ($dbg, $dbg1);
   if ($::mode =~ m/dbg/) {
       $dbg  = qq|\n  print "$backslashed{$char} c, $fail\\n"|;
       $dbg1 = qq|\n  print "succeeded\\n"|;
   }
   return <<"EOF";
# m/\\$char/
rx_init_$id:$dbg
  if i >= l goto $fail
  ord c, s, i
  $backslashed{$char}( c, i, $fail)$dbg1
  goto $win
rx_more_$id:
  goto $fail
EOF

}


sub dbg {
}

sub lit {
   my ($id, $win, $fail,  @arg) = @_;
   my ($dbg, $dbg1);
   if ($::mode =~ m/dbg/) {
       $dbg  = qq|\n  print "rx_literal s, i, \\"$arg[0]\\", $fail\\n"|;
       $dbg1 = qq|\n  print "succeeded\\n"|;
   }
   return <<"EOF";
# m/$arg[0]/
rx_init_$id:$dbg
  rx_literal s, i, "$arg[0]", $fail$dbg1
  goto $win
rx_more_$id:
  goto $fail
# end m/$arg[0]/
EOF
}


sub end {
  return ".end\n";
}

sub finish {
   my ($ctxi, $ctxo) = @_;

my $imcc_end = lbl_more( $ctxo ) .
<<'EOF'
   print "win\n"
   end
EOF

}


1;
