#  Macros defining opcodes equivalent to rx_* opcodes in rx.ops

# .const int QX_MARK = -1

.macro rx_pushmark()
  intsave -1
.endm

.macro rx_pushmark_dbg()
  intsave -1
   print "rx_pushmark\n"
.endm

.macro rx_pushindex(i)
  intsave .i
.endm

.macro rx_pushindex_dbg(i)
  intsave .i
.endm

.macro rx_popindex_dbg (i, label)
  .sym int svi
  svi = .i
  intrestore .i
  if .i == -1 goto .$got_mark
  print "popindex: "
  print .i
  print "\n"
  goto .$end
.local $got_mark:
  print "popindex: got mark"
  .i = svi
  print .i
  print "\n"
  goto .label
.local $end:
.endm

.macro rx_popindex (i, label)
  .sym int svi
  svi = .i
  intrestore .i
  if .i == -1 goto .$got_mark
  goto .$end
.local $got_mark:
  .i = svi
  goto .label
.local $end:
.endm


.macro rx_in_range(c, i, label, start, theend)
  if .c < .start    goto .label
  if .c > .theend   goto .label
  inc .i
.endm

.macro rx_not_in_range(c, i, label, start, theend)
  if .c >= .start  goto maybe_in_range
  goto nxt
maybe_in_range:
  if .c <= .theend  goto .label
nxt:
  inc .i
.endm

.macro rx_is_d(c1, i1, label1)
  .rx_in_range(.c1, .i1, .label1, 48, 57)
.endm

.macro rx_is_D(c2, i2, label2)
  .rx_not_in_range(.c2, .i2, .label2, 48, 57)
.endm
