--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN1';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: share_catalog_delete(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION share_catalog_delete() RETURNS trigger
    AS $$	begin if old.acl_appname = 'contactcenter' and  old.acl_location <> 'run' then delete from phpgw_cc_contact_rels where id_contact=old.acl_location::bigint and id_related=old.acl_account and id_typeof_contact_relation=1; end if; return new; end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.share_catalog_delete() OWNER TO postgres;

--
-- Name: share_catalog_insert(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION share_catalog_insert() RETURNS trigger
    AS $$ begin if new.acl_appname = 'contactcenter' and  new.acl_location <> 'run' then insert into phpgw_cc_contact_rels (id_contact,id_related,id_typeof_contact_relation) values (new.acl_location::integer,new.acl_account,1); end if; return new; end;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.share_catalog_insert() OWNER TO postgres;

--
-- Name: seq_egw_wf_activities; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_activities
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_activities OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: egw_wf_activities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_activities (
    wf_activity_id integer DEFAULT nextval('seq_egw_wf_activities'::regclass) NOT NULL,
    wf_name character varying(80),
    wf_normalized_name character varying(80),
    wf_p_id integer NOT NULL,
    wf_type character varying(25),
    wf_is_autorouted character(1),
    wf_flow_num integer,
    wf_is_interactive character(1),
    wf_last_modif integer,
    wf_description text,
    wf_default_user character varying(200) DEFAULT '*'::character varying,
    wf_menu_path character varying(200)
);


ALTER TABLE public.egw_wf_activities OWNER TO postgres;

--
-- Name: egw_wf_activity_agents; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_activity_agents (
    wf_activity_id integer NOT NULL,
    wf_agent_id integer NOT NULL,
    wf_agent_type character varying(15) NOT NULL
);


ALTER TABLE public.egw_wf_activity_agents OWNER TO postgres;

--
-- Name: egw_wf_activity_roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_activity_roles (
    wf_activity_id integer NOT NULL,
    wf_role_id integer NOT NULL,
    wf_readonly integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.egw_wf_activity_roles OWNER TO postgres;

--
-- Name: egw_wf_admin_access; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_admin_access (
    admin_access_id integer NOT NULL,
    tipo character(3) NOT NULL,
    numvalue smallint NOT NULL,
    nivel integer DEFAULT 0
);


ALTER TABLE public.egw_wf_admin_access OWNER TO postgres;

--
-- Name: seq_egw_wf_agent_mail_smtp; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_agent_mail_smtp
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_agent_mail_smtp OWNER TO postgres;

--
-- Name: egw_wf_agent_mail_smtp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_agent_mail_smtp (
    wf_agent_id integer DEFAULT nextval('seq_egw_wf_agent_mail_smtp'::regclass) NOT NULL,
    wf_to character varying(255) DEFAULT '%roles%'::character varying NOT NULL,
    wf_cc character varying(255),
    wf_bcc character varying(255),
    wf_from character varying(255) DEFAULT '%user%'::character varying,
    wf_replyto character varying(255) DEFAULT '%user%'::character varying,
    wf_subject character varying(255),
    wf_message text,
    wf_send_mode integer DEFAULT 0
);


ALTER TABLE public.egw_wf_agent_mail_smtp OWNER TO postgres;

--
-- Name: seq_egw_wf_external_application; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_external_application
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_external_application OWNER TO postgres;

--
-- Name: egw_wf_external_application; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_external_application (
    external_application_id integer DEFAULT nextval('seq_egw_wf_external_application'::regclass) NOT NULL,
    name character varying(50) NOT NULL,
    description text,
    image character varying(100),
    address character varying(120) NOT NULL,
    authentication bit(1),
    post text,
    intranet_only bit(1)
);


ALTER TABLE public.egw_wf_external_application OWNER TO postgres;

--
-- Name: egw_wf_instance_activities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_instance_activities (
    wf_instance_id integer NOT NULL,
    wf_activity_id integer NOT NULL,
    wf_started integer NOT NULL,
    wf_ended integer,
    wf_user character varying(200),
    wf_status character varying(25)
);


ALTER TABLE public.egw_wf_instance_activities OWNER TO postgres;

--
-- Name: seq_egw_wf_instances; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_instances
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_instances OWNER TO postgres;

--
-- Name: egw_wf_instances; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_instances (
    wf_instance_id integer DEFAULT nextval('seq_egw_wf_instances'::regclass) NOT NULL,
    wf_p_id integer NOT NULL,
    wf_started integer,
    wf_owner character varying(200),
    wf_next_activity bytea,
    wf_next_user text,
    wf_ended integer,
    wf_status character varying(25),
    wf_priority integer DEFAULT 0,
    wf_properties bytea,
    wf_name character varying(120),
    wf_category integer
);


ALTER TABLE public.egw_wf_instances OWNER TO postgres;

--
-- Name: egw_wf_interinstance_relations; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_interinstance_relations (
    wf_parent_instance_id integer NOT NULL,
    wf_parent_activity_id integer NOT NULL,
    wf_child_instance_id integer NOT NULL,
    wf_parent_lock smallint
);


ALTER TABLE public.egw_wf_interinstance_relations OWNER TO postgres;

--
-- Name: egw_wf_job_logs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_job_logs (
    job_id integer NOT NULL,
    date_time timestamp without time zone NOT NULL,
    result bytea,
    status integer
);


ALTER TABLE public.egw_wf_job_logs OWNER TO postgres;

--
-- Name: seq_egw_wf_jobs; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_jobs
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_jobs OWNER TO postgres;

--
-- Name: egw_wf_jobs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_jobs (
    job_id integer DEFAULT nextval('seq_egw_wf_jobs'::regclass) NOT NULL,
    wf_process_id integer NOT NULL,
    name character varying(100) NOT NULL,
    description text,
    time_start timestamp without time zone NOT NULL,
    interval_value integer,
    interval_unity integer,
    date_type integer,
    week_days integer DEFAULT 0,
    month_offset integer DEFAULT 0,
    active boolean
);


ALTER TABLE public.egw_wf_jobs OWNER TO postgres;

--
-- Name: egw_wf_process_config; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_process_config (
    wf_p_id integer NOT NULL,
    wf_config_name character varying(255) NOT NULL,
    wf_config_value text,
    wf_config_value_int integer
);


ALTER TABLE public.egw_wf_process_config OWNER TO postgres;

--
-- Name: seq_egw_wf_processes; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_processes
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_processes OWNER TO postgres;

--
-- Name: egw_wf_processes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_processes (
    wf_p_id integer DEFAULT nextval('seq_egw_wf_processes'::regclass) NOT NULL,
    wf_name character varying(80),
    wf_is_valid character(1),
    wf_is_active character(1),
    wf_version character varying(12),
    wf_description text,
    wf_last_modif integer,
    wf_normalized_name character varying(80)
);


ALTER TABLE public.egw_wf_processes OWNER TO postgres;

--
-- Name: seq_egw_wf_roles; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_roles
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_roles OWNER TO postgres;

--
-- Name: egw_wf_roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_roles (
    wf_role_id integer DEFAULT nextval('seq_egw_wf_roles'::regclass) NOT NULL,
    wf_p_id integer NOT NULL,
    wf_last_modif integer,
    wf_name character varying(80),
    wf_description text
);


ALTER TABLE public.egw_wf_roles OWNER TO postgres;

--
-- Name: egw_wf_transitions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_transitions (
    wf_p_id integer NOT NULL,
    wf_act_from_id integer NOT NULL,
    wf_act_to_id integer NOT NULL
);


ALTER TABLE public.egw_wf_transitions OWNER TO postgres;

--
-- Name: egw_wf_user_cache; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_user_cache (
    uidnumber integer NOT NULL,
    uid character varying(30),
    cn character varying(100),
    givenname character varying(30),
    sn character varying(70),
    mail character varying(80),
    accountstatus character varying(80),
    dn character varying(150),
    employeenumber integer,
    cpf character varying(15),
    telephonenumber character varying(50),
    last_update timestamp without time zone DEFAULT now()
);


ALTER TABLE public.egw_wf_user_cache OWNER TO postgres;

--
-- Name: seq_egw_wf_user_roles; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_user_roles
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_user_roles OWNER TO postgres;

--
-- Name: egw_wf_user_roles; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_user_roles (
    wf_role_id integer DEFAULT nextval('seq_egw_wf_user_roles'::regclass) NOT NULL,
    wf_p_id integer NOT NULL,
    wf_user character varying(200) NOT NULL,
    wf_account_type character(1) DEFAULT 'u'::bpchar NOT NULL
);


ALTER TABLE public.egw_wf_user_roles OWNER TO postgres;

--
-- Name: seq_egw_wf_workitems; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_egw_wf_workitems
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_egw_wf_workitems OWNER TO postgres;

--
-- Name: egw_wf_workitems; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE egw_wf_workitems (
    wf_item_id integer DEFAULT nextval('seq_egw_wf_workitems'::regclass) NOT NULL,
    wf_instance_id integer NOT NULL,
    wf_order_id integer NOT NULL,
    wf_properties bytea,
    wf_activity_id integer NOT NULL,
    wf_started integer,
    wf_ended integer,
    wf_user character varying(200),
    wf_note text,
    wf_action text
);


ALTER TABLE public.egw_wf_workitems OWNER TO postgres;

--
-- Name: phpgw_access_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_access_log (
    sessionid character(32) NOT NULL,
    loginid character varying(30) NOT NULL,
    ip character varying(30) NOT NULL,
    li integer NOT NULL,
    lo integer DEFAULT 0,
    account_id integer DEFAULT 0 NOT NULL,
    browser character varying(200)
);


ALTER TABLE public.phpgw_access_log OWNER TO postgres;

--
-- Name: phpgw_accounts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_accounts (
    account_id integer DEFAULT nextval(('seq_phpgw_accounts'::text)::regclass) NOT NULL,
    account_lid character varying(25) NOT NULL,
    account_pwd character varying(100) NOT NULL,
    account_firstname character varying(50),
    account_lastname character varying(50),
    account_lastlogin integer,
    account_lastloginfrom character varying(255),
    account_lastpwd_change integer,
    account_status character(1) DEFAULT 'A'::bpchar NOT NULL,
    account_expires integer,
    account_type character(1),
    person_id integer,
    account_primary_group integer DEFAULT 0 NOT NULL,
    account_email character varying(100)
);


ALTER TABLE public.phpgw_accounts OWNER TO postgres;

--
-- Name: phpgw_acl; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_acl (
    acl_appname character varying(50) NOT NULL,
    acl_location character varying(255) NOT NULL,
    acl_account integer NOT NULL,
    acl_rights integer
);


ALTER TABLE public.phpgw_acl OWNER TO postgres;

--
-- Name: phpgw_addressbook; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_addressbook (
    id integer DEFAULT nextval(('seq_phpgw_addressbook'::text)::regclass) NOT NULL,
    lid character varying(32),
    tid character(1),
    owner bigint,
    access character varying(7),
    cat_id character varying(32),
    fn character varying(64),
    n_family character varying(64),
    n_given character varying(64),
    n_middle character varying(64),
    n_prefix character varying(64),
    n_suffix character varying(64),
    sound character varying(64),
    bday character varying(32),
    note text,
    tz character varying(8),
    geo character varying(32),
    url character varying(128),
    pubkey text,
    org_name character varying(64),
    org_unit character varying(64),
    title character varying(64),
    adr_one_street character varying(64),
    adr_one_locality character varying(64),
    adr_one_region character varying(64),
    adr_one_postalcode character varying(64),
    adr_one_countryname character varying(64),
    adr_one_type character varying(32),
    label text,
    adr_two_street character varying(64),
    adr_two_locality character varying(64),
    adr_two_region character varying(64),
    adr_two_postalcode character varying(64),
    adr_two_countryname character varying(64),
    adr_two_type character varying(32),
    tel_work character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_home character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_voice character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_fax character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_msg character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_cell character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_pager character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_bbs character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_modem character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_car character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_isdn character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_video character varying(40) DEFAULT '+1 (000) 000-0000'::character varying NOT NULL,
    tel_prefer character varying(32),
    email character varying(64),
    email_type character varying(32) DEFAULT 'INTERNET'::character varying,
    email_home character varying(64),
    email_home_type character varying(32) DEFAULT 'INTERNET'::character varying,
    last_mod bigint NOT NULL
);


ALTER TABLE public.phpgw_addressbook OWNER TO postgres;

--
-- Name: phpgw_addressbook_extra; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_addressbook_extra (
    contact_id integer NOT NULL,
    contact_owner bigint,
    contact_name character varying(255) NOT NULL,
    contact_value text
);


ALTER TABLE public.phpgw_addressbook_extra OWNER TO postgres;

--
-- Name: phpgw_app_sessions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_app_sessions (
    sessionid character varying(128) NOT NULL,
    loginid integer NOT NULL,
    app character varying(25) NOT NULL,
    location character varying(128) NOT NULL,
    content text,
    session_dla integer
);


ALTER TABLE public.phpgw_app_sessions OWNER TO postgres;

--
-- Name: phpgw_applications; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_applications (
    app_id integer DEFAULT nextval(('seq_phpgw_applications'::text)::regclass) NOT NULL,
    app_name character varying(25) NOT NULL,
    app_enabled integer NOT NULL,
    app_order integer NOT NULL,
    app_tables text NOT NULL,
    app_version character varying(20) DEFAULT 0.0 NOT NULL
);


ALTER TABLE public.phpgw_applications OWNER TO postgres;

--
-- Name: phpgw_async; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_async (
    id character varying(255) NOT NULL,
    next integer NOT NULL,
    times character varying(255) NOT NULL,
    method character varying(80) NOT NULL,
    data text NOT NULL,
    account_id integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.phpgw_async OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: phpgw_audit; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_audit (
    usrid character varying(25) NOT NULL,
    type integer NOT NULL,
    value integer NOT NULL
);


ALTER TABLE public.phpgw_audit OWNER TO postgres;

SET default_with_oids = true;

--
-- Name: phpgw_cal; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cal (
    cal_id integer DEFAULT nextval(('seq_phpgw_cal'::text)::regclass) NOT NULL,
    uid character varying(255) NOT NULL,
    owner bigint NOT NULL,
    category character varying(30),
    groups character varying(255),
    datetime bigint,
    mdatetime bigint,
    edatetime bigint,
    priority bigint DEFAULT 2 NOT NULL,
    cal_type character varying(10),
    is_public bigint DEFAULT 1 NOT NULL,
    title character varying(80) DEFAULT 1 NOT NULL,
    description text,
    location character varying(255),
    reference bigint DEFAULT 0 NOT NULL,
    ex_participants text,
    last_status character(1) DEFAULT 'N'::bpchar,
    last_update bigint DEFAULT (date_part('epoch'::text, ('now'::text)::timestamp(3) with time zone) * (1000)::double precision)
);


ALTER TABLE public.phpgw_cal OWNER TO postgres;

--
-- Name: phpgw_cal_extra; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cal_extra (
    cal_id integer NOT NULL,
    cal_extra_name character varying(40) NOT NULL,
    cal_extra_value character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.phpgw_cal_extra OWNER TO postgres;

--
-- Name: phpgw_cal_holidays; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cal_holidays (
    hol_id integer DEFAULT nextval(('seq_phpgw_cal_holidays'::text)::regclass) NOT NULL,
    locale character(2) NOT NULL,
    name character varying(50) NOT NULL,
    mday bigint DEFAULT 0 NOT NULL,
    month_num bigint DEFAULT 0 NOT NULL,
    occurence bigint DEFAULT 0 NOT NULL,
    dow bigint DEFAULT 0 NOT NULL,
    observance_rule bigint DEFAULT 0 NOT NULL
);


ALTER TABLE public.phpgw_cal_holidays OWNER TO postgres;

--
-- Name: phpgw_cal_repeats; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cal_repeats (
    cal_id bigint NOT NULL,
    recur_type bigint NOT NULL,
    recur_use_end bigint DEFAULT 0,
    recur_enddate bigint,
    recur_interval bigint DEFAULT 1,
    recur_data bigint DEFAULT 1,
    recur_exception character varying(255) DEFAULT ''::character varying
);


ALTER TABLE public.phpgw_cal_repeats OWNER TO postgres;

--
-- Name: phpgw_cal_user; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cal_user (
    cal_id bigint DEFAULT 0 NOT NULL,
    cal_login bigint DEFAULT 0 NOT NULL,
    cal_status character(1) DEFAULT 'A'::bpchar,
    cal_type character varying(1) DEFAULT 'u'::character varying NOT NULL
);


ALTER TABLE public.phpgw_cal_user OWNER TO postgres;

--
-- Name: phpgw_categories; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_categories (
    cat_id integer DEFAULT nextval(('seq_phpgw_categories'::text)::regclass) NOT NULL,
    cat_main integer DEFAULT 0 NOT NULL,
    cat_parent integer DEFAULT 0 NOT NULL,
    cat_level smallint DEFAULT 0 NOT NULL,
    cat_owner integer DEFAULT 0 NOT NULL,
    cat_access character varying(7),
    cat_appname character varying(50) NOT NULL,
    cat_name character varying(150) NOT NULL,
    cat_description character varying(255) NOT NULL,
    cat_data text,
    last_mod bigint NOT NULL
);


ALTER TABLE public.phpgw_categories OWNER TO postgres;

--
-- Name: phpgw_cc_addresses; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_addresses (
    id_address bigint NOT NULL,
    id_city bigint,
    id_state bigint,
    id_country character(2) NOT NULL,
    address1 character varying(60),
    address2 character varying(60),
    complement character varying(30),
    address_other character varying(60),
    postal_code character varying(15),
    po_box character varying(30),
    address_is_default boolean
);


ALTER TABLE public.phpgw_cc_addresses OWNER TO postgres;

--
-- Name: phpgw_cc_city; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_city (
    id_city bigint NOT NULL,
    id_state bigint,
    id_country character(2) NOT NULL,
    city_timezone smallint,
    city_geo_location character varying(40),
    city_name character varying(60)
);


ALTER TABLE public.phpgw_cc_city OWNER TO postgres;

--
-- Name: phpgw_cc_company; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_company (
    id_company bigint NOT NULL,
    id_company_owner bigint NOT NULL,
    company_name character varying(30),
    company_notes text
);


ALTER TABLE public.phpgw_cc_company OWNER TO postgres;

--
-- Name: phpgw_cc_company_addrs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_company_addrs (
    id_company bigint NOT NULL,
    id_address bigint NOT NULL,
    id_typeof_company_address integer
);


ALTER TABLE public.phpgw_cc_company_addrs OWNER TO postgres;

--
-- Name: phpgw_cc_company_conns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_company_conns (
    id_company bigint NOT NULL,
    id_connection bigint NOT NULL,
    id_typeof_company_connection integer
);


ALTER TABLE public.phpgw_cc_company_conns OWNER TO postgres;

--
-- Name: phpgw_cc_company_legals; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_company_legals (
    id_company_legal bigint NOT NULL,
    id_company bigint NOT NULL,
    id_typeof_company_legal integer NOT NULL,
    legal_info_name character varying(30),
    legal_info_value character varying(30)
);


ALTER TABLE public.phpgw_cc_company_legals OWNER TO postgres;

--
-- Name: phpgw_cc_company_rels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_company_rels (
    id_company bigint NOT NULL,
    id_related bigint NOT NULL,
    id_typeof_company_relation integer
);


ALTER TABLE public.phpgw_cc_company_rels OWNER TO postgres;

--
-- Name: phpgw_cc_connections; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_connections (
    id_connection bigint NOT NULL,
    connection_name character varying(50),
    connection_value character varying(100),
    connection_is_default boolean
);


ALTER TABLE public.phpgw_cc_connections OWNER TO postgres;

--
-- Name: phpgw_cc_contact; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact (
    id_contact bigint NOT NULL,
    id_owner bigint NOT NULL,
    id_status integer,
    photo bytea,
    alias character varying(30),
    id_prefix integer,
    given_names character varying(100),
    family_names character varying(100),
    names_ordered character varying(100),
    id_suffix integer,
    birthdate date,
    sex character(1),
    pgp_key text,
    notes text,
    is_global boolean,
    last_status character(1) DEFAULT 'N'::bpchar,
    last_update bigint DEFAULT (date_part('epoch'::text, ('now'::text)::timestamp(3) with time zone) * (1000)::double precision),
    category character varying(20)
);


ALTER TABLE public.phpgw_cc_contact OWNER TO postgres;

--
-- Name: phpgw_cc_contact_addrs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact_addrs (
    id_contact bigint NOT NULL,
    id_address bigint NOT NULL,
    id_typeof_contact_address integer
);


ALTER TABLE public.phpgw_cc_contact_addrs OWNER TO postgres;

--
-- Name: phpgw_cc_contact_company; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact_company (
    id_contact bigint NOT NULL,
    id_company bigint NOT NULL,
    title character varying(30),
    department character varying(30),
    default_contact boolean,
    default_company boolean
);


ALTER TABLE public.phpgw_cc_contact_company OWNER TO postgres;

--
-- Name: phpgw_cc_contact_conns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact_conns (
    id_contact bigint NOT NULL,
    id_connection bigint NOT NULL,
    id_typeof_contact_connection integer
);


ALTER TABLE public.phpgw_cc_contact_conns OWNER TO postgres;

--
-- Name: phpgw_cc_contact_grps; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact_grps (
    id_group bigint NOT NULL,
    id_connection bigint NOT NULL
);


ALTER TABLE public.phpgw_cc_contact_grps OWNER TO postgres;

--
-- Name: phpgw_cc_contact_rels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_contact_rels (
    id_contact bigint NOT NULL,
    id_related bigint NOT NULL,
    id_typeof_contact_relation integer
);


ALTER TABLE public.phpgw_cc_contact_rels OWNER TO postgres;

--
-- Name: phpgw_cc_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_groups (
    id_group integer DEFAULT nextval(('seq_phpgw_cc_groups'::text)::regclass) NOT NULL,
    title character varying(50),
    owner bigint NOT NULL,
    short_name text
);


ALTER TABLE public.phpgw_cc_groups OWNER TO postgres;

--
-- Name: phpgw_cc_prefixes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_prefixes (
    id_prefix smallint NOT NULL,
    prefix character varying(30)
);


ALTER TABLE public.phpgw_cc_prefixes OWNER TO postgres;

--
-- Name: phpgw_cc_state; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_state (
    id_state bigint NOT NULL,
    id_country character(2) NOT NULL,
    state_name character varying(30),
    state_symbol character varying(10)
);


ALTER TABLE public.phpgw_cc_state OWNER TO postgres;

--
-- Name: phpgw_cc_status; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_status (
    id_status smallint NOT NULL,
    status_name character varying(30)
);


ALTER TABLE public.phpgw_cc_status OWNER TO postgres;

--
-- Name: phpgw_cc_suffixes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_suffixes (
    id_suffix smallint NOT NULL,
    suffix character varying(30)
);


ALTER TABLE public.phpgw_cc_suffixes OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_co_addrs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_co_addrs (
    id_typeof_company_address integer NOT NULL,
    company_address_type_name character varying(30)
);


ALTER TABLE public.phpgw_cc_typeof_co_addrs OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_co_conns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_co_conns (
    id_typeof_company_connection integer NOT NULL,
    company_connection_type_name character varying(30)
);


ALTER TABLE public.phpgw_cc_typeof_co_conns OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_co_legals; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_co_legals (
    id_typeof_company_legal integer NOT NULL,
    legal_type_name character varying(60)
);


ALTER TABLE public.phpgw_cc_typeof_co_legals OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_co_rels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_co_rels (
    id_typeof_company_relation integer NOT NULL,
    company_relation_type_name character varying(30),
    company_relation_is_subordinated boolean
);


ALTER TABLE public.phpgw_cc_typeof_co_rels OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_ct_addrs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_ct_addrs (
    id_typeof_contact_address integer NOT NULL,
    contact_address_type_name character varying(30)
);


ALTER TABLE public.phpgw_cc_typeof_ct_addrs OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_ct_conns; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_ct_conns (
    id_typeof_contact_connection integer NOT NULL,
    contact_connection_type_name character varying(30)
);


ALTER TABLE public.phpgw_cc_typeof_ct_conns OWNER TO postgres;

--
-- Name: phpgw_cc_typeof_ct_rels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_cc_typeof_ct_rels (
    id_typeof_contact_relation integer NOT NULL,
    contact_relation_type_name character varying(30),
    contact_relation_is_subordinated boolean
);


ALTER TABLE public.phpgw_cc_typeof_ct_rels OWNER TO postgres;

--
-- Name: phpgw_certificados; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_certificados (
    email character varying(60) NOT NULL,
    chave_publica text,
    expirado boolean DEFAULT false,
    revogado boolean DEFAULT false,
    serialnumber bigint NOT NULL,
    authoritykeyidentifier text NOT NULL
);


ALTER TABLE public.phpgw_certificados OWNER TO postgres;

--
-- Name: phpgw_config; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_config (
    config_app character varying(50) NOT NULL,
    config_name character varying(255) NOT NULL,
    config_value text
);


ALTER TABLE public.phpgw_config OWNER TO postgres;

--
-- Name: phpgw_emailadmin; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_emailadmin (
    profileid integer DEFAULT nextval(('seq_phpgw_emailadmin'::text)::regclass) NOT NULL,
    smtpserver character varying(80),
    smtptype integer,
    smtpport integer,
    smtpdelimiter character varying(1),
    smtpauth character varying(3),
    smtpldapserver character varying(80),
    smtpldapbasedn character varying(200),
    smtpldapadmindn character varying(200),
    smtpldapadminpw character varying(30),
    smtpldapusedefault character varying(3),
    imapserver character varying(80),
    imaptype integer,
    imapport integer,
    imapdelimiter character varying(1),
    imaplogintype character varying(20),
    imaptlsauthentication character varying(3),
    imaptlsencryption character varying(3),
    imapenablecyrusadmin character varying(3),
    imapadminusername character varying(40),
    imapadminpw character varying(40),
    imapenablesieve character varying(3),
    imapsieveserver character varying(80),
    imapsieveport integer,
    description character varying(200),
    defaultdomain character varying(100),
    organisationname character varying(100),
    userdefinedaccounts character varying(3),
    imapoldcclient character varying(3),
    imapdefaulttrashfolder character varying(20),
    imapdefaultsentfolder character varying(20),
    imapdefaultdraftsfolder character varying(20),
    imapdefaultspamfolder character varying(20)
);


ALTER TABLE public.phpgw_emailadmin OWNER TO postgres;

--
-- Name: phpgw_expressoadmin; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadmin (
    manager_lid character varying(50) NOT NULL,
    context character varying(255) NOT NULL,
    acl bigint NOT NULL
);


ALTER TABLE public.phpgw_expressoadmin OWNER TO postgres;

--
-- Name: phpgw_expressoadmin_apps; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadmin_apps (
    manager_lid character varying(50) NOT NULL,
    context character varying(255) NOT NULL,
    app character varying(100) NOT NULL
);


ALTER TABLE public.phpgw_expressoadmin_apps OWNER TO postgres;

--
-- Name: phpgw_expressoadmin_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadmin_log (
    date timestamp without time zone NOT NULL,
    manager character varying(50) NOT NULL,
    action character varying(255) NOT NULL,
    userinfo character varying(255) NOT NULL,
    groupinfo character varying(255) NOT NULL,
    appinfo character varying(255) NOT NULL,
    msg character varying(255) NOT NULL
);


ALTER TABLE public.phpgw_expressoadmin_log OWNER TO postgres;

--
-- Name: phpgw_expressoadmin_passwords; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadmin_passwords (
    uid character varying(100) NOT NULL,
    password character varying(255) NOT NULL
);


ALTER TABLE public.phpgw_expressoadmin_passwords OWNER TO postgres;

--
-- Name: phpgw_expressoadmin_samba; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadmin_samba (
    samba_domain_name character varying(50) NOT NULL,
    samba_domain_sid character varying(100)
);


ALTER TABLE public.phpgw_expressoadmin_samba OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: phpgw_expressoadminserpro; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadminserpro (
    manager_lid character varying(50) NOT NULL,
    context character varying(255) NOT NULL,
    acl bigint NOT NULL
);


ALTER TABLE public.phpgw_expressoadminserpro OWNER TO postgres;

--
-- Name: phpgw_expressoadminserpro_apps; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadminserpro_apps (
    manager_lid character varying(50) NOT NULL,
    context character varying(255) NOT NULL,
    app character varying(100) NOT NULL
);


ALTER TABLE public.phpgw_expressoadminserpro_apps OWNER TO postgres;

--
-- Name: phpgw_expressoadminserpro_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadminserpro_log (
    date timestamp without time zone NOT NULL,
    manager character varying(50) NOT NULL,
    action character varying(255) NOT NULL,
    userinfo character varying(255) NOT NULL,
    groupinfo character varying(255) NOT NULL,
    appinfo character varying(255) NOT NULL,
    msg character varying(255) NOT NULL
);


ALTER TABLE public.phpgw_expressoadminserpro_log OWNER TO postgres;

--
-- Name: phpgw_expressoadminserpro_passwords; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadminserpro_passwords (
    uid character varying(100) NOT NULL,
    password character varying(255) NOT NULL
);


ALTER TABLE public.phpgw_expressoadminserpro_passwords OWNER TO postgres;

--
-- Name: phpgw_expressoadminserpro_samba; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressoadminserpro_samba (
    samba_domain_name character varying(50) NOT NULL,
    samba_domain_sid character varying(100)
);


ALTER TABLE public.phpgw_expressoadminserpro_samba OWNER TO postgres;

SET default_with_oids = true;

--
-- Name: phpgw_expressomail_contacts; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_expressomail_contacts (
    id_owner bigint NOT NULL,
    data text
);


ALTER TABLE public.phpgw_expressomail_contacts OWNER TO postgres;

--
-- Name: phpgw_history_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_history_log (
    history_id integer DEFAULT nextval(('seq_phpgw_history_log'::text)::regclass) NOT NULL,
    history_record_id integer NOT NULL,
    history_appname character varying(64) NOT NULL,
    history_owner integer NOT NULL,
    history_status character(2) NOT NULL,
    history_new_value text NOT NULL,
    history_timestamp timestamp without time zone DEFAULT '2006-07-04 11:09:06.047568'::timestamp without time zone NOT NULL,
    history_old_value text NOT NULL
);


ALTER TABLE public.phpgw_history_log OWNER TO postgres;

--
-- Name: phpgw_hooks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_hooks (
    hook_id integer DEFAULT nextval(('seq_phpgw_hooks'::text)::regclass) NOT NULL,
    hook_appname character varying(255),
    hook_location character varying(255),
    hook_filename character varying(255)
);


ALTER TABLE public.phpgw_hooks OWNER TO postgres;

--
-- Name: phpgw_interserv; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_interserv (
    server_id integer DEFAULT nextval(('seq_phpgw_interserv'::text)::regclass) NOT NULL,
    server_name character varying(64),
    server_host character varying(255),
    server_url character varying(255),
    trust_level integer,
    trust_rel integer,
    username character varying(64),
    password character varying(255),
    admin_name character varying(255),
    admin_email character varying(255),
    server_mode character varying(16) DEFAULT 'xmlrpc'::character varying NOT NULL,
    server_security character varying(16)
);


ALTER TABLE public.phpgw_interserv OWNER TO postgres;

--
-- Name: phpgw_lang; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_lang (
    lang character varying(5) DEFAULT ''::character varying NOT NULL,
    app_name character varying(100) DEFAULT 'common'::character varying NOT NULL,
    message_id character varying(255) DEFAULT ''::character varying NOT NULL,
    content text
);


ALTER TABLE public.phpgw_lang OWNER TO postgres;

--
-- Name: phpgw_languages; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_languages (
    lang_id character varying(5) NOT NULL,
    lang_name character varying(50) NOT NULL
);


ALTER TABLE public.phpgw_languages OWNER TO postgres;

--
-- Name: phpgw_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_log (
    log_id integer DEFAULT nextval(('seq_phpgw_log'::text)::regclass) NOT NULL,
    log_date timestamp without time zone NOT NULL,
    log_user integer NOT NULL,
    log_app character varying(50) NOT NULL,
    log_severity character(1) NOT NULL
);


ALTER TABLE public.phpgw_log OWNER TO postgres;

--
-- Name: phpgw_log_msg; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_log_msg (
    log_msg_log_id integer NOT NULL,
    log_msg_seq_no integer NOT NULL,
    log_msg_date timestamp without time zone NOT NULL,
    log_msg_tx_fid character varying(4),
    log_msg_tx_id character varying(4),
    log_msg_severity character(1) NOT NULL,
    log_msg_code character varying(30) NOT NULL,
    log_msg_msg text NOT NULL,
    log_msg_parms text NOT NULL,
    log_msg_file character varying(255) NOT NULL,
    log_msg_line integer NOT NULL
);


ALTER TABLE public.phpgw_log_msg OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: phpgw_logins; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_logins (
    uid character varying(75) NOT NULL,
    hour_start character varying(20) NOT NULL,
    count integer DEFAULT 0 NOT NULL,
    ip character varying(64) NOT NULL
);


ALTER TABLE public.phpgw_logins OWNER TO postgres;

SET default_with_oids = true;

--
-- Name: phpgw_news; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_news (
    news_id integer DEFAULT nextval(('seq_phpgw_news'::text)::regclass) NOT NULL,
    news_date integer,
    news_subject character varying(255),
    news_submittedby character varying(255),
    news_content bytea,
    news_begin integer,
    news_end integer,
    news_cat integer,
    news_teaser character varying(255),
    is_html smallint DEFAULT 0 NOT NULL
);


ALTER TABLE public.phpgw_news OWNER TO postgres;

--
-- Name: phpgw_news_export; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_news_export (
    cat_id integer NOT NULL,
    export_type smallint,
    export_itemsyntax smallint,
    export_title character varying(255),
    export_link character varying(255),
    export_description text,
    export_img_title character varying(255),
    export_img_url character varying(255),
    export_img_link character varying(255)
);


ALTER TABLE public.phpgw_news_export OWNER TO postgres;

--
-- Name: phpgw_nextid; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_nextid (
    id integer,
    appname character varying(25) NOT NULL
);


ALTER TABLE public.phpgw_nextid OWNER TO postgres;

--
-- Name: phpgw_preferences; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_preferences (
    preference_owner integer NOT NULL,
    preference_app character varying(25) NOT NULL,
    preference_value text NOT NULL
);


ALTER TABLE public.phpgw_preferences OWNER TO postgres;

--
-- Name: phpgw_sessions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_sessions (
    session_id character varying(128) NOT NULL,
    session_lid character varying(128),
    session_ip character varying(32),
    session_logintime integer,
    session_dla integer,
    session_action character varying(255),
    session_flags character(2)
);


ALTER TABLE public.phpgw_sessions OWNER TO postgres;

--
-- Name: phpgw_vfs; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE phpgw_vfs (
    file_id integer DEFAULT nextval(('seq_phpgw_vfs'::text)::regclass) NOT NULL,
    owner_id integer NOT NULL,
    createdby_id integer,
    modifiedby_id integer,
    created date DEFAULT '1970-01-01'::date NOT NULL,
    modified date,
    size integer,
    mime_type character varying(64),
    deleteable character(1) DEFAULT 'Y'::bpchar,
    comment character varying(255),
    app character varying(25),
    directory character varying(255),
    name character varying(128) NOT NULL,
    link_directory character varying(255),
    link_name character varying(128),
    version character varying(30) DEFAULT '0.0.0.0'::character varying NOT NULL,
    content text
);


ALTER TABLE public.phpgw_vfs OWNER TO postgres;

--
-- Name: seq_phpgw_accounts; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_accounts
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_accounts OWNER TO postgres;

--
-- Name: seq_phpgw_addressbook; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_addressbook
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_addressbook OWNER TO postgres;

--
-- Name: seq_phpgw_applications; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_applications
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_applications OWNER TO postgres;

--
-- Name: seq_phpgw_cal; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_cal
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_cal OWNER TO postgres;

--
-- Name: seq_phpgw_cal_holidays; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_cal_holidays
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_cal_holidays OWNER TO postgres;

--
-- Name: seq_phpgw_categories; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_categories
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_categories OWNER TO postgres;

--
-- Name: seq_phpgw_cc_groups; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_cc_groups
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_cc_groups OWNER TO postgres;

--
-- Name: seq_phpgw_emailadmin; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_emailadmin
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_emailadmin OWNER TO postgres;

--
-- Name: seq_phpgw_history_log; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_history_log
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_history_log OWNER TO postgres;

--
-- Name: seq_phpgw_hooks; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_hooks
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_hooks OWNER TO postgres;

--
-- Name: seq_phpgw_interserv; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_interserv
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_interserv OWNER TO postgres;

--
-- Name: seq_phpgw_log; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_log
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_log OWNER TO postgres;

--
-- Name: seq_phpgw_news; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_news
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_news OWNER TO postgres;

--
-- Name: seq_phpgw_vfs; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE seq_phpgw_vfs
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.seq_phpgw_vfs OWNER TO postgres;

--
-- Name: egw_wf_activities_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_activities
    ADD CONSTRAINT egw_wf_activities_pkey PRIMARY KEY (wf_activity_id);


--
-- Name: egw_wf_activity_agents_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_activity_agents
    ADD CONSTRAINT egw_wf_activity_agents_pkey PRIMARY KEY (wf_activity_id, wf_agent_id);


--
-- Name: egw_wf_activity_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_activity_roles
    ADD CONSTRAINT egw_wf_activity_roles_pkey PRIMARY KEY (wf_activity_id, wf_role_id);


--
-- Name: egw_wf_admin_access_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_admin_access
    ADD CONSTRAINT egw_wf_admin_access_pkey PRIMARY KEY (admin_access_id, tipo, numvalue);


--
-- Name: egw_wf_agent_mail_smtp_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_agent_mail_smtp
    ADD CONSTRAINT egw_wf_agent_mail_smtp_pkey PRIMARY KEY (wf_agent_id);


--
-- Name: egw_wf_external_application_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_external_application
    ADD CONSTRAINT egw_wf_external_application_pkey PRIMARY KEY (external_application_id);


--
-- Name: egw_wf_instance_activities_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_instance_activities
    ADD CONSTRAINT egw_wf_instance_activities_pkey PRIMARY KEY (wf_instance_id, wf_activity_id);


--
-- Name: egw_wf_instances_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_instances
    ADD CONSTRAINT egw_wf_instances_pkey PRIMARY KEY (wf_instance_id);


--
-- Name: egw_wf_interinstance_relations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_interinstance_relations
    ADD CONSTRAINT egw_wf_interinstance_relations_pkey PRIMARY KEY (wf_parent_instance_id, wf_parent_activity_id, wf_child_instance_id);


--
-- Name: egw_wf_job_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_job_logs
    ADD CONSTRAINT egw_wf_job_logs_pkey PRIMARY KEY (job_id, date_time);


--
-- Name: egw_wf_jobs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_jobs
    ADD CONSTRAINT egw_wf_jobs_pkey PRIMARY KEY (job_id);


--
-- Name: egw_wf_process_config_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_process_config
    ADD CONSTRAINT egw_wf_process_config_pkey PRIMARY KEY (wf_p_id, wf_config_name);


--
-- Name: egw_wf_processes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_processes
    ADD CONSTRAINT egw_wf_processes_pkey PRIMARY KEY (wf_p_id);


--
-- Name: egw_wf_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_roles
    ADD CONSTRAINT egw_wf_roles_pkey PRIMARY KEY (wf_role_id);


--
-- Name: egw_wf_transitions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_transitions
    ADD CONSTRAINT egw_wf_transitions_pkey PRIMARY KEY (wf_act_from_id, wf_act_to_id);


--
-- Name: egw_wf_user_cache_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_user_cache
    ADD CONSTRAINT egw_wf_user_cache_pkey PRIMARY KEY (uidnumber);


--
-- Name: egw_wf_user_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_user_roles
    ADD CONSTRAINT egw_wf_user_roles_pkey PRIMARY KEY (wf_role_id, wf_user, wf_account_type);


--
-- Name: egw_wf_workitems_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY egw_wf_workitems
    ADD CONSTRAINT egw_wf_workitems_pkey PRIMARY KEY (wf_item_id);


--
-- Name: phpgw_accounts_account_lid_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_accounts
    ADD CONSTRAINT phpgw_accounts_account_lid_key UNIQUE (account_lid);


--
-- Name: phpgw_accounts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_accounts
    ADD CONSTRAINT phpgw_accounts_pkey PRIMARY KEY (account_id);


--
-- Name: phpgw_acl_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_acl
    ADD CONSTRAINT phpgw_acl_pkey PRIMARY KEY (acl_appname, acl_location, acl_account);


--
-- Name: phpgw_addressbook_extra_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_addressbook_extra
    ADD CONSTRAINT phpgw_addressbook_extra_pkey PRIMARY KEY (contact_id, contact_name);


--
-- Name: phpgw_addressbook_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_addressbook
    ADD CONSTRAINT phpgw_addressbook_pkey PRIMARY KEY (id);


--
-- Name: phpgw_app_sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_app_sessions
    ADD CONSTRAINT phpgw_app_sessions_pkey PRIMARY KEY (sessionid, loginid, app, location);


--
-- Name: phpgw_async_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_async
    ADD CONSTRAINT phpgw_async_pkey PRIMARY KEY (id);


--
-- Name: phpgw_audit_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_audit
    ADD CONSTRAINT phpgw_audit_pkey PRIMARY KEY (usrid, type);


--
-- Name: phpgw_cal_extra_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cal_extra
    ADD CONSTRAINT phpgw_cal_extra_pkey PRIMARY KEY (cal_id, cal_extra_name);


--
-- Name: phpgw_cal_holidays_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cal_holidays
    ADD CONSTRAINT phpgw_cal_holidays_pkey PRIMARY KEY (hol_id);


--
-- Name: phpgw_cal_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cal
    ADD CONSTRAINT phpgw_cal_pkey PRIMARY KEY (cal_id);


--
-- Name: phpgw_cal_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cal_user
    ADD CONSTRAINT phpgw_cal_user_pkey PRIMARY KEY (cal_id, cal_login);


--
-- Name: phpgw_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_categories
    ADD CONSTRAINT phpgw_categories_pkey PRIMARY KEY (cat_id);


--
-- Name: phpgw_cc_addresses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_addresses
    ADD CONSTRAINT phpgw_cc_addresses_pkey PRIMARY KEY (id_address);


--
-- Name: phpgw_cc_city_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_city
    ADD CONSTRAINT phpgw_cc_city_pkey PRIMARY KEY (id_city);


--
-- Name: phpgw_cc_company_addrs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_company_addrs
    ADD CONSTRAINT phpgw_cc_company_addrs_pkey PRIMARY KEY (id_company, id_address);


--
-- Name: phpgw_cc_company_conns_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_company_conns
    ADD CONSTRAINT phpgw_cc_company_conns_pkey PRIMARY KEY (id_company, id_connection);


--
-- Name: phpgw_cc_company_legals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_company_legals
    ADD CONSTRAINT phpgw_cc_company_legals_pkey PRIMARY KEY (id_company_legal);


--
-- Name: phpgw_cc_company_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_company
    ADD CONSTRAINT phpgw_cc_company_pkey PRIMARY KEY (id_company);


--
-- Name: phpgw_cc_company_rels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_company_rels
    ADD CONSTRAINT phpgw_cc_company_rels_pkey PRIMARY KEY (id_company, id_related);


--
-- Name: phpgw_cc_connections_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_connections
    ADD CONSTRAINT phpgw_cc_connections_pkey PRIMARY KEY (id_connection);


--
-- Name: phpgw_cc_contact_addrs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_contact_addrs
    ADD CONSTRAINT phpgw_cc_contact_addrs_pkey PRIMARY KEY (id_contact, id_address);


--
-- Name: phpgw_cc_contact_company_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_contact_company
    ADD CONSTRAINT phpgw_cc_contact_company_pkey PRIMARY KEY (id_contact, id_company);


--
-- Name: phpgw_cc_contact_conns_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_contact_conns
    ADD CONSTRAINT phpgw_cc_contact_conns_pkey PRIMARY KEY (id_contact, id_connection);


--
-- Name: phpgw_cc_contact_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_contact
    ADD CONSTRAINT phpgw_cc_contact_pkey PRIMARY KEY (id_contact);


--
-- Name: phpgw_cc_contact_rels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_contact_rels
    ADD CONSTRAINT phpgw_cc_contact_rels_pkey PRIMARY KEY (id_contact, id_related);


--
-- Name: phpgw_cc_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_groups
    ADD CONSTRAINT phpgw_cc_groups_pkey PRIMARY KEY (id_group);


--
-- Name: phpgw_cc_prefixes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_prefixes
    ADD CONSTRAINT phpgw_cc_prefixes_pkey PRIMARY KEY (id_prefix);


--
-- Name: phpgw_cc_state_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_state
    ADD CONSTRAINT phpgw_cc_state_pkey PRIMARY KEY (id_state);


--
-- Name: phpgw_cc_status_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_status
    ADD CONSTRAINT phpgw_cc_status_pkey PRIMARY KEY (id_status);


--
-- Name: phpgw_cc_suffixes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_suffixes
    ADD CONSTRAINT phpgw_cc_suffixes_pkey PRIMARY KEY (id_suffix);


--
-- Name: phpgw_cc_typeof_co_addrs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_co_addrs
    ADD CONSTRAINT phpgw_cc_typeof_co_addrs_pkey PRIMARY KEY (id_typeof_company_address);


--
-- Name: phpgw_cc_typeof_co_conns_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_co_conns
    ADD CONSTRAINT phpgw_cc_typeof_co_conns_pkey PRIMARY KEY (id_typeof_company_connection);


--
-- Name: phpgw_cc_typeof_co_legals_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_co_legals
    ADD CONSTRAINT phpgw_cc_typeof_co_legals_pkey PRIMARY KEY (id_typeof_company_legal);


--
-- Name: phpgw_cc_typeof_co_rels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_co_rels
    ADD CONSTRAINT phpgw_cc_typeof_co_rels_pkey PRIMARY KEY (id_typeof_company_relation);


--
-- Name: phpgw_cc_typeof_ct_addrs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_ct_addrs
    ADD CONSTRAINT phpgw_cc_typeof_ct_addrs_pkey PRIMARY KEY (id_typeof_contact_address);


--
-- Name: phpgw_cc_typeof_ct_conns_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_ct_conns
    ADD CONSTRAINT phpgw_cc_typeof_ct_conns_pkey PRIMARY KEY (id_typeof_contact_connection);


--
-- Name: phpgw_cc_typeof_ct_rels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_cc_typeof_ct_rels
    ADD CONSTRAINT phpgw_cc_typeof_ct_rels_pkey PRIMARY KEY (id_typeof_contact_relation);


--
-- Name: phpgw_certificados_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_certificados
    ADD CONSTRAINT phpgw_certificados_pkey PRIMARY KEY (email, serialnumber, authoritykeyidentifier);


--
-- Name: phpgw_config_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_config
    ADD CONSTRAINT phpgw_config_pkey PRIMARY KEY (config_app, config_name);


--
-- Name: phpgw_emailadmin_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_emailadmin
    ADD CONSTRAINT phpgw_emailadmin_pkey PRIMARY KEY (profileid);


--
-- Name: phpgw_expressoadmin_samba_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_expressoadmin_samba
    ADD CONSTRAINT phpgw_expressoadmin_samba_pkey PRIMARY KEY (samba_domain_name);


--
-- Name: phpgw_expressoadminserpro_samba_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_expressoadminserpro_samba
    ADD CONSTRAINT phpgw_expressoadminserpro_samba_pkey PRIMARY KEY (samba_domain_name);


--
-- Name: phpgw_expressomail_contacts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_expressomail_contacts
    ADD CONSTRAINT phpgw_expressomail_contacts_pkey PRIMARY KEY (id_owner);


--
-- Name: phpgw_history_log_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_history_log
    ADD CONSTRAINT phpgw_history_log_pkey PRIMARY KEY (history_id);


--
-- Name: phpgw_hooks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_hooks
    ADD CONSTRAINT phpgw_hooks_pkey PRIMARY KEY (hook_id);


--
-- Name: phpgw_interserv_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_interserv
    ADD CONSTRAINT phpgw_interserv_pkey PRIMARY KEY (server_id);


--
-- Name: phpgw_lang_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_lang
    ADD CONSTRAINT phpgw_lang_pkey PRIMARY KEY (lang, app_name, message_id);


--
-- Name: phpgw_languages_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_languages
    ADD CONSTRAINT phpgw_languages_pkey PRIMARY KEY (lang_id);


--
-- Name: phpgw_log_msg_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_log_msg
    ADD CONSTRAINT phpgw_log_msg_pkey PRIMARY KEY (log_msg_log_id, log_msg_seq_no);


--
-- Name: phpgw_log_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_log
    ADD CONSTRAINT phpgw_log_pkey PRIMARY KEY (log_id);


--
-- Name: phpgw_news_export_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_news_export
    ADD CONSTRAINT phpgw_news_export_pkey PRIMARY KEY (cat_id);


--
-- Name: phpgw_news_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_news
    ADD CONSTRAINT phpgw_news_pkey PRIMARY KEY (news_id);


--
-- Name: phpgw_nextid_appname_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_nextid
    ADD CONSTRAINT phpgw_nextid_appname_key UNIQUE (appname);


--
-- Name: phpgw_preferences_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_preferences
    ADD CONSTRAINT phpgw_preferences_pkey PRIMARY KEY (preference_owner, preference_app);


--
-- Name: phpgw_sessions_session_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_sessions
    ADD CONSTRAINT phpgw_sessions_session_id_key UNIQUE (session_id);


--
-- Name: phpgw_vfs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY phpgw_vfs
    ADD CONSTRAINT phpgw_vfs_pkey PRIMARY KEY (file_id);


--
-- Name: egw_wf_instance_activities_wf_activity_id_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instance_activities_wf_activity_id_idx ON egw_wf_instance_activities USING btree (wf_activity_id);


--
-- Name: egw_wf_instance_activities_wf_instance_id_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instance_activities_wf_instance_id_idx ON egw_wf_instance_activities USING btree (wf_instance_id);


--
-- Name: egw_wf_instance_activities_wf_user_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instance_activities_wf_user_idx ON egw_wf_instance_activities USING btree (wf_user);


--
-- Name: egw_wf_instances_wf_name_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instances_wf_name_idx ON egw_wf_instances USING btree (upper((wf_name)::text));


--
-- Name: egw_wf_instances_wf_owner_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instances_wf_owner_idx ON egw_wf_instances USING btree (wf_owner);


--
-- Name: egw_wf_instances_wf_p_id_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instances_wf_p_id_idx ON egw_wf_instances USING btree (wf_p_id);


--
-- Name: egw_wf_instances_wf_status_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_instances_wf_status_idx ON egw_wf_instances USING btree (wf_status);


--
-- Name: egw_wf_processes_wf_p_id_wf_is_active_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_processes_wf_p_id_wf_is_active_idx ON egw_wf_processes USING btree (wf_p_id, wf_is_active);


--
-- Name: egw_wf_user_cache_cpf_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_user_cache_cpf_idx ON egw_wf_user_cache USING btree (cpf);


--
-- Name: egw_wf_user_cache_employeenumber_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_user_cache_employeenumber_idx ON egw_wf_user_cache USING btree (employeenumber);


--
-- Name: egw_wf_user_cache_mail_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_user_cache_mail_idx ON egw_wf_user_cache USING btree (mail);


--
-- Name: egw_wf_workitems_wf_instance_id_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX egw_wf_workitems_wf_instance_id_idx ON egw_wf_workitems USING btree (wf_instance_id);


--
-- Name: phpgw_acl_acl_account_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_acl_acl_account_idx ON phpgw_acl USING btree (acl_account);


--
-- Name: phpgw_acl_acl_appname_acl_account_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_acl_acl_appname_acl_account_idx ON phpgw_acl USING btree (acl_appname, acl_account);


--
-- Name: phpgw_acl_acl_location_acl_account_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_acl_acl_location_acl_account_idx ON phpgw_acl USING btree (acl_location, acl_account);


--
-- Name: phpgw_addressbook_tid_cat_id_owner_access_n_family_n_given_emai; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_addressbook_tid_cat_id_owner_access_n_family_n_given_emai ON phpgw_addressbook USING btree (tid, cat_id, owner, access, n_family, n_given, email);


--
-- Name: phpgw_addressbook_tid_owner_access_n_family_n_given_email_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_addressbook_tid_owner_access_n_family_n_given_email_idx ON phpgw_addressbook USING btree (tid, owner, access, n_family, n_given, email);


--
-- Name: phpgw_applications_app_enabled_app_order_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_applications_app_enabled_app_order_idx ON phpgw_applications USING btree (app_enabled, app_order);


--
-- Name: phpgw_categories_cat_appname_cat_owner_cat_parent_cat_level_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_categories_cat_appname_cat_owner_cat_parent_cat_level_idx ON phpgw_categories USING btree (cat_appname, cat_owner, cat_parent, cat_level);


--
-- Name: phpgw_cc_contact_is_global_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_cc_contact_is_global_idx ON phpgw_cc_contact USING btree (is_global);


--
-- Name: phpgw_history_log_history_appname_history_record_id_history_sta; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_history_log_history_appname_history_record_id_history_sta ON phpgw_history_log USING btree (history_appname, history_record_id, history_status, history_timestamp);


--
-- Name: phpgw_news_news_date_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_news_news_date_idx ON phpgw_news USING btree (news_date);


--
-- Name: phpgw_news_news_subject_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_news_news_subject_idx ON phpgw_news USING btree (news_subject);


--
-- Name: phpgw_sessions_session_flags_session_dla_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_sessions_session_flags_session_dla_idx ON phpgw_sessions USING btree (session_flags, session_dla);


--
-- Name: phpgw_vfs_directory_name_mime_type_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX phpgw_vfs_directory_name_mime_type_idx ON phpgw_vfs USING btree (directory, name, mime_type);


--
-- Name: trig_share_catalog_delete; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER trig_share_catalog_delete
    AFTER DELETE ON phpgw_acl
    FOR EACH ROW
    EXECUTE PROCEDURE share_catalog_delete();


--
-- Name: trig_share_catalog_insert; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER trig_share_catalog_insert
    AFTER INSERT ON phpgw_acl
    FOR EACH ROW
    EXECUTE PROCEDURE share_catalog_insert();


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

