#!/usr/bin/env bash
# setup primary-standby cluster, shutdown primary, flip checksum state, see if standby works, verify checksums on standby

set -e

OUTDIR=$1
DURATION=$2

s=$(date +%s)
e=$((s + 3600))

checksums="on"
fast="true"

function wait_for_checksums {

	state=$1

	while /bin/true; do

		x=$(psql -t -A test -c "SELECT current_setting('data_checksums')")

		if [ "$x" == "$state" ]; then
			break
		fi

		sleep 1

	done
}

while /bin/true; do

	# paranoia: make sure the checksums are in the expected state
	wait_for_checksums $checksums

	lsn=$(psql -t -A test -c "select pg_current_wal_lsn()")
	s=$(date +%s)

	echo "CHECKSUMS $s $lsn $checksums" >> $OUTDIR/checksums 2>&1

	if [ "$checksums" == "on" ]; then
		psql test -c "SELECT pg_disable_data_checksums(fast => $fast)"
		checksums="off"
	else
		psql test -c "SELECT pg_enable_data_checksums(fast => $fast)"
		checksums="on"
	fi

	wait_for_checksums $checksums

	lsn=$(psql -t -A test -c "select pg_current_wal_lsn()")
	s=$(date +%s)

	echo "CHECKSUMS $s $lsn $checksums" >> $OUTDIR/checksums 2>&1

	r=$((RANDOM % 2))

	if [ "$r" == "0" ]; then
		fast="true"
	else
		fast="false"
	fi

	r=$((RANDOM % 30))
	sleep $r

	if [ $s -gt $e ]; then
		break
	fi

done
