#!/usr/bin/env bash

set -e

PATH_OLD=$PATH

DATADIR=/mnt/raid-nvme/data-limit

killall -9 postgres || true
rm -Rf $DATADIR

for ff in 100 10; do

	for d in sequential random; do

		#for v in 14 15 16 17 18 master; do
		for v in patched-6; do

			export PATH=/home/tomas/builds/$v/bin:$PATH_OLD

			pg_ctl -D $DATADIR init

			pg_checksums --disable $DATADIR

			pg_ctl -D $DATADIR -l pg.log start

			createdb test
			sed "s/FF/$ff/" create-$d.sql | psql test

			psql test -c "\d+"

			for r in $(seq 1 10); do

				pg_ctl -D $DATADIR -l pg.log restart
				sudo ./drop-caches.sh

				val=$((1 + RANDOM % 100))

				t=$(sed "s/VALUE/$val/" select.sql | psql test | grep 'Execution Time:' | awk '{print $3}')

				echo $ff $d $v $r $val $t >> results.csv

			done

			pg_ctl -D $DATADIR -l pg.log stop

			rm -Rf $DATADIR

		done

	done

done
