#define _XOPEN_SOURCE 600
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

static int does_posix_fadvise_work(void)
{
#ifndef POSIX_FADV_WILLNEED
    printf("Error:  no POSIX_FADV_WILLNEED definition\n");
    return 0;
#else
    int fd;
    char data[8192];
    fd = creat("conftest.posix_fadvise", 0600);
    if (fd < 0)
	   {
       printf("Error:  could not create test file");
       return 0;
       }
    if (write(fd, data, 8192) != 8192)
       {
       printf("Error:  could not write to test file");
       return 0;
       }
    if (posix_fadvise(fd, 0, 8192, POSIX_FADV_WILLNEED) != 0)
       {
       printf("Error:  could not issue posix_fadvise call");
       return 0;
       }
    return 1;
#endif
}

 int main() {
   int works=does_posix_fadvise_work();
   printf("Does posix_fadvise work:  %d\n",works);
   return !works;
 }

