/*-------------------------------------------------------------------------
 *
 * anotation.c
 *
 *
 * Copyright (c) 2008-2009, PostgreSQL Global Developent Group
 *
 * IDENTIFICATION
 *	  $PostgreSQL: pgsql/contrib/anotation
 *
 *  ADA syle for named notation support
 *     like:
 *          SELECT funcname(value, name => value, ..)
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "fmgr.h"

#include "catalog/namespace.h"
#include "nodes/nodeFuncs.h"
#include "parser/parse_expr.h"

Node * transformNamedParameter(ParseState *pstate, Node *expr);

/* Saved hook value  */
static ParseExprTransform_hook_type	prev_transformExpr = NULL;

void	_PG_init(void);
void	_PG_fini(void);




PG_MODULE_MAGIC;

void
_PG_init(void)
{
	/* Install hooks. */
	prev_transformExpr = ParseExprTransform_hook;
	ParseExprTransform_hook = transformNamedParameter;
}

/*
 * Module unload callback
 */
void
_PG_fini(void)
{
	/* Uninstall hooks. */
	ParseExprTransform_hook = prev_transformExpr;
}

/*
 * Basic rule - don't duplicate code, 
 *    transformation have to be transitive!!
 * 
 */
Node *
transformNamedParameter(ParseState *pstate, Node *expr)
{
	/* 
	 * transform possible named parameters (with ADA style) to pg
	 */
	if (IsA(expr, FuncCall))
	{
		FuncCall   *fn = (FuncCall *) expr;
		List		*modargs = NIL;
		ListCell	*args;
		bool			modified_args = false;

		foreach(args, fn->args)
		{
			Node	*arg = lfirst(args);
			
			if (IsA(arg, A_Expr) && ((A_Expr *) arg)->kind == AEXPR_OP)
			{
				A_Expr *aexpr = (A_Expr *) arg;
				if (IsA(aexpr->lexpr, ColumnRef))
				{
					Node *opname = linitial(aexpr->name);
					if (IsA(opname, String) && strcmp(strVal(opname), "=>") == 0)
					{
						List	*fields = ((ColumnRef *) aexpr->lexpr)->fields;
						Node	*paramname = linitial(fields);
						ArgExpr		*argexpr;
						
						if (!IsA(paramname, String) || list_length(fields) != 1)
							ereport(ERROR,
								    (errcode(ERRCODE_SYNTAX_ERROR),
								     errmsg("expected parameter name"),
								     parser_errposition(pstate, exprLocation(aexpr->lexpr))));
						
						argexpr = (ArgExpr *) makeNode(ArgExpr);
						argexpr->name = strVal(paramname);
						argexpr->expr = aexpr->rexpr;
						
						modified_args = true;
						arg = (Node *) argexpr;
					}
				}
			}
			modargs = lappend(modargs, arg);
		}
		if (modified_args)
			fn->args = modargs;
	}

	if (prev_transformExpr)
		return prev_transformExpr(pstate, expr);
	else
		return standard_transformExpr(pstate, expr);
}

