CREATE OR REPLACE function email_in( cstring ) returns email AS 'emaildt', 'email_in' LANGUAGE C STRICT;
CREATE OR REPLACE function email_out( email ) returns cstring AS 'emaildt', 'email_out' LANGUAGE C STRICT;
CREATE OR REPLACE function email_recv( internal ) returns email AS 'emaildt', 'email_recv' LANGUAGE C STRICT;
CREATE OR REPLACE function email_send( email ) returns bytea AS 'emaildt', 'email_send' LANGUAGE C STRICT;
CREATE TYPE email ( INPUT = email_in, OUTPUT = email_out, RECEIVE = email_recv, SEND = email_send, INTERNALLENGTH = VARIABLE, ALIGNMENT = int4 );

-- Coneversion functions
CREATE OR REPLACE function text( email ) returns text AS 'emaildt', 'email_text' LANGUAGE C STRICT;
CREATE CAST ( email AS text ) with function text( email );

CREATE OR REPLACE function email( text ) returns email AS 'emaildt', 'text_email' LANGUAGE C STRICT;
CREATE CAST ( text AS email ) with function email( text );


-- Ordering functions
CREATE OR REPLACE function email_eq( email, email ) returns boolean AS 'emaildt', 'email_eq' LANGUAGE C STRICT;
CREATE OR REPLACE function email_neq( email, email ) returns boolean AS 'emaildt', 'email_neq' LANGUAGE C STRICT;
CREATE OR REPLACE function email_lt( email, email ) returns boolean AS 'emaildt', 'email_lt' LANGUAGE C STRICT;
CREATE OR REPLACE function email_le( email, email ) returns boolean AS 'emaildt', 'email_le' LANGUAGE C STRICT;
CREATE OR REPLACE function email_gt( email, email ) returns boolean AS 'emaildt', 'email_gt' LANGUAGE C STRICT;
CREATE OR REPLACE function email_ge( email, email ) returns boolean AS 'emaildt', 'email_ge' LANGUAGE C STRICT;
CREATE OR REPLACE function btemailcmp( email, email ) returns int4 AS 'emaildt', 'btemailcmp' LANGUAGE C STRICT;
CREATE OR REPLACE function hashemail( email ) returns int4 AS 'emaildt', 'hashemail' LANGUAGE C STRICT;

-- Domain extraction
CREATE OR REPLACE function email_domain( email, text ) returns boolean AS 'emaildt', 'email_domain' LANGUAGE C STRICT;
CREATE OPERATOR >> ( PROCEDURE=email_domain, LEFTARG=email, RIGHTARG=text );

-- Ordering OPERATORs
CREATE OPERATOR < ( PROCEDURE=email_lt, LEFTARG=email, RIGHTARG=email, COMMUTATOR= >, NEGATOR= >=, RESTRICT=scalarltsel, JOIN=scalarltjoinsel );
CREATE OPERATOR <= ( PROCEDURE=email_le, LEFTARG=email, RIGHTARG=email, COMMUTATOR= >=, NEGATOR= >, RESTRICT=scalarltsel, JOIN=scalarltjoinsel );
CREATE OPERATOR > ( PROCEDURE=email_gt, LEFTARG=email, RIGHTARG=email, COMMUTATOR= <, NEGATOR= <=, RESTRICT=scalargtsel, JOIN=scalargtjoinsel );
CREATE OPERATOR >= ( PROCEDURE=email_ge, LEFTARG=email, RIGHTARG=email, COMMUTATOR= <=, NEGATOR= <, RESTRICT=scalargtsel, JOIN=scalargtjoinsel );
CREATE OPERATOR <> ( PROCEDURE=email_neq, LEFTARG=email, RIGHTARG=email, COMMUTATOR= <>, NEGATOR= =, RESTRICT=neqsel, JOIN=neqjoinsel );
CREATE OPERATOR = ( PROCEDURE=email_eq, LEFTARG=email, RIGHTARG=email, COMMUTATOR= =, NEGATOR= <>, RESTRICT=eqsel, JOIN=eqjoinsel, HASHES, MERGES, SORT1= < );
CREATE OPERATOR class email_ops DEFAULT FOR TYPE email USING btree AS OPERATOR 1 < , OPERATOR 2 <= ,  OPERATOR 3 = , OPERATOR 4 >= , OPERATOR 5 > ,  FUNCTION 1 btemailcmp( email, email );
CREATE OPERATOR class email_ops DEFAULT FOR TYPE email USING hash AS OPERATOR 1 = , FUNCTION 1 hashemail( email );

