#include "postgres.h"
#include "access/hash.h"
#include "libpq/pqformat.h"
#include <string.h>

#include "email.h"


/*
 *		email_in			- converts an email to a email struct
 */

PG_FUNCTION_INFO_V1(email_in);
Datum
email_in(PG_FUNCTION_ARGS)
{
    char  *a_email = PG_GETARG_CSTRING(0);
    email *my_result;
	unsigned int my_result_len;
    
    char  *my_at_pos;

    //Here I have to validate the string
    //TODO

    int my_email_len = strlen( a_email );
    

    // At this point my_email string is valid and the following
    // code will work
    my_at_pos = strstr( a_email, "@" );

	if ( my_at_pos == NULL ) {
		ereport(ERROR,
				(errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
			   errmsg("Character '@' missing in address: \"%s\"", a_email)));
	}
    
    
    my_result_len = VARHDRSZ + 	            //sizeof(int4)
				    sizeof(unsigned int) +  //USER LEN
                    my_email_len;

    my_result = (email *) palloc(my_result_len);
	memset(my_result, 0, my_result_len); 

	my_result->lenght     = my_result_len;
	my_result->user_len   = my_at_pos - a_email;
    
    memcpy(my_result->address, a_email, my_email_len );
    

    return PointerGetDatum(my_result);
}


/*
 *		email_out	
 */
PG_FUNCTION_INFO_V1(email_out);
Datum
email_out(PG_FUNCTION_ARGS)
{
    email *a_email = (email *) PG_GETARG_POINTER(0); 
    char  *my_result;
	unsigned int my_result_len = EMAIL_ADDRESS_LEN(a_email);
    
    my_result = (char *) palloc( my_result_len + 1);
	memset(my_result, 0, my_result_len+1);
    
    memcpy( my_result, a_email->address, my_result_len );
    
    PG_RETURN_CSTRING( my_result );
}


/*
 *		email_recv	
 */
PG_FUNCTION_INFO_V1(email_recv);
Datum
email_recv(PG_FUNCTION_ARGS)
{
	StringInfo	my_buf = (StringInfo) PG_GETARG_POINTER(0);
	email      *my_email;
	unsigned int my_email_len;

    int my_expected_len = pq_getmsgint(my_buf, sizeof(unsigned int) );
	int my_user_len     = pq_getmsgint(my_buf, sizeof(unsigned int) );

	int my_address_len;
	char *my_address = pq_getmsgtext(my_buf, my_expected_len, &my_address_len);

	
	my_email_len = VARHDRSZ + 
				   sizeof(unsigned int) + 
				   my_address_len;

	my_email = (email *) palloc( my_email_len );
	memset(my_email, 0, my_email_len);

	my_email->lenght     = my_email_len;
	my_email->user_len   = my_user_len;
    memcpy(my_email->address, my_address, my_address_len );
    
    

    PG_RETURN_CSTRING( my_email );
}

/*
 *		email_recv	
 */
PG_FUNCTION_INFO_V1(email_send);
Datum
email_send(PG_FUNCTION_ARGS)
{
	email          *my_email = (email *) PG_GETARG_POINTER(0); 
	StringInfoData	my_buf;

    unsigned int my_address_len = EMAIL_ADDRESS_LEN(my_email);

    pq_begintypsend(&my_buf);
	pq_sendint(&my_buf, my_address_len, sizeof(unsigned int));
	pq_sendint(&my_buf, my_email->user_len, sizeof(unsigned int));
	pq_sendtext(&my_buf, my_email->address, my_address_len);
    
	PG_RETURN_BYTEA_P(pq_endtypsend(&my_buf));
}



PG_FUNCTION_INFO_V1(email_text);

Datum
email_text(PG_FUNCTION_ARGS)
{
	email *a_email = (email *) PG_GETARG_POINTER(0);
	text  *my_result;

	int my_len = VARHDRSZ + EMAIL_ADDRESS_LEN(a_email);

	my_result = (text *) palloc(my_len); 

    VARATT_SIZEP(my_result) = my_len;
	memcpy(VARDATA(my_result), a_email->address, EMAIL_ADDRESS_LEN(a_email));


	PG_RETURN_TEXT_P(my_result);
}


PG_FUNCTION_INFO_V1(text_email);

Datum
text_email(PG_FUNCTION_ARGS)
{
	text *a_text = (text *) PG_GETARG_POINTER(0);
    
	int my_len = VARSIZE(a_text) - VARHDRSZ;

	char *email_str = palloc( my_len + 1);
    memcpy(email_str, VARDATA(a_text), my_len);
	email_str[my_len] = '\0';

	return DirectFunctionCall1(email_in, CStringGetDatum(email_str));
}


static int32
email_cmp(const email *a1, const email *a2)
{
	int32 res;
	
	char* str1 = (char*)palloc( EMAIL_ADDRESS_LEN(a1) + 1 );
	char* str2 = (char*)palloc( EMAIL_ADDRESS_LEN(a2) + 1 );

	memcpy(str1, a1->address, EMAIL_ADDRESS_LEN(a1) );
	str1[EMAIL_ADDRESS_LEN(a1)] = '\0';

	memcpy(str2, a2->address, EMAIL_ADDRESS_LEN(a2) );
	str2[EMAIL_ADDRESS_LEN(a2)] = '\0';

	res = strcmp( str1, str2);

	pfree(str1);
	pfree(str2);
    
	return res;
}



PG_FUNCTION_INFO_V1(email_eq);
Datum
email_eq(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

    
	PG_RETURN_BOOL(email_cmp(a_email_l, a_email_r) == 0);

}

PG_FUNCTION_INFO_V1(email_neq);
Datum
email_neq(PG_FUNCTION_ARGS)
{
    PG_RETURN_BOOL(!DirectFunctionCall2(email_eq, PG_GETARG_DATUM(0), PG_GETARG_DATUM(1)));
}


PG_FUNCTION_INFO_V1(email_lt);
Datum
email_lt(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

    PG_RETURN_BOOL(email_cmp(a_email_l, a_email_r) < 0);
}


PG_FUNCTION_INFO_V1(email_le);
Datum
email_le(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

    PG_RETURN_BOOL(email_cmp(a_email_l, a_email_r) <= 0);
}

PG_FUNCTION_INFO_V1(email_gt);
Datum
email_gt(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

    PG_RETURN_BOOL(email_cmp(a_email_l, a_email_r) > 0);
}


PG_FUNCTION_INFO_V1(email_ge);
Datum
email_ge(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

    PG_RETURN_BOOL(email_cmp(a_email_l, a_email_r) >= 0);
}


PG_FUNCTION_INFO_V1(btemailcmp);

Datum
btemailcmp(PG_FUNCTION_ARGS)
{
	email *a_email_l = (email *) PG_GETARG_POINTER(0);
	email *a_email_r = (email *) PG_GETARG_POINTER(1);

	PG_RETURN_INT32(email_cmp(a_email_l, a_email_r));
}

PG_FUNCTION_INFO_V1(hashemail);

Datum
hashemail(PG_FUNCTION_ARGS)
{
	email    *key = (email *) PG_GETARG_POINTER(0);

	return hash_any((unsigned char *) key, sizeof(email));
}

PG_FUNCTION_INFO_V1(email_domain);

Datum
email_domain(PG_FUNCTION_ARGS)
{
	email *a_email  = (email *) PG_GETARG_POINTER(0);
	text  *a_domain = (text *) PG_GETARG_POINTER(1);

	int res;

	char *my_str_email_domain;
	char *my_str_domain;

	int my_len;
	
	my_len = EMAIL_DOMAIN_LEN(a_email);
	my_str_email_domain = (char *)palloc( my_len + 1);
	memcpy(my_str_email_domain, EMAIL_DOMAIN(a_email), my_len);

	my_str_email_domain[my_len] = '\0';

	my_len = VARSIZE(a_domain);
	my_str_domain = (char *)palloc( my_len + 1);
	memcpy(my_str_domain, VARDATA(a_domain), my_len);
	my_str_domain[my_len] = '\0';

	res = strcmp( my_str_email_domain, my_str_domain );

	pfree( my_str_email_domain );
	pfree( my_str_domain );
    
	PG_RETURN_BOOL(res == 0);
}



