/*
 * AUTHOR:
 *   Bernd Helmle
 * DESCRIPTION:
 *   Functions to translate a SQL92 compliant view definition
 *   into update rules.
 * TODO:
 *   - CHECK CASCADE / LOCAL OPTION
 */

#ifndef VIEW_UPDATE_H
#define VIEW_UPDATE_H

#include <postgres.h>
#include <fmgr.h>
#include <catalog/pg_type.h>
#include <catalog/pg_operator.h>
#include <catalog/pg_rewrite.h>
#include <executor/spi.h>
#include <lib/stringinfo.h>
#include <unistd.h>
#include <nodes/makefuncs.h>
#include <nodes/print.h>
#include <rewrite/rewriteSupport.h>
#include <rewrite/rewriteDefine.h>
#include <parser/parsetree.h>
#include <utils/lsyscache.h>
#include <utils/syscache.h>
#include <utils/errcodes.h>
#include <parser/parse_func.h>
#include <parser/parse_oper.h>

typedef TargetEntry** ViewDefColumnList;

/*
 * Helper macros to access the column
 * lookup table
 */
#define ColumnListCreate(ptr, size) \
    (ptr) = (ViewDefColumnList)palloc( (size) * \
									   sizeof( TargetEntry * ) );
#define ColumnListGet(ptr, index) (ptr)[ (index) ];
#define ColumnListSet(ptr, index, item) (ptr)[(index)] = (item);
#define ColumnListItemIsNull(ptr, index) ((ptr)[(index)] == NULL)
#define ColumnListIsNull(ptr) ((ptr) == NULL)

struct ViewBaseRelationItem {

	Oid           reloid;  /* OID for this base relation */
	List          *childs; /* child relations, NIL if no children */
	Query         *rule;   /* _RETURN rule of a view relation */
	TargetEntry   **tentries; /* saves order of column target list */
	Form_pg_class rel;     /* pg_class structure of relation */
	bool          isView;  /* relation is a view */

};

struct ViewBaseRelation {

	Oid fatherRelation;  /* Oid of father relation, 0 indicates root */
	List *defs;          /* relation and, if relation is a view, return rule */

};

char
makeViewCheckOption(bool check,
					bool cascaded);

extern void
read_rearranged_colls( struct ViewBaseRelation *tree );

extern bool
check_reltree( struct ViewBaseRelation *node,
			   List   **baserelations );

extern bool
checkTree( const Query *query,
		   struct ViewBaseRelation *tree );

extern Oid 
get_reloid_from_select( const Query         *select,
						RangeTblEntry **rel_entry);

extern Query *
transform_select_to_update( const Query    *update,
							const Relation rel,
							const RangeVar       *var,
							TargetEntry    **tentries,
							bool           checkOption,
							bool           checkCascade );

extern Query *
transform_select_to_insert( const Query    *select,
							const Relation rel,
							const RangeVar       *var,
							TargetEntry    **tentries,
							bool           checkOption,
							bool           checkCascade );

extern Query *
transform_select_to_delete( const Query    *delete,
							const Relation rel,
							const RangeVar       *var,
							TargetEntry    **tentries,
							bool           checkOption,
							bool           checkCascade );

extern void
get_base_relations( struct ViewBaseRelation *tree,
	                List   **baserelations );

void
get_base_base_relations( const Query *view,
						 Oid         baserel,
						 List        **list );

extern void
copyReversedTargetEntryPtr( List              *targetList,
							ViewDefColumnList targets );

#endif /* VIEW_UPDATE_H */
