/* $Id: pg_start.c,v 1.1 2000/11/07 21:52:51 pascal Exp $
 *
 * start.c - SMARTDATA initial demo of PicoGUI possibilities
 *
 *
 * PicoGUI small and efficient client/server GUI
 * Copyright (C) 2000 Micah Dowty <micahjd@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Contributors: Philippe Ney <philippe.ney@smartdata.ch>
 * 
 * 
 * 
 */

#include <picogui.h>


/*** Global variables */
char PATH[100];

/*** Widget variables */
pghandle wMainApp;
pghandle wMainStr,wAboutStr;			  


void init(char *str) {
  char* p;

  wMainStr = pgNewString( \
    "Mobile internet appliances\n"
    "will likely be the smart merge\n"
    "of computer power, multimedia,\n"
    "Internet, wireless telecommunication\n"
    "technology and fashion; this is\n"
    "the reason why this market is to be\n"
    "considered as one of the major fast\n"
    "growing markets at the beginning of\n"
    "this millennium.\n"
    "\n"
    "SMARTDATA is going to revolutionize\n"
    "the wireless internet market because\n"
    "of its modular device that's\n"
    "the size of a couple of credit\n"
    "cards. It's called CHIPSLICE...It's\n"
    "a combination of whatever the user\n"
    "needs it to be.\n"
    "\n"
    "The key is its unique\n"
    "modularity...it can be configured\n"
    "and updated faster than any\n"
    "other system and will always have\n"
    "first to market advantage. Check\n"
    "what happens when modular\n"
    "approach is not followed !!\n"
    "(http://www.smartdata.ch/download \\\n"
    "                               /bigproblems.pdf)\n"
    "\n"
    "Technologies developed by\n"
    "SMARTDATA are also available\n"
    "for licensing; please contact us\n"
    "(info@smartdata.ch) regarding all\n"
    "technologies in which you have\n"
    "interest.\n\n");

  wAboutStr = pgNewString( \
    "This little\n"
    "text as as only goal\n\n"
    "to demonstrate\n"
    "the scroll\n"
    "functionality\n"
    "of PicoGUI.\n\n\n"
    "Demonstrator version 0.2*\n"
    "Copyright (C) 2000 SMARTDATA\n"
    "<info@smartdata.ch>\n\n"
    "PicoGUI a small and efficient\n"
    "client/server GUI\n"
    "Copyright (C) 2000 Micah Dowty\n"
    "<micahjd@users.sourceforge.net>\n\n"
    "ChipSlice architecture\n"
    "Copyright (C) 2000 SMARTDATA\n"
    "<info@smartdata.ch>\n");

  /* Path initialization for data */
  getcwd(PATH,sizeof(PATH));
  strcat(PATH,"/");
  p = strrchr(str,(int)'/');
  strncat(PATH,str,(p-str+1));
}

void btnExitApp(short event,pghandle from,long param) {
  _pg_cleanup();
  pgUpdate();
}

void btnAboutBoxClose(short event,pghandle from,long param) {
  pgLeaveContext();
  pgUpdate();
}

void btnAboutBox(short event,pghandle from,long param) {
  pghandle wAboutPopup,wAboutToolbar,wAboutImage,wTitleBox;
  pghandle wAboutBox,wAboutBoxText,wAboutBoxTextScroll;
  struct pgmemdata bitimg;
  struct pgmemdata bitmask;

  char path[150];

  /* Create a Context for the About Box */
  pgEnterContext();

  /* Create the About popup window */
  wAboutPopup = pgNewPopupAt(20,40,200,180);

  /* Toolbar for the About popup */
  wAboutToolbar = pgNewWidget(PG_WIDGET_TOOLBAR,0,0);
  pgSetWidget(0,PG_WP_SIDE,PG_S_BOTTOM,0);

  /* Box for text and image title of the About popup*/
  wTitleBox = pgNewWidget(PG_WIDGET_BOX,PG_DERIVE_AFTER,wAboutToolbar);
  pgSetWidget(0,PG_WP_SIDE,PG_S_TOP,PG_WP_SIZE,75,0);
  /* Text title */
  pgNewWidget(PG_WIDGET_LABEL,PG_DERIVE_INSIDE,wTitleBox);
  pgSetWidget(0,PG_WP_SIDE,PG_S_LEFT,PG_WP_ALIGN,PG_A_LEFT,
              PG_WP_TEXT,pgNewString("About Title\n(label widget)"),0);

  /* Image title. Load bitmap image and bitmask with 'or' operation for blit */
  strcpy(path,PATH);
  strcat(path,"tux.pnm");
  bitimg = pgFromFile(path);
  strcpy(path,PATH);
  strcat(path,"tux_mask.pnm");
  bitmask = pgFromFile(path);
  pgNewWidget(PG_WIDGET_BITMAP,0,0);
  pgSetWidget(0,PG_WP_SIDE,PG_S_RIGHT,0);
  pgSetWidget(0,PG_WP_BITMAP,pgNewBitmap(bitimg),
              PG_WP_LGOP,PG_LGOP_OR,
	      PG_WP_BITMASK,pgNewBitmap(bitmask),0);

  /* Box for the texts */
  wAboutBox = pgNewWidget(PG_WIDGET_BOX,PG_DERIVE_AFTER,wTitleBox);
  pgSetWidget(0,PG_WP_SIDE,PG_S_ALL,0);
  /* Text widget */
  wAboutBoxText = pgNewWidget(PG_WIDGET_LABEL,PG_DERIVE_INSIDE,wAboutBox);
  pgSetWidget(0,PG_WP_SIDE,PG_S_ALL,PG_WP_TEXT,wAboutStr,0);
  /* Scroll widget */
  wAboutBoxTextScroll = pgNewWidget(PG_WIDGET_SCROLL,PG_DERIVE_BEFORE,
                                    wAboutBoxText);
  pgSetWidget(0,PG_WP_BIND,wAboutBoxText,0);  /* Event handler for scroll */

  /* Buttons close inside the Control Toolbar */
  pgNewWidget(PG_WIDGET_BUTTON,PG_DERIVE_INSIDE,wAboutToolbar);
  pgSetWidget(0,PG_WP_SIDE,PG_S_LEFT,PG_WP_TEXT,pgNewString("Close"),0);
  pgBind(PGDEFAULT,PG_WE_ACTIVATE,&btnAboutBoxClose);     /* Event handler */

  pgEventLoop();
}

void btnPopupClose(short event,pghandle from,long param) {
  pgLeaveContext();
  pgUpdate();
}

void btnPopup(short event,pghandle from,long param) {
  pghandle wPopup,wPopupToolbar,wPopupBox;
  pghandle wPopupLabel,wPopupStr;


  /* Create the string */
  wPopupStr = pgNewString("You click on the Popup button\n");

  /* Create a Context for the About Box */
  pgEnterContext();

  /* Create the About popup window */
  wPopup = pgNewPopupAt(45,50,150,40);

  /* Toolbar for the About popup */
  wPopupToolbar = pgNewWidget(PG_WIDGET_TOOLBAR,0,0);
  pgSetWidget(0,PG_WP_SIDE,PG_S_BOTTOM,0);

  /* Box for text of the popup*/
  wPopupBox = pgNewWidget(PG_WIDGET_BOX,PG_DERIVE_AFTER,wPopupToolbar);
  pgSetWidget(0,PG_WP_SIDE,PG_S_ALL,0);
  /* Text */
  pgNewWidget(PG_WIDGET_LABEL,PG_DERIVE_INSIDE,wPopupBox);
  pgSetWidget(0,PG_WP_SIDE,PG_S_LEFT,PG_WP_ALIGN,PG_A_LEFT,
              PG_WP_TEXT,wPopupStr,0);

  /* Buttons close inside the Toolbar */
  pgNewWidget(PG_WIDGET_BUTTON,PG_DERIVE_INSIDE,wPopupToolbar);
  pgSetWidget(0,PG_WP_SIDE,PG_S_LEFT,PG_WP_TEXT,pgNewString("Close"),0);
  pgBind(PGDEFAULT,PG_WE_ACTIVATE,&btnPopupClose);     /* Event handler */

  pgEventLoop();
}




/*** Main program */
int main(int argc, char *argv[])
{
  pghandle wToolbar1,wToolbar2;
  pghandle wMainTextBox;

  /* PicoGUI initialization */
  puts("*** pgInit()");
  pgInit(argc,argv);

  /* Init strings and path */
  puts("*** init()");
  init(argv[0]);

  /* Main application */
  puts("*** pgRegisterApp()");
  wMainApp = pgRegisterApp(PG_APP_NORMAL,"Main app",
                           PG_APPSPEC_HEIGHT,250,
                           PG_APPSPEC_SIDE,PG_S_TOP,0);
  
  /* A first toolbar on the TOP */
  puts("*** wToolbar1 = pgRegisterApp()");
  wToolbar1 = pgRegisterApp(PG_APP_TOOLBAR,"A toolbar",
		           PG_APPSPEC_SIDE,PG_S_TOP,0);
  /* A second toolbar on the BOTTOM */
  puts("*** wToolbar1 = pgRegisterApp()");
  wToolbar2 = pgRegisterApp(PG_APP_TOOLBAR,"A toolbar",
		            PG_APPSPEC_SIDE,PG_S_BOTTOM,0);

  /* Widgets inside the first toolbar */
  puts("*** 1:pgNewWidget() ...");
  pgNewWidget(PG_WIDGET_BUTTON,PG_DERIVE_INSIDE,wToolbar1);
  puts("*** 1:pgSetWidget()");
  pgSetWidget(0,PG_WP_TEXT,pgNewString("Popup"),0);
  puts("*** 1:pgBind()");
  pgBind(PGDEFAULT,PG_WE_ACTIVATE,&btnPopup);       /* Event handler
                                                     * for this button */

  puts("*** 2:pgNewWidget() ...");
  pgNewWidget(PG_WIDGET_BUTTON,0,0);
  puts("*** 2:pgSetWidget()");
  pgSetWidget(0,PG_WP_TEXT,pgNewString("About"),
              PG_WP_SIDE,PG_S_RIGHT,0);
  puts("*** 2:pgBind()");
  pgBind(PGDEFAULT,PG_WE_ACTIVATE,&btnAboutBox);    /* Event handler
                                                     * for this button */

  /* Exit button inside the second toolbar */
  puts("*** 3:pgNewWidget() ...");
  pgNewWidget(PG_WIDGET_BUTTON,PG_DERIVE_INSIDE,wToolbar2);
  puts("*** 3:pgSetWidget()");
  pgSetWidget(0,PG_WP_TEXT,pgNewString("Exit"),0);
  puts("*** 3:pgBind()");
  pgBind(PGDEFAULT,PG_WE_ACTIVATE,&btnExitApp);     /* Event handler
                                                     * for this button */

  /* Box with text inside the application */
  puts("*** wMainTextBox = pgNewWidget()");
  wMainTextBox = pgNewWidget(PG_WIDGET_BOX,PG_DERIVE_INSIDE,wMainApp);
  puts("*** pgSetWidget()");
  pgSetWidget(0,PG_WP_SIDE,PG_S_ALL,0);
  /* Text */
  puts("*** 4:pgNewWidget()");
  pgNewWidget(PG_WIDGET_LABEL,PG_DERIVE_INSIDE,wMainTextBox);
  puts("*** 4:pgSetWidget()");
  pgSetWidget(0,PG_WP_SIDE,PG_S_LEFT,PG_WP_ALIGN,PG_A_LEFT,
              PG_WP_TEXT,wMainStr,0);

  /*** Run it! ***/
  puts("*** pgEventLoop()");
  pgEventLoop();

  return 0;
}



/* The End */
