(class +Page +Treeable)
(rel name   (+Ref +String))
(rel path   (+Key +String))
(rel parent (+Ref +Link) NIL (+Page))

(dm children> ()
   (super '+Page))

(dm req> (Name Path . @)
   (request '(+Page) 'name Name 'path Path 'parent (next)))
    
(dm get> (Path)
   (db 'path '+Page Path))

(dm boxes> (Path)
   (let Boxes (collect 'page '+Box (get> '+Page Path))
      (attr> '+Gh (sortBy> '+Gh Boxes 'pos T) 'type)))

(dm edit> ()
   (objToLst (get> '+Page (areq 'path))))

(dm selList> ()
   (mapcar '((P)(list (; P name) (pack P))) (collect 'path '+Page)))

(dm getPage> ()
   (boxes> '+Page (req 'path)))
    
(dm pageTree> ()
   (getTree> (get> '+Page (req 'path)) '(nil)))
    
(dm byPath> ()
   (getl2 (get> '+Page (areq 'path))))
    
