#!bin/picolisp lib.l

(load "dbg.l" "lib/debug.l" "lib/http.l" "lib/xhtml.l" "lib/form.l" "lib/misc.l" "lib/boss.l" "lib/too.l")

#(traceAll)

(setq *BP "projects/db-server/")
(setq *ErPath (pack *BP "er.l"))
(setq *DBPath "/opt/picolisp/projects/db-server/db/")

(load *ErPath)
(pool *DBPath *Dbs)

(de getRelations (Cls)
   (filter '((X) (isa '+relation (car X))) (getl Cls)))

(de getEntities ()
   (filter '((X) (isa '+Entity X)) (all)))
    
(setq *ClassTree
   (sort
      (make 
         (for Cls (getEntities)
            (link (list Cls (getRelations Cls)))))))
    
(de flatten @
   (make 
      (for L (rest) 
         (recur (L)
            (for El L
               (if (lst? El)
                  (recurse El)
                  (link El)))))))

(de getClass (Cls)
   (find '((X)(= Cls (car X))) *ClassTree))

(de getRels (Cls)
   (make 
      (for El (cadr (getClass Cls))
         (link (cdr El)))))
    
(de findRel (Cls Rel)
   (find '((Cell)(= Rel (cdr Cell))) (cadr (getClass Cls))))

(de hasPrefix (Cls Rel Pref)
   (let Cell (findRel Cls Rel)
      (member Pref (type (car Cell)))))
    
(de hasPrefixes (Cls Prefixes)
   (make
      (for Cell (cadr (getClass Cls))
         (when 
            (=  
               (length Prefixes) 
               (length (extract '((Px)(member Px (type (car Cell)))) Prefixes)))
            (link (cdr Cell))))))
    
(de hasExact (Cls Rel Pref)
   (let Cell (findRel Cls Rel)
      (= Pref (type (car Cell)))))

(de getRefCls (Rel . @)
   (let Rel (if (lst? Rel) Rel (findRel (next) Rel)) 
      (car (; (car Rel) type))))
    
(de fup (Str)
   (let Lst (chop Str)
      (pack (uppc (car Lst)) (pack (cdr Lst)))))

(de matchAllRels (Cls Types)
   (make 
      (for Cell (cadr (getClass Cls))
         (when (= Types (type (car Cell)))
            (link (cdr Cell))))))
    
(de getNumKey (Cls)
   (car (hasPrefixes Cls '(+Key +Number))))
    
(de getStrKey (Cls)
   (car (hasPrefixes Cls '(+Key +String))))

(de matchPartialRel (Cls Type)
   (make
      (for Cell (cadr (getClass Cls))
         (when (member Type (type (car Cell)))
            (link (cdr Cell))))))
    
(de isInAll (Cls Type)
   (= (length (getRels Cls)) (length (matchPartialRel Cls Type))))

(de getIndex (Cls)
   (car (flatten (mapcar '((Type)(matchPartialRel Cls Type)) '(+Key +Ref)))))
    
(de getLbl (Cls)
   (find 
      '((Lbl)
          (find '((Rel)(= Lbl Rel)) (getRels Cls))) 
      '(nm name title tag uname username label lbl wd word value)))
    
(de getClsNm (Cls)
   (pack (cdr (chop Cls))))

(de prNl ()
   (prin "^J"))

(de prNl? (Nl)
   (when Nl (prNl)))

(de prMenuRow (Cls)
   (prin "          (" (sym (sym (car Cls))) " " "\"" *BP "pico-admin/scaffolding/"  (getClsNm (car Cls)) ".l\"" ")"))

(de prMainMenu ()
  (prin "(de menu (Ttl . Prg)^J")
  (prin "  (action^J")
  (prin "    (html 0 Ttl *Css NIL^J")
  (prin "      (<div> '(id . menu)^J")
  (prin "        (<menu>^J")
  (mapc '((Cls)(prMenuRow Cls) (prNl)) (cdr *ClassTree))
  (prMenuRow (car *ClassTree))
  (prin "))^J")
  (prin "      (<div> '(id . main) (run Prg 1)))))"))
    
#NIL (gui '(+E/R +TextField) '(nm2 : home obj) 40)
#,"Customer" (gui '(+ChoButton) '(choCuSu (field 1)))
#(gui '(+E/R +Obj +TextField) '(article : home obj) '(title +Article) 30)
#(prin "        \"" (fup Rel) "\" (gui '(+ChoButton) '(cho" (getClsNm (getRefCls Rel Cls)) " (field 1)))")
(de prGridRow (Cls Rel)
   (cond
      ((hasPrefix Cls Rel '+Link)
         (prin "        \"" (fup Rel) "\" (gui '(+E/R +Obj +TextField) '(" Rel " : home obj) '(" (getLbl (getRefCls Rel Cls)) " " (getRefCls Rel Cls) ") 30)"))
      (T (prin "        \"" (fup Rel) "\" (gui '(+E/R +TextField) '(" Rel " : home obj) 40)"))))

(de prLinkHeadline (Cls Rel)
   (prin "(: " Rel " " (getLbl (getRefCls Rel Cls)) ")"))

(de prMenu (Cls)
   (prin "(menu \"Working with " Cls "\"^J")
   (prin "  (ifn *ID^J")
   (prin "    (prog^J")
   (prin "      (<h3> NIL \"Select\" \" \" \"" Cls "\")^J")
   (prin "      (form 'dialog (cho" (getClsNm Cls) ")))^J")
   (prin "    (<h3> NIL \"" Cls "\")^J")
   (prin "    (form NIL^J")
   (prin "      (<h2> NIL (<id> ") 
   (ifn (isInAll Cls '+Link)
     (prin "(: " (or (getStrKey Cls) (getNumKey Cls)) ")")
     (mapc '((Rel)(prLinkHeadline Cls Rel) (prin " -- ")) (cdr (getRels Cls))) 
     (prLinkHeadline Cls (car (getRels Cls)))) 
   (prin "))^J")
   (prin "      (panel T (pack \"" Cls "\" \" @1\") T '(cho" (getClsNm Cls) ") '" (or (getNumKey Cls) (getIndex Cls)) " '" Cls ")^J")
   (prin "      (<grid> " (length (getRels Cls)) "^J")
   (mapc '((Rel)(prGridRow Cls Rel) (prNl)) (cdr (getRels Cls)))
   (prGridRow Cls (car (getRels Cls))) (prin ")^J")
   (prin "    (<spread> NIL (editButton T)) ) ) )"))

(de getGlRel (Cls Rel)
   (pack "*" (fup (getClsNm Cls)) (fup Rel)))

(de prSearchRow (Rel)
   (prin "      \"" (fup Rel) "\" (gui '" Rel " '(+Var +TextField) '" (getGlRel Cls Rel) " 20)^J"))

#(tolr @Sup @@ sup nm)
(de prFilterRow (Cls Rel)
   (cond
      ((hasPrefix Cls Rel '+Link)
         (prin "             (same @" (fup Rel) " @@ " Rel " " (getLbl (getRefCls Rel Cls)) ")"))
      (T (prin "             (same @" (fup Rel) " @@ " Rel ")"))))

(de prkGetRel (Rel)
   (prin "(: " Rel ") " ))

#'(nr genKey 'nr '+Ord)
(de prNewRow (Cls Rel Nl)
   (cond
      ((or 
         (hasExact Cls Rel '(+Need +Key +Number)) 
         (hasExact Cls Rel '(+Key +Number)))
       (prin "        '(" Rel " genKey '" Rel " '" Cls ")" (when Nl "^J")))
      ((hasPrefix Cls Rel '+Link) 
         (prin ""))
      (T 
         (prin "        '" Rel " " (getGlRel Cls Rel) (when Nl "^J")))))

(de prHeadline (Rel)
   (prin "        (NIL " (sym (fup Rel)) ")"))

(de getRowCnt (Cls)
   (+ 1 (length (getRels Cls))))

#(nm +CuSu @Sup (sup +Item))
(de prSearchGen (Cls Rel)
   (cond
      ((hasPrefix Cls Rel '+Link) 
         (let ClsLink (getRefCls Rel Cls) 
            (prin "(" (getLbl ClsLink) " " ClsLink " @" (fup Rel) " (" Rel " " Cls ")) " )))
      (T (prin "(" Rel " " Cls " " "@" (fup Rel) ") "))))


(de getDisplayRow (Cls Rel)
   (let (Cell (findRel Cls Rel) Type (type (car Cell)))
      (cond
         ((or
             (member '+String Type)
             (member '+Any Type)
             (member '+Blob Type)) 
            "(+TextField)")
         ((member '+Number Type) "(+NumField)")
         ((member Type '((+Aux +Ref +Link) (+Ref +Link))) 
            (pack "(+ObjView +TextField) '(: " (getLbl (getRefCls Cell)) ")")))))

(de prChoCls (Cls)
   (prin "(de cho" (getClsNm Cls) " (Dst)^J")
   (prin "  (diaform '(Dst)^J")
   (prin "    (<grid> \"" (pack (make (do (+ 2 (length (getRels Cls))) (link "-")))) "\"^J")
   (mapc prSearchRow (getRels Cls))
   (prin "      (searchButton '(init> (: home query)))^J")
   (prin "      (resetButton '(") (mapc '((Rel)(prin Rel " ")) (getRels Cls)) (prin "query)))^J")      
   (prin "    (gui 'query '(+QueryChart) (cho)^J")
   (prin "      '(goal^J")
   (prin "         (quote^J")
   (mapc 
      '((Rel)(prin "           @" (fup Rel) " " (getGlRel Cls Rel) "^J")) 
      (getRels Cls))
   (prin "           (select (@@)^J             (")
   (mapc '((Rel)(prSearchGen Cls Rel)) (getRels Cls)) 
   (prin ")^J")
   (mapc 
      '((Rel)(prFilterRow Cls Rel) (prNl)) 
      (cdr (getRels Cls)))
   (prFilterRow Cls (car (getRels Cls))) (prin ")))^J")
   (prin "      " (getRowCnt Cls) "^J")
   (prin "      '((This) (list This ") (mapc prkGetRel (getRels Cls)) (prin ")))^J")
   (prin "    (<table> 'chart \"" Cls "\"^J")
   (prin "      (quote^J")
   (prin "        (btn)^J")
   (prHeadline (car (getRels Cls))) 
   (prNl)
   (mapc '((Rel)(prHeadline Rel)) (cdr (getRels Cls))) (prin ")^J")
   (prin "      (do (cho)^J")
   (prin "        (<row> (alternating)^J")
   (prin "          (gui 1 '(+DstButton) Dst)^J")
   (let N 2 
      (for Rel (cdr (getRels Cls))
         (prin "          (gui " N " '" (getDisplayRow Cls Rel) ")^J")
         (inc 'N)))
   (prin "          (gui " (getRowCnt Cls) " '" (getDisplayRow Cls (car (getRels Cls))) "))))^J")
   (prin "    (<spread>^J")
   (prin "      (scroll (cho))^J")
   (prin "      (newButton T Dst '(" Cls ")^J")
   (mapc '((Rel)(prNewRow Cls Rel T)) (cdr (getRels Cls)))
   (prNewRow Cls (car (getRels Cls)) NIL) (prin ")^J")
   (prin "      (cancelButton))))^J^J"))
    
(de generate ()
   (for Cls (getEntities)
      (out (pack *BP "pico-admin/scaffolding/" (getClsNm Cls) ".l")
         (prChoCls Cls)
         (prNl)
         (prMenu Cls)))
   (out (pack *BP "pico-admin/scaffolding/menu.l")
      (prMainMenu)))
    







