(load "dbg.l" "lib/debug.l" "lib/http.l" "lib/xhtml.l" "lib/form.l" "lib/misc.l" "hslib/global-helpers.l")

(setq *BP "/opt/picolisp/projects/db-server/")

(redef ht:Pack (Lst)
   (ht:Pack (replace Lst "+" " ")))

(de req (Key)
   (get Key 'http))
  
(de areq (Key)
   (any (req Key)))

# Introspection
(de getType (Obj)
   (car (type Obj)))

(de getRelations (Cls)
   (filter '((X) (isa '+relation (car X))) (getl Cls)))

(de getEntities ()
   (filter '((X) (isa '+Entity X)) (all)))
    
(de ClassTree ()
   (sort
      (make 
         (for Cls (getEntities)
            (link (list Cls (getRelations Cls)))))))

(de getClass (Cls)
   (find '((X)(= Cls (car X))) (ClassTree)))

(de findRel (Obj Rel)
   (find '((Cell)(= Rel (cdr Cell))) (cadr (getClass (getType Obj)))))
    
(de getPrefix (Obj Rel)
   (let Cell (findRel Obj Rel)
      (type (car Cell))))

# End

(de objToLst (Obj)
   (make
      (for Pair (getl Obj) 
         (link 
            (pack (cdr Pair)) 
            (let Pref (getPrefix Obj (cdr Pair)) 
               (list 
                  (pack (car Pair)) 
                  Pref
                  (cond
                     ((member '+Link Pref) (selList> Obj))
                     (T NIL))))))))

(de exec ()
   (httpHead "text/plain; charset=utf-8")
   (ht:Out T (println (eval (list (areq 'func))))))

#(de getl2 (Obj)
#   (mapcar '((Pair) (list (cdr Pair) (car Pair))) (getl Obj)))
    
(de getl2 (Obj Chain)
   (mapcar '((Pair)
               (list 
                  (pack (cdr Pair)) 
                  (if (ext? (car Pair))
                     (if (and (<> (car Chain) nil) (= (cdr Pair) (car Chain)))
                        (getl2 (car Pair) (cdr Chain))
                        (pack (car Pair)))
                     (pack (car Pair))))) 
      (getl Obj)))
    
(load (pack *BP "er.l"))
    
(pool (pack *BP "db/") *Dbs)

(de getObj ()
   (httpHead "text/plain; charset=utf-8")
   (ht:Out T (println (objToLst (areq 'obj)))))
    
(de callMethod ()
   (httpHead "text/plain; charset=utf-8")
   (ht:Out T (println (eval (list (any (pack (req 'method) ">")) (lit (any (pack "+" (req 'obj)))))))))

(de start ()
   (off *JS))

(de go () 
   (server 8080 "@start"))
