(load "dbg.l" "lib/debug.l" "lib/http.l" "lib/misc.l")

(setq *Hosts '("localhost" "localhost"))
(setq *HostFileOffsets '(20 40))
(setq *HostPorts '(4041 4042))

(setq *Ext
   (mapcar
      '((@Host @Ext @Port)
         (cons @Ext
            (curry (@Host @Ext @Port (Sock)) (Obj)
               (when (or Sock (setq Sock (connect @Host @Port)))
                  (ext @Ext
                     (out Sock (pr (cons 'qsym Obj)))
                     (prog1 (in Sock (rd))
                        (unless @
                           (close Sock)
                           (off Sock) ) ) ) ) ) ) )
      *Hosts
      *HostFileOffsets
      *HostPorts ) )

(de rsrc ()  # Simple resource handler, ignoring errors or EOFs
   (extract
      '((Host @Ext Port)
         (let? @Sock (connect Host Port)
            (cons
               (curry (@Ext @Sock) (X)  # out
                  (ext @Ext (out @Sock (pr X))) )
               (curry (@Ext @Sock) ()  # in
                  (ext @Ext (in @Sock (rd))) ) ) ) )
      *Hosts
      *HostFileOffsets
      *HostPorts) )

(de peel (Lst)
   (ifn (lst? (car Lst))
      Lst
      (peel (car Lst))))

(de rmEv (N . @)
   (let Sock (connect "localhost" (+ 4040 N))
      (ifn Sock
         (println "no socket")
         (out Sock (pr (peel (rest))))
         (prog1 
            (in Sock (rd))
            (close Sock) ) ) ) )

(de insertTestData ()   
   (println (rmEv 1 'new! ''(+User) ''uname "Jack" ''email "jack@gmail.com"))
   (println (rmEv 2 'new! ''(+User) ''uname "Jane" ''email "jane@gmail.com"))
   (println (rmEv 1 'new! ''(+User) ''uname "Mary" ''email "mary@gmail.com"))
   (println (rmEv 2 'new! ''(+User) ''uname "John" ''email "john@yahoo.com")) )

(de findByEmailPart (Str)
   (mapc show
      (solve
         (quote
            @Str Str
            @Rsrc (rsrc)
            (remote (@Users . @Rsrc)
               (select (@Users)
                  ((email +User @Str))
                  (part @Str @Users email) ) ) )
         @Users ) ) )

#(insertTestData)
(findByEmailPart "yahoo")

