(load "dbg.l" "lib/debug.l" "lib/http.l" "lib/misc.l")

(class +User +Entity)
(rel uname    (+Key +String))
(rel email    (+Fold +Idx +String))

# ./p projects/remote-test/remote.l -go 1
(de go ()
   (setq *IdxNum (format (opt)))
   (setq *DbDir (pack "/opt/picolisp/projects/remote-test/db/"))
   (unless (info *DbDir)
      (call 'mkdir *DbDir))
   (pool (pack *DbDir *IdxNum))
   (rollback)
   (mapc show (collect 'uname '+User))
   (task (port (+ *IdxNum 4040))
      (let? Sock (accept @)
         (unless (fork)
            (in Sock
               (while (rd)
                  (sync)
                  (out Sock
                     (pr (eval @)))))
            (bye))
         (close Sock)))
   (forked) ) 


