
(de checkJson (X Item)
   (unless (= X Item)
      (quit "Bad JSON" Item) ) )

(de readJson ()
   (case (read "_")
      ("{"
         (make
            (for (X (readJson)  (not (= "}" X))  (readJson))
               (checkJson ":" (readJson))
               (link (cons X (readJson)))
               (T (= "}" (setq X (readJson))))
               (checkJson "," X) ) ) )
      ("["
         (make
            (link "[]")  # Array marker
            (for (X (readJson)  (not (= "]" X))  (readJson))
               (link X)
               (T (= "]" (setq X (readJson))))
               (checkJson "," X) ) ) )
      (T
         (let X @
            (if (and (= "-" X) (format (peek)))
               (- (read))
               X ) ) ) ) )

(de printJson (Item)  # For simplicity, without indentation
   (cond
      ((atom Item)
       (cond
          ((=T Item) (prin "true"))
          ((not Item) (prin "false"))
          ((box? Item)
           (printJson
              (mapcar
                 '((Pair) (cons (sym (cdr Pair)) (car Pair)))
                 (getl Item) ) ) )
          (T (print Item)) ) )
      ((= "[]" (car Item))
         (prin "[")
         (map
            '((X)
               (printJson (car X))
               (and (cdr X) (prin ", ")) )
            (cdr Item) )
         (prin "]") )
      (T
         (prin "{")
         (map
            '((X)
               (print (caar X))
               (prin ": ")
               (printJson (cdar X))
               (and (cdr X) (prin ", ")) )
            Item )
         (prin "}") ) ) )
