(load "lib/http.l" "pl-web/cmd.l" "pl-web/hash.l"  "lib/boss.l")

(de crd ()
   (pack (pwd) "/" (car (file))))

(undef '_htSet)

(de _htSet ("Var" Val)
   (push '*Post (list (ht:Pack "Var") Val))
   Val)

(undef '_htMultipart)

(de _htMultipart ()
   (use (L @X @N @V)
      (setq L (line))
      (while (= *MPartLim L)
         (unless (match '(~(chop "Content-Disposition: form-data; name=") . @X) (line))
            (throw "http") )
         (while (line))
         (cond
            ((not (member ";" @X))
               (match '("\"" @X "\"") @X)
               (_htSet @X
                  (pack
                     (make
                        (until
                           (or
                              (= *MPartLim (setq L (line)))
                              (= *MPartEnd L) )
                           (when (eof)
                              (throw "http") )
                           (when (made)
                              (link "^J") )
                           (link (trim L)) ) ) ) ) )
            ((match '(@N ~(chop "; filename=") . @V) @X)
               (match '("\"" @N "\"") @N)
               (match '("\"" @V "\"") @V)
               (if (and @N @V)
                  (let F (tmp (randStr> '+Cmd 10))
                     (ifn (out F (echo (pack "^M^J" *MPartLim)))
                        (call 'rm "-f" F)
                        (push '*Files (list (pack @N) F (pack @V) (pack (last (split @V ".")))))) )
                  (out "/dev/null" (echo (pack "^M^J" *MPartLim))) )
               (setq L (if (= "-" (car (line))) *MPartEnd *MPartLim)) ) ) ) ) )

(undef 'http)

(de http (S)
   (setq *Post NIL *Get NIL *Files NIL)
   (use (L @U @H @X)
      (off *Port% *ContLen *Cookies "*Cookies" "*HtSet")
      (catch "http"
         (in S
            (cond
               ((not (setq L (line)))
                (task (close S))
                (off S)
                (throw "http") )
               ((match '("G" "E" "T" " " "/" @U " " "H" "T" "T" "P" "/" "1" "." @H) L)
                (_htHead)
                (setq L (split @U "?"))
                (for KeyVal (split (cadr L) "&") 
                   (let Res (split KeyVal "=") 
                      (push '*Get (list (ht:Pack (car Res)) (ht:Pack (cadr Res)))) ) ) )
               ((match '("P" "O" "S" "T" " " "/" @U " " "H" "T" "T" "P" "/" "1" "." @H) L)
                (off *MPartLim *MPartEnd)
                (_htHead)
                (cond
                   (*MPartLim (_htMultipart))
                   ((if *ContLen (ht:Read @) (line))
                    (for L (split @ '&)
                       (when (cdr (setq L (split L "=")))
                          (push '*Post (list (ht:Pack (car L)) (ht:Pack (cadr L)))) ) ) )
                   (T (throw "http")) ) )
               (T
                  (out S
                     (if
                        (and
                           (match '(@U " " @ " " "H" "T" "T" "P" . @) L)
                           (member @U
                              (quote
                                 ("O" "P" "T" "I" "O" "N" "S")
                                 ("H" "E" "A" "D")
                                 ("P" "U" "T")
                                 ("D" "E" "L" "E" "T" "E")
                                 ("T" "R" "A" "C" "E")
                                 ("C" "O" "N" "N" "E" "C" "T") ) ) )
                        (httpStat 501 "Method Not Implemented" "Allow: GET, POST")
                        (httpStat 400 "Bad Request") ) )
                  (task (close S))
                  (off S)
                  (throw "http") ) )
            (unless (setq *Url (ht:Pack @U))
               (setq *Url (car *Home) @U (cdr *Home)) )
            (out S
               (cond
                  (T (app)) ) ) ) )
      (and S (=0 *Http1) (task (close S))) ) )

(undef 'redirect)

(de redirect @
   (httpStat 303 "See Other" (pass pack "Location: "))
   (bye))

(redef ht:Pack (Lst)
   (ht:Pack (replace Lst "+" " ")) )

(de gReq (Key)
   (cadr (or (assoc Key *Post) (assoc Key *Get))))
  
(de gaReq (Key)
   (any (req Key)))

(de gFile (Key Cmd)
   (let Info (cdr (assoc Key *Files))
      (cond
         ((= Cmd "tmp") (car Info))
         ((= Cmd "orig") (cadr Info))
         ((= Cmd "ext") (last Info))
         (T NIL)) ) )

(de saveFile (Key)
   (out
      (pack *HomeDir "uploads/" (randHash> '+Cmd) "." (gFile Key "ext"))
      (in (gFile Key "tmp") (echo)) ) )

(de gSess (Key)
   (get> *Sess Key))
    
(de sSess (Key Value)
   (set> *Sess Key Value))

(de clSess (Sp)
   (when (> (cdr *SClI) (% (randNum> '+Cmd) 100))
      (let Stamp (stamp> '+Cmd)
         (for F (dir Sp)
          (let F (pack Sp F)
             (when (< (car *SClI) (- Stamp (fStamp> '+Cmd F)))
                (call 'rm F) ) ) ) ) ) )

(de stSess (Wipe)
   (setq *SP (pack *HomeDir "sessions/"))
   (when Wipe (clSess *SP))
   (setq *Sid (or (cdr (assoc 'sid *Cookies)) (randHash> '+Cmd)))
   (let Sf (pack *SP *Sid)
      (unless (info Sf)
         (out Sf (print (list (list "sid" *Sid)))))
      (setq *Sess (new '(+Hash) Sf)) )
   (cookie 'sid *Sid) )

(de endSess ()
   (save> *Sess (pack *SP *Sid)))

(de splitPath ()
   (setq *Urll (mapcar pack (split (chop *Url) "/"))))

(de loadFile ()
   (when (assoc (stem (chop *Url) ".") *Mimes)
      (apply httpEcho (cdr @) (pack *HomeDir *Url))
   (bye) ) )

(de app ()
   (println "Works, now you can create your application.") )
