/* capctl 0.1
   2001-11-26 (fdeg@mindgate.com.ph)
   see README for details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <linux/capability.h>

typedef __u32 kernel_cap_t;
const char * Kernel_cap_f = "/proc/sys/kernel/cap-bound";
struct kernel_cap_s { char opt; kernel_cap_t kcap; char * desc; };
struct kernel_cap_s Ka[] =
{
	{ 0, 0, NULL },
	{ 'i', CAP_LINUX_IMMUTABLE, "Immutable" },
	{ 't', CAP_SYS_TIME, "Time" },
	{ 'n', CAP_NET_ADMIN, "Networking" },
	{ 'r', CAP_SYS_RAWIO, "RawIO" },
	{ 'm', CAP_SYS_MODULE, "Modules" },
	{ 0, 0, NULL }
};
const char * Op = "imnrt";

int get_options
(	kernel_cap_t *	kset,
	kernel_cap_t 	kcap,
	int 		argc, 
	char *		argv[] 
)
{
	int opt;
	int i, k;

	*kset = 0;
	while ((opt = getopt( argc, argv, Op )) != -1)
	{	switch (opt)
		{	default:
			i = 0;
			do 
			{	i++;
				if (Ka[i].opt == opt)
				{	k = 1 << Ka[i].kcap; 
					if (k & kcap) { *kset |= k; }
					i = 0;
				}	
			} while (Ka[i].opt);
			if (i) return(0); /* invalid option */
			break;
		}
	}
	return(1);
}

int read_caps ( kernel_cap_t * kcap )
{	FILE *f;
	int res=0;
	
	if ((f = fopen( Kernel_cap_f, "r" )) != NULL)
	{	if (fscanf( f, "%d", kcap ) > 0) { res=1; }
		fclose(f);
	}
	return(res);
}

int write_caps ( kernel_cap_t kcap )
{	FILE *f;
	int res=0;
	
	if ((f = fopen( Kernel_cap_f, "w" )) != NULL)
	{	if (fprintf( f, "%d\n", kcap ) > 0) { res=1; }
		fclose(f);
	}
	return(res);
}

void print_caps ( kernel_cap_t kcap )
{	int c, i;

	for ( i=1; Ka[i].opt; i++ )
	{	c = ' ';
		if (kcap & (1 << Ka[i].kcap)) { c='+'; }
		printf("(%c) %s\n", c, Ka[i].desc );
	}
}

int main (int argc, char *argv[])
{	kernel_cap_t kcap, kset, kfinal;
	int res = 1;
	kfinal = 0;	
	if (read_caps( &kcap ))
	{	printf("Pre: 0x%X\n",kcap);	
		if (get_options( &kset, kcap, argc, argv ))
		{	kfinal = kcap ^ kset;
			if (kset) { write_caps( kfinal ); }
			if (read_caps( &kfinal ))
			{	print_caps( kfinal );
				printf( "Set: 0x%X\n", kfinal );
				res = 0; /* success */
			}
		}
	}
	exit(res);
}
