#!/usr/local/bin/perl -w

use strict;
use Socket qw( inet_ntoa );

use POE qw ( 	Wheel::SocketFactory
		Wheel::ReadWrite
		Filter::Line
		Driver::SysRW 
		Component::SubWrapper );

use constant PORT => 31008;
use TestPoe;

poeize TestPoe;

POE::Session->create (
	inline_states => {
		_start => \&server_start,
		_stop => \&server_stop,
		callback => \&child_callback,
	}
);

$poe_kernel->run();
exit;

sub server_start {
	$_[HEAP]->{listener} = new POE::Wheel::SocketFactory (
		BindPort	=> PORT,
		Reuse		=> 'yes',
		SuccessState	=> \&accept_new_client,
		FailureState	=> \&accept_failed
	);
}

sub server_stop {
	print "SERVER: Stopped.\n";
}

sub accept_new_client {
	my ($socket, $peeraddr, $peerport) = @_[ARG0 .. ARG2];
	$peeraddr = inet_ntoa($peeraddr);

	new POE::Session (
		_start	=> \&child_start,
		_stop 	=> \&child_stop,
		main 	=> ['child_input', 'child_done', 'child_error'],
		[ $socket, $peeraddr, $peerport ]
	);

	print "SERVER: Got connection from $peeraddr:$peerport.\n";
}

sub accept_failed {
	my ($function, $error) = @_[ARG0, ARG2];
	delete $_[HEAP]->{listener};
	print "SERVER: call to $function() failed: $error \n";
}

sub child_start {
	my ($heap, $socket) = @_[HEAP, ARG0];
	$heap->{readwrite} = new POE::Wheel::ReadWrite (
		Handle		=> $socket,
		Driver		=> new POE::Driver::SysRW(),
		Filter		=> new POE::Filter::Line(),
		InputState	=> 'child_input',
		ErrorState	=> 'child_error',
		Callback	=> 'child_callback',
	);
	$heap->{readwrite}->put( "Hello, client!" );
	$heap->{peername} = join ':', @_[ARG1, ARG2];
	print "CHILD: Connected to $heap->{peername}. \n";
}

sub child_input {
	my $data = $_[ARG0];
	return unless length $data;
	$poe_kernel->post('TestPoe', 'testpoe', ["$data"], 'callback', 'SCALAR');
	print "CHILD: Got input from peer: \"$data \n \n";
	$_[HEAP]->{readwrite}->put( "Received data from you: $data" );
}

sub child_done {
	delete $_[HEAP]->{readwrite};
	print "CHILD: disconnected from ", $_[HEAP]->{peername}, ".\n";
}

sub child_error {
	my ($function, $error) = @_[ARG0, ARG2];
	delete $_[HEAP]->{readwrite};
	print "CHILD: call to $function() failed $error. \n" if $error;
}

sub child_callback {
	print "FUCKER!\n"
}

