(* Type checking rejects structure B with some compilers. *)

signature A =
  sig
    type ('a, 'b) t
    val mkT  : int -> ('a, int) t
  end

structure A :> A =
  struct
    type ('a, 'b) t = 'b
    fun mkT n = n
  end


signature B =
  sig
    type 'a t                   (* test-2 has type t here *)
    val x : ('a t, int) A.t
  end

structure B :> B =
  struct
    type 'a t = unit
    val x = A.mkT 2
  end
