(* Type checking rejects structure B with some compilers. *)

signature A =
  sig
    type ('a, 'b) t
    val mkT  : int -> ('a, int) t
  end

structure A :> A =
  struct
    type ('a, 'b) t = 'b
    fun mkT n = n
  end


signature B =
  sig
    type t                      (* test-1 has type 'a t here *)
    val x : (t, int) A.t
  end

structure B :> B =
  struct
    type t = unit
    val x = A.mkT 2
  end
