open CInterface
val get = get_sym "testlib.so.1"


(* `hypot` is the ML function that we will call from C.
 * This must *not* raise an exception!
 *)

fun hypot (x, y) = Math.sqrt (x * x + y * y)


(* `init` initializes the C global variable `sml_hypot` with (a pointer to)
 * the SML function `hypot`. *)

fun init () =
  setGlobal (get "sml_hypot") (FUNCTION2 (DOUBLE, DOUBLE) DOUBLE) hypot


(* The SML main program `main` simply calls the C function `c_main`. *)

fun error msg =
  let
      open TextIO OS.Process
      fun printErr s = output (stdErr, s)
  in
      app printErr msg;
      flushOut stdErr;
      exit failure
  end


fun main () =
  let
    val () = init ()
  in
    call0 (get "c_main") () VOID ()
  end
    handle e => error ["Uncaught exception\n", exnMessage e, "\n"];


val () = PolyML.export ("call_c_test_10", main);
