#include <stdio.h>
#include <Xm/Xm.h> 
#include <Xm/RowColumn.h>         
#include <Xm/Label.h>  
#include <Xm/TextF.h>  
#include <Xm/PushB.h>   
#include <stdlib.h>    
#include <ctype.h>    

double (*sml_hypot) (double x, double y);

static void EnterCallback ( Widget w, XtPointer clientData, XtPointer callData);

Widget sideA, sideB, sideC;

void c_main (void)
{
    Widget shell, rowcol, button; 
    XtAppContext app;        
   
    int argc = 1;    char* argv[] = {"PolyML GUI" };
    shell = XtAppInitialize ( &app, "Memo", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    rowcol = XtCreateManagedWidget ("rowcol", xmRowColumnWidgetClass, shell, NULL, 0);

    XmString     xmstr;
    xmstr = XmStringCreateLtoR ( "Right Triangle", XmFONTLIST_DEFAULT_TAG );
    XtVaCreateManagedWidget ( "message", xmLabelWidgetClass, rowcol, 
                              XmNlabelString, xmstr, NULL );
    XmStringFree ( xmstr );
   
    sideA = XmCreateTextField ( rowcol, "input", NULL, 0 );
    XtManageChild ( sideA );
    sideB = XmCreateTextField ( rowcol, "input", NULL, 0 );
    XtManageChild ( sideB );
 
    button = XtCreateManagedWidget("Calculate Hypontenuse", xmPushButtonWidgetClass, rowcol, NULL, 0 );
    XtAddCallback ( button, XmNactivateCallback, EnterCallback, NULL); 

    sideC = XmCreateTextField ( rowcol, "input", NULL, 0 );
    XtManageChild ( sideC );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );

  return;
}
static void EnterCallback ( Widget w, XtPointer clientData, XtPointer callData )
{
    double a, b;
    printf ( "text entered = %s\n", XmTextFieldGetString ( sideA ) );
    printf ( "text entered = %s\n", XmTextFieldGetString ( sideB ) );
    a = atof(XmTextFieldGetString ( sideA ));
    b = atof(XmTextFieldGetString ( sideB ));
    double c;
    c = sml_hypot (a, b);  /* call back to SML! */
    printf("c = %.6f\n", c);
    char msg[256];
    sprintf(msg,"%.1f", c); 
    XmTextFieldSetString(sideC,msg);  
}



