#include <cstdio>

#include <QtCore/QFile>
#include <QtCore/QTextStream>

#include <poppler-qt4.h>

using namespace Poppler;

int main(int argc, char **argv)
{
	int ec;
	
	QTextStream err(stderr);
	if (argc != 3)
	{
		err << "Usage: " << argv[0] << " inputfile.pdf outputfile.pdf" << endl;
		return 0;
	}

	QString filename(argv[1]);
	QTextStream out(stdout);

	Document* document = Document::load(filename);
	if (!document || document->isLocked())
	{
		err << "Error! Cannot open " << argv[1] << endl;
		delete document;
		return 0;
	}

	if (document->numPages() == 0)
	{
		err << "Warning! Empty document " << argv[1] << endl;
		delete document;
		return 0;
	}

	Page* pdfPage = document->page(0);
	StampAnnotation *la = new StampAnnotation();
	pdfPage->addAnnotation(la);
	pdfPage->removeAnnotation(la);

	PDFConverter *conv = document->pdfConverter();
	conv->setOutputFileName(argv[2]);
	conv->setPDFOptions(conv->pdfOptions() | Poppler::PDFConverter::WithChanges);
	if (!conv->convert())
	{
		err << "Error! Cannot write " << argv[2] << endl;
		ec = 1;
	}
	else
		ec = 0;

	delete conv;
	delete pdfPage;
	delete document;

	return ec;
}
