--Alter tiger columns for lower case column names
alter table lka rename column "TLID" to tlid;
alter table lka rename column "FNODE" to fnode;
alter table lka rename column "TNODE" to tnode;
alter table lka rename column "FOVRUNDR" to fovrundr;
alter table lka rename column "TOVRUNDR" to tovrundr;
alter table lka rename column "LENGTH" to length;
alter table lka rename column "FEDIRP" to fedirp;
alter table lka rename column "FENAME" to fename;
alter table lka rename column "FETYPE" to fetype;
alter table lka rename column "FEDIRS" to fedirs;
alter table lka rename column "CFCC" to cfcc;
alter table lka rename column "FRADDL" to fraddl;
alter table lka rename column "TOADDL" to toaddl;
alter table lka rename column "FRADDR" to fraddr;
alter table lka rename column "TOADDR" to toaddr;
alter table lka rename column "ZIPL" to zipl;
alter table lka rename column "ZIPR" to zipr;
alter table lka rename column "CFCC1" to cfcc1;
alter table lka rename column "CFCC2" to cfcc2;
alter table lka rename column "SOURCE" to source;
alter table lka rename column "FRIADDL" to friaddl;
alter table lka rename column "TOIADDL" to toiaddl;
alter table lka rename column "FRIADDR" to friaddr;
alter table lka rename column "TOIADDR" to toiaddr;
alter table lka rename column "AIANHHFPL" to aianhhfpl;
alter table lka rename column "AIANHHFPR" to aianhhfpr;
alter table lka rename column "AIHHTLIL" to aihhtlil;
alter table lka rename column "AIHHTLIR" to aihhtlir;
alter table lka rename column "CENSUS1" to census1;
alter table lka rename column "CENSUS2" to census2;
alter table lka rename column "STATEL" to statel;
alter table lka rename column "STATER" to stater;
alter table lka rename column "COUNTYL" to countyl;
alter table lka rename column "COUNTYR" to countyr;
alter table lka rename column "COUSUBL" to cousubl;
alter table lka rename column "COUSUBR" to cousubr;
alter table lka rename column "SUBMCDL" to submcdl;
alter table lka rename column "SUBMCDR" to submcdr;
alter table lka rename column "PLACEL" to placel;
alter table lka rename column "PLACER" to placer;
alter table lka rename column "TRACTL" to tractl;
alter table lka rename column "TRACTR" to tractr;
alter table lka rename column "BLOCKL" to blockl;
alter table lka rename column "BLOCKR" to blockr;


alter table urbcu rename column "GIST_ID" to gist_id;
alter table urbcu rename column "COUNTY" to county;
alter table urbcu rename column "UACODE" to uacode;
alter table urbcu rename column "NAME" to name;
alter table urbcu rename column "LSADC" to lsadc;
alter table urbcu rename column "ENTITY" to entity;
alter table urbcu rename column "FIPSCC" to fipscc;
alter table urbcu rename column "PLACEDC" to placedc;


alter table zcta5cu rename column "GIST_ID" to gist_id;
alter table zcta5cu rename column "COUNTY" to county;
alter table zcta5cu rename column "ZCTA" to zcta;


ALTER TABLE cousubcu RENAME "COUNTY"  TO county;
ALTER TABLE cousubcu RENAME "COUSUB"  TO cousub;
ALTER TABLE cousubcu RENAME "NAME"  TO name;
ALTER TABLE cousubcu RENAME "LSADC"  TO lsadc;
ALTER TABLE cousubcu RENAME "ENTITY"  TO entity;
ALTER TABLE cousubcu RENAME "COUSUBCC"  TO cousubcc;
ALTER TABLE cousubcu RENAME "PLACEDC"  TO placedc;

ALTER TABLE ctycu RENAME "GIST_ID" TO gist_id;
ALTER TABLE ctycu RENAME "FIPSSTCO" TO fipsstco;
ALTER TABLE ctycu RENAME "STATE" TO state;
ALTER TABLE ctycu RENAME "COUNTY" TO county;
ALTER TABLE ctycu RENAME "LSADC" TO lsadc;
ALTER TABLE ctycu RENAME "FIPSCC" TO fipscc;
ALTER TABLE ctycu RENAME "ENTITY" TO entity;

ALTER TABLE placecu RENAME "GIST_ID" TO gist_id;
ALTER TABLE placecu RENAME "COUNTY" TO county;
ALTER TABLE placecu RENAME "PLACE" TO place;
ALTER TABLE placecu RENAME "NAME" TO name;
ALTER TABLE placecu RENAME "LSADC" TO lsadc;
ALTER TABLE placecu RENAME "ENTITY" TO entity;
ALTER TABLE placecu RENAME "FIPSCC" TO fipscc;
ALTER TABLE placecu RENAME "PLACEDC" TO placedc;


ALTER TABLE placecu ADD COLUMN placei integer;

update placecu set placei=cast(place as integer);

select name, placei as place, cast(substr(county, 1, 2) as integer) as state, cast(substr(county, 3, 3) as integer) as county into uplace_lookup from placecu where placei in (select placei from placecu group by placei);

create index uplace_lookup_place_idx on uplace_lookup (place, state);
create index placecu_state_idx on placecu (cast(substr(county, 1, 2) as integer));
vacuum analyze uplace_lookup;
vacuum analyze placecu;

-- Create direction lookup table
BEGIN;
CREATE TABLE direction_lookup (name VARCHAR(20), abbrev VARCHAR(3));
--DELETE FROM direction_lookup;
INSERT INTO direction_lookup (name, abbrev) VALUES('West', 'W');
INSERT INTO direction_lookup (name, abbrev) VALUES('South-West', 'SW');
INSERT INTO direction_lookup (name, abbrev) VALUES('SouthWest', 'SW');
INSERT INTO direction_lookup (name, abbrev) VALUES('South-East', 'SE');
INSERT INTO direction_lookup (name, abbrev) VALUES('SouthEast', 'SE');
INSERT INTO direction_lookup (name, abbrev) VALUES('South_West', 'SW');
INSERT INTO direction_lookup (name, abbrev) VALUES('South_East', 'SE');
INSERT INTO direction_lookup (name, abbrev) VALUES('South', 'S');
INSERT INTO direction_lookup (name, abbrev) VALUES('South West', 'SW');
INSERT INTO direction_lookup (name, abbrev) VALUES('South East', 'SE');
INSERT INTO direction_lookup (name, abbrev) VALUES('North-West', 'NW');
INSERT INTO direction_lookup (name, abbrev) VALUES('NorthWest', 'NW');
INSERT INTO direction_lookup (name, abbrev) VALUES('North-East', 'NE');
INSERT INTO direction_lookup (name, abbrev) VALUES('NorthEast', 'NE');
INSERT INTO direction_lookup (name, abbrev) VALUES('North_West', 'NW');
INSERT INTO direction_lookup (name, abbrev) VALUES('North_East', 'NE');
INSERT INTO direction_lookup (name, abbrev) VALUES('North', 'N');
INSERT INTO direction_lookup (name, abbrev) VALUES('North West', 'NW');
INSERT INTO direction_lookup (name, abbrev) VALUES('North East', 'NE');
INSERT INTO direction_lookup (name, abbrev) VALUES('East', 'E');
COMMIT;



-- Create secondary unit lookup table
BEGIN;
CREATE TABLE secondary_unit_lookup (name VARCHAR(20), abbrev VARCHAR(5));
--DELETE FROM secondary_unit_lookup;
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Apartment', 'APT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Apt', 'APT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Basement', 'BSMT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Bsmt', 'BSMT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Building', 'BLDG');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Bldg', 'BLDG');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Department', 'DEPT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Dept', 'DEPT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Floor', 'FL');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Fl', 'FL');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Front', 'FRNT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Frnt', 'FRNT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Hangar', 'HNGR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Hngr', 'HNGR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Lobby', 'LBBY');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Lbby', 'LBBY');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Lot', 'LOT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Lower', 'LOWR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Lowr', 'LOWR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Office', 'OFC');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Ofc', 'OFC');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Penthouse', 'PH');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('PH', 'PH');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Pier', 'PIER');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Rear', 'REAR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Room', 'RM');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Rm', 'RM');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Side', 'SIDE');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Slip', 'SLIP');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Space', 'SPC');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Spc', 'SPC');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Stop', 'STOP');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Suite', 'STE');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Ste', 'STE');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Trailer', 'TRLR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Trlr', 'TRLR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Unit', 'UNIT');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Upper', 'UPPR');
INSERT INTO secondary_unit_lookup (name, abbrev) VALUES ('Uppr', 'UPPR');
COMMIT;



-- Create state lookup table
BEGIN;
CREATE TABLE state_lookup (key varchar(2), name VARCHAR(40), abbrev VARCHAR(3), fips INTEGER);
--DELETE FROM state_lookup
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('01', 'Alabama', 'AL', 1);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('02','Alaska', 'AK', 2);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('03','American Samoa', 'AS', 3);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('04','Arizona', 'AZ', 4);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('05','Arkansas', 'AR', 5);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('06','California', 'CA', 6);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('08','Colorado', 'CO', 8);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('09','Connecticut', 'CT', 9);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('10','Delaware', 'DE', 10);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('11','District of Columbia', 'DC', 11);
INSERT INTO state_lookup (key, name, abbrev) VALUES ('','Federated States of Micronesia', 'FM');
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('12','Florida', 'FL', 12);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('13','Georgia', 'GA', 13);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('14','Guam', 'GU', 14);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('15','Hawaii', 'HI', 15);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('16','Idaho', 'ID', 16);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('17','Illinois', 'IL', 17);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('18','Indiana', 'IN', 18);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('19','Iowa', 'IA', 19);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('20','Kansas', 'KS', 20);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('21','Kentucky', 'KY', 21);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('22','Louisiana', 'LA', 22);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('23','Maine', 'ME', 23);
INSERT INTO state_lookup (key, name, abbrev) VALUES ('','Marshall Islands', 'MH');
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('24','Maryland', 'MD', 24);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('25','Massachusetts', 'MA', 25);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('26','Michigan', 'MI', 26);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('27','Minnesota', 'MN', 27);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('28','Mississippi', 'MS', 28);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('29','Missouri', 'MO', 29);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('30','Montana', 'MT', 30);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('31','Nebraska', 'NE', 31);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('32','Nevada', 'NV', 32);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('33','New Hampshire', 'NH', 33);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('34','New Jersey', 'NJ', 34);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('35','New Mexico', 'NM', 35);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('36','New York', 'NY', 36);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('37','North Carolina', 'NC', 37);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('38','North Dakota', 'ND', 38);
INSERT INTO state_lookup (key, name, abbrev) VALUES ('','Northern Mariana Islands', 'MP');
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('39','Ohio', 'OH', 39);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('40','Oklahoma', 'OK', 40);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('41','Oregon', 'OR', 41);
INSERT INTO state_lookup (key, name, abbrev) VALUES ('','Palau', 'PW');
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('42','Pennsylvania', 'PA', 42);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('72','Puerto Rico', 'PR', 72);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('44','Rhode Island', 'RI', 44);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('45','South Carolina', 'SC', 45);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('46','South Dakota', 'SD', 46);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('47','Tennessee', 'TN', 47);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('48','Texas', 'TX', 48);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('49','Utah', 'UT', 49);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('50','Vermont', 'VT', 50);
INSERT INTO state_lookup (key, name, abbrev) VALUES ('','Virgin Islands', 'VI');
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('51','Virginia', 'VA', 51);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('53','Washington', 'WA', 53);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('54','West Virginia', 'WV', 54);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('55','Wisconsin', 'WI', 55);
INSERT INTO state_lookup (key, name, abbrev, fips) VALUES ('56','Wyoming', 'WY', 56);
COMMIT;


-- Create street type lookup table
BEGIN;
CREATE TABLE street_type_lookup (name VARCHAR(20), abbrev VARCHAR(4));
--DELETE FROM street_type_lookup;
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Allee', 'Aly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Alley', 'Aly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ally', 'Aly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Aly', 'Aly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Anex', 'Anx');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Annex', 'Anx');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Annx', 'Anx');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Anx', 'Anx');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Arc', 'Arc');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Arcade', 'Arc');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Av', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ave', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Aven', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Avenu', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Avenue', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Avn', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Avnue', 'Ave');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bayoo', 'Byu');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bayou', 'Byu');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bch', 'Bch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Beach', 'Bch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bend', 'Bnd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bnd', 'Bnd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Blf', 'Blf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bluf', 'Blf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bluff', 'Blf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bluffs', 'Blfs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bot', 'Btm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bottm', 'Btm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bottom', 'Btm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Btm', 'Btm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Blvd', 'Blvd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Boul', 'Blvd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Boulevard', 'Blvd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Boulv', 'Blvd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Br', 'Br');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Branch', 'Br');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brnch', 'Br');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brdge', 'Brg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brg', 'Brg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bridge', 'Brg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brk', 'Brk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brook', 'Brk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brooks', 'Brks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Burg', 'Bg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Burgs', 'Bgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Byp', 'Byp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bypa', 'Byp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bypas', 'Byp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bypass', 'ByP');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Byps', 'Byp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Camp', 'Cp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cmp', 'Cp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cp', 'Cp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Canyn', 'Cyn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Canyon', 'Cyn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cnyn', 'Cyn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cyn', 'Cyn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cape', 'Cpe');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cpe', 'Cpe');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Causeway', 'Cswy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Causway', 'Cswy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cswy', 'Cswy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cen', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cent', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Center', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Centr', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Centre', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cnter', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cntr', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ctr', 'Ctr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Centers', 'Ctrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cir', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Circ', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Circl', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Circle', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crcl', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crcle', 'Cir');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Circles', 'Cirs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Clf', 'Clf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cliff', 'Clf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Clfs', 'Clfs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cliffs', 'Clfs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Clb', 'Clb');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Club', 'Clb');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Common', 'Cmn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cor', 'Cor');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Corner', 'Cor');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Corners', 'Cors');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cors', 'Cors');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Course', 'Crse');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crse', 'Crse');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Court', 'Ct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crt', 'Ct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ct', 'Ct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Courts', 'Cts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cove', 'Cv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cv', 'Cv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Coves', 'Cvs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ck', 'Crk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cr', 'Crk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Creek', 'Crk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crk', 'Crk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crecent', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cres', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crescent', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cresent', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crscnt', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crsent', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crsnt', 'Cres');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crest', 'Crst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crossing', 'Xing');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crssing', 'Xing');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crssng', 'Xing');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Xing', 'Xing');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crossroad', 'Xrd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Curve', 'Curv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dale', 'Dl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dl', 'Dl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dam', 'Dm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dm', 'Dm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Div', 'Dv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Divide', 'Dv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dv', 'Dv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dvd', 'Dv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Dr', 'Dr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Driv', 'Dr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Drive', 'Dr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Drv', 'Dr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Drives', 'Drs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Est', 'Est');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Estate', 'Est');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Estates', 'Ests');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ests', 'Ests');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Exp', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Expr', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Express', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Expressway', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Expw', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Expy', 'Expy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ext', 'Ext');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Extension', 'Ext');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Extn', 'Ext');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Extnsn', 'Ext');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Extensions', 'Exts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Exts', 'Exts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fall', 'Fall');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Falls', 'Fls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fls', 'Fls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ferry', 'Fry');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frry', 'Fry');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fry', 'Fry');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Field', 'Fld');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fld', 'Fld');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fields', 'Flds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Flds', 'Flds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Flat', 'Flt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Flt', 'Flt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Flats', 'Flts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Flts', 'Flts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ford', 'Frd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frd', 'Frd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fords', 'Frds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forest', 'Frst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forests', 'Frst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frst', 'Frst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forg', 'Frg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forge', 'Frg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frg', 'Frg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forges', 'Frgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fork', 'Frk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frk', 'Frk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Forks', 'Frks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frks', 'Frks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fort', 'Ft');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frt', 'Ft');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ft', 'Ft');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Freeway', 'Fwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Freewy', 'Fwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frway', 'Fwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frwy', 'Fwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Fwy', 'Fwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Garden', 'Gdn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gardn', 'Gdn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gdn', 'Gdn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grden', 'Gdn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grdn', 'Gdn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gardens', 'Gdns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gdns', 'Gdns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grdns', 'Gdns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gateway', 'Gtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gatewy', 'Gtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gatway', 'Gtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gtway', 'Gtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gtwy', 'Gtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Glen', 'Gln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Gln', 'Gln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Glens', 'Glns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Green', 'Grn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grn', 'Grn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Greens', 'Grns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grov', 'Grv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grove', 'Grv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grv', 'Grv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Groves', 'Grvs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Harb', 'Hbr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Harbor', 'Hbr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Harbr', 'Hbr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hbr', 'Hbr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hrbor', 'Hbr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Harbors', 'Hbrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Haven', 'Hvn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Havn', 'Hvn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hvn', 'Hvn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Height', 'Hts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Heights', 'Hts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hgts', 'Hts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ht', 'Hts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hts', 'Hts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Highway', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Highwy', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hiway', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hiwy', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hway', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hwy', 'Hwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hill', 'Hl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hl', 'Hl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hills', 'Hls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hls', 'Hls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hllw', 'Holw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hollow', 'Holw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hollows', 'Holw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Holw', 'Holw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Holws', 'Holw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Inlet', 'Inlt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Inlt', 'Inlt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Is', 'Is');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Island', 'Is');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Islnd', 'Is');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Islands', 'Iss');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Islnds', 'Iss');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Iss', 'Iss');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Isle', 'Isle');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Isles', 'Isle');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Jct', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Jction', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Jctn', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Junction', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Junctn', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Juncton', 'Jct');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Jctns', 'Jcts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Jcts', 'Jcts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Junctions', 'Jcts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Key', 'Ky');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ky', 'Ky');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Keys', 'Kys');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Kys', 'Kys');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Knl', 'Knl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Knol', 'Knl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Knoll', 'Knl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Knls', 'Knls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Knolls', 'Knls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lake', 'Lk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lk', 'Lk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lakes', 'Lks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lks', 'Lks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Land', 'Land');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Landing', 'Lndg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lndg', 'Lndg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lndng', 'Lndg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('La', 'Ln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lane', 'Ln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lanes', 'Ln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ln', 'Ln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lgt', 'Lgt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Light', 'Lgt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lights', 'Lgts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lf', 'Lf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Loaf', 'Lf');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lck', 'Lck');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lock', 'Lck');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lcks', 'Lcks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Locks', 'Lcks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ldg', 'Ldg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ldge', 'Ldg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lodg', 'Ldg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lodge', 'Ldg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Loop', 'Loop');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Loops', 'Loop');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mall', 'Mall');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Manor', 'Mnr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mnr', 'Mnr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Manors', 'Mnrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mnrs', 'Mnrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mdw', 'Mdw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Meadow', 'Mdw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mdws', 'Mdws');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Meadows', 'Mdws');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Medows', 'Mdws');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mews', 'Mews');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mill', 'Ml');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ml', 'Ml');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mills', 'Mls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mls', 'Mls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mission', 'Msn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Missn', 'Msn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Msn', 'Msn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mssn', 'Msn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Motorway', 'Mtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mnt', 'Mt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mount', 'Mt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mt', 'Mt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mntain', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mntn', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mountain', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mountin', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mtin', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mtn', 'Mtn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mntns', 'Mtns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mountains', 'Mtns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Nck', 'Nck');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Neck', 'Nck');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Orch', 'Orch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Orchard', 'Orch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Orchrd', 'Orch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Oval', 'Oval');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ovl', 'Oval');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Overpass', 'Opas');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Park', 'Park');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pk', 'Park');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prk', 'Park');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Parks', 'Park');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Parkway', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Parkwy', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pkway', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pkwy', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pky', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Parkways', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pkwys', 'Pkwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pass', 'Pass');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Passage', 'Psge');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Path', 'Path');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Paths', 'Path');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pike', 'Pike');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pikes', 'Pike');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pine', 'Pne');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pines', 'Pnes');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pnes', 'Pnes');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pl', 'Pl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Place', 'Pl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plain', 'Pln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pln', 'Pln');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plaines', 'Plns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plains', 'Plns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plns', 'Plns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plaza', 'Plz');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plz', 'Plz');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Plza', 'Plz');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Point', 'Pt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pt', 'Pt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Points', 'Pts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pts', 'Pts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Port', 'Prt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prt', 'Prt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ports', 'Prts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prts', 'Prts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pr', 'Pr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prairie', 'Pr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prarie', 'Pr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Prr', 'Pr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rad', 'Radl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Radial', 'Radl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Radiel', 'Radl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Radl', 'Radl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ramp', 'Ramp');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ranch', 'Rnch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ranches', 'Rnch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rnch', 'Rnch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rnchs', 'Rnch');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rapid', 'Rpd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rpd', 'Rpd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rapids', 'Rpds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rpds', 'Rpds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rest', 'Rst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rst', 'Rst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rdg', 'Rdg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rdge', 'Rdg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ridge', 'Rdg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rdgs', 'Rdgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ridges', 'Rdgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('River', 'Riv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rivr', 'Riv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rvr', 'Riv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rd', 'Rd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Road', 'Rd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rds', 'Rds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Roads', 'Rds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Route', 'Rte');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Row', 'Row');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rue', 'Rue');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Run', 'Run');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shl', 'Shl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shoal', 'Shl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shls', 'Shls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shoals', 'Shls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('SHOAR', 'Shr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shore', 'Shr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shr', 'Shr');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shoars', 'Shrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shores', 'Shrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Shrs', 'Shrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Skyway', 'Skwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spg', 'Spg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spng', 'Spg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spring', 'Spg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sprng', 'Spg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spgs', 'Spgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spngs', 'Spgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Springs', 'Spgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sprngs', 'Spgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spur', 'Spur');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Spurs', 'Spur');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sq', 'Sq');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sqr', 'Sq');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sqre', 'Sq');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Squ', 'Sq');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('SQUARE', 'Sq');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sqrs', 'Sqs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Squares', 'Sqs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sta', 'Sta');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Station', 'Sta');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Statn', 'Sta');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Stn', 'Sta');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Stra', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strav', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strave', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Straven', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Stravenue', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Stravn', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strvn', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strvnue', 'Stra');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Stream', 'Strm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Streme', 'Strm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strm', 'Strm');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('St', 'St');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Str', 'St');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Street', 'St');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Strt', 'St');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Streets', 'Sts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Smt', 'Smt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sumit', 'Smt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sumitt', 'Smt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Summit', 'Smt');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ter', 'Ter');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Terr', 'Ter');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Terrace', 'Ter');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Throughway', 'Trwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trace', 'Trce');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Traces', 'Trce');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trce', 'Trce');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Track', 'Trak');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tracks', 'Trak');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trak', 'Trak');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trk', 'Trak');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trks', 'Trak');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trafficway', 'Trfy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trfy', 'Trfy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tr', 'Trl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trail', 'Trl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trails', 'Trl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trl', 'Trl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trls', 'Trl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunel', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunl', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunls', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunnel', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunnels', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tunnl', 'Tunl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tpk', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Tpke', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trnpk', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trpk', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Turnpike', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Turnpk', 'Tpke');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Underpass', 'Upas');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Un', 'Un');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Union', 'Un');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Unions', 'Uns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Valley', 'Vly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vally', 'Vly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vlly', 'Vly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vly', 'Vly');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Valleys', 'Vlys');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vlys', 'Vlys');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vdct', 'Via');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Via', 'Via');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Viadct', 'Via');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Viaduct', 'Via');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('View', 'Vw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vw', 'Vw');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Views', 'Vws');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vws', 'Vws');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vill', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Villag', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Village', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Villg', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Villiage', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vlg', 'Vlg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Villages', 'Vlgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vlgs', 'Vlgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ville', 'Vl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vl', 'Vl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vis', 'Vis');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vist', 'Vis');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vista', 'Vis');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vst', 'Vis');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Vsta', 'Vis');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Walk', 'Walk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Walks', 'Walk');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Wall', 'Wall');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Way', 'Way');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Wy', 'Way');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ways', 'Ways');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Well', 'Wl');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Wells', 'Wls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Wls', 'Wls');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Byu', 'Byu');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Blfs', 'Blfs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Brks', 'Brks');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bg', 'Bg');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Bgs', 'Bgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Ctrs', 'Ctrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cirs', 'Cirs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cmn', 'Cmn');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cts', 'Cts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Cvs', 'Cvs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Crst', 'Crst');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Xrd', 'Xrd');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Curv', 'Curv');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Drs', 'Drs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frds', 'Frds');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Frgs', 'Frgs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Glns', 'Glns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grns', 'Grns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Grvs', 'Grvs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Hbrs', 'Hbrs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Lgts', 'Lgts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mtwy', 'Mtwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Mtns', 'Mtns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Opas', 'Opas');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Psge', 'Psge');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Pne', 'Pne');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Rte', 'Rte');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Skwy', 'Skwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sqs', 'Sqs');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Sts', 'Sts');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Trwy', 'Trwy');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Upas', 'Upas');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Uns', 'Uns');
INSERT INTO street_type_lookup (name, abbrev) VALUES ('Wl', 'Wl');
COMMIT;


-- Table: tiger_geocode_roads
-- DROP TABLE tiger_geocode_roads;
CREATE TABLE tiger_geocode_roads
(
  gid serial,
  tlid integer,
  fedirp character varying(2),
  fename character varying(30),
  fetype character varying(4),
  fedirs character varying(2),
  fraddl character varying(11),
  toaddl character varying(11),
  fraddr character varying(11),
  toaddr character varying(11),
  gadd integer,
  ladd integer,
  zip integer,
  state integer,
  cousub integer,
  county integer,
  place integer,
  the_geom geometry,
  CONSTRAINT "tiger_geocode_roads_pkey" PRIMARY KEY (gid),
  CONSTRAINT enforce_dims_the_geom CHECK (ndims(the_geom) = 2),
  CONSTRAINT enforce_geotype_the_geom CHECK (geometrytype(the_geom) = 'MULTILINESTRING'::text OR the_geom IS NULL),
  CONSTRAINT enforce_srid_the_geom CHECK (srid(the_geom) = 4326)
) 
WITHOUT OIDS;
ALTER TABLE tiger_geocode_roads OWNER TO postgres;
GRANT ALL ON TABLE tiger_geocode_roads TO postgres;



insert into tiger_geocode_roads (tlid, fedirp, fename, fetype, fedirs, 
fraddl, toaddl, fraddr, toaddr, gadd, ladd, zip, state, cousub, county, place, the_geom)
(
	select tlid, fedirp, fename, fetype, fedirs, fraddl, toaddl, fraddr, toaddr,
	greatest(CASE WHEN fraddl !~ '[^[:digit:]]' THEN fraddl::int ELSE null END,
	 CASE WHEN fraddr !~ '[^[:digit:]]' THEN fraddr::int ELSE null END,
	 CASE WHEN toaddl !~ '[^[:digit:]]' THEN toaddl::int ELSE null END,
	 CASE WHEN toaddr !~ '[^[:digit:]]' THEN toaddr::int ELSE null END) as gadd,
	least(CASE WHEN fraddl !~ '[^[:digit:]]' THEN fraddl::int ELSE null END,
	 CASE WHEN fraddr !~ '[^[:digit:]]' THEN fraddr::int ELSE null END,
	 CASE WHEN toaddl !~ '[^[:digit:]]' THEN toaddl::int ELSE null END,
	 CASE WHEN toaddr !~ '[^[:digit:]]' THEN toaddr::int ELSE null END) as ladd,
	greatest(CASE WHEN zipl !~ '[^[:digit:]]' THEN zipl::int ELSE null END,
	 CASE WHEN zipr !~ '[^[:digit:]]' THEN zipr::int ELSE null END) as zip,
	greatest(CASE WHEN statel !~ '[^[:digit:]]' THEN statel::int ELSE null END,
	 CASE WHEN stater !~ '[^[:digit:]]' THEN stater::int ELSE null END) as state,
	greatest(CASE WHEN cousubl !~ '[^[:digit:]]' THEN cousubl::int ELSE null END,
	 CASE WHEN cousubr !~ '[^[:digit:]]' THEN cousubr::int ELSE null END) as cousub,
	greatest(CASE WHEN countyl !~ '[^[:digit:]]' THEN countyl::int ELSE null END,
	 CASE WHEN countyr !~ '[^[:digit:]]' THEN countyr::int ELSE null END) as county,
	greatest(CASE WHEN placel !~ '[^[:digit:]]' THEN placel::int ELSE null END,
	 CASE WHEN placer !~ '[^[:digit:]]' THEN placer::int ELSE null END) as place,
	the_geom
	from lka
);


CREATE INDEX tiger_geocode_roads_fename
  ON tiger_geocode_roads
  USING btree
  (fename);

CREATE INDEX tiger_geocode_roads_fetype_idx
  ON tiger_geocode_roads
  USING btree
  (fetype);

CREATE INDEX tiger_geocode_roads_gadd
  ON tiger_geocode_roads
  USING btree
  (gadd);

CREATE INDEX tiger_geocode_roads_ladd
  ON tiger_geocode_roads
  USING btree
  (ladd);

CREATE INDEX tiger_geocode_roads_lower_fename
  ON tiger_geocode_roads
  USING btree
  (lower(fename::text))
  WHERE fename IS NOT NULL;

CREATE INDEX tiger_geocode_roads_lower_fename_addr
  ON tiger_geocode_roads
  USING btree
  (lower(fename::text), gadd, ladd)
  WHERE fename IS NOT NULL AND gadd IS NOT NULL AND ladd IS NOT NULL;

CREATE INDEX tiger_geocode_roads_lower_fetype
  ON tiger_geocode_roads
  USING btree
  (lower(fetype::text));

CREATE INDEX tiger_geocode_roads_place_idx
  ON tiger_geocode_roads
  USING btree
  (place);

CREATE INDEX tiger_geocode_roads_state_county
  ON tiger_geocode_roads
  USING btree
  (state, county);

CREATE INDEX tiger_geocode_roads_state_idx
  ON tiger_geocode_roads
  USING btree
  (state);

CREATE INDEX tiger_geocode_roads_the_geom_gist
  ON tiger_geocode_roads
  USING gist
  (the_geom);

CREATE INDEX tiger_geocode_roads_tlid
  ON tiger_geocode_roads
  USING btree
  (tlid);

CREATE INDEX tiger_geocode_roads_zip_idx
  ON tiger_geocode_roads
  USING btree
  (zip);

VACUUM ANALYZE tiger_geocode_roads;



-- DROP FUNCTION get_address_street_type(rawaddr VARCHAR);
-- DROP FUNCTION get_address_direction(rawaddr VARCHAR, street_type VARCHAR, getpre BOOLEAN);
-- DROP TYPE address_lookup_value;
 CREATE TYPE address_lookup_value AS
    (value text,
     name text,
     abbrev text);
 ALTER TYPE address_lookup_value OWNER TO postgres;


-- DROP FUNCTION get_normalized_address(rawaddr character varying);
-- DROP TYPE address_parts;
 CREATE TYPE address_parts AS
    (house_num integer,
     pre_dir text,
     street text,
     street_type text,
     post_dir text,
     city text,
     state text,
     zipcode text,
     pre_dir_abbrev text,
     street_type_abbrev text,
     post_dir_abbrev text,
     state_abbrev text,
     state_fips integer);
 ALTER TYPE address_parts OWNER TO postgres;



-- DROP FUNCTION geo_live_search(rawaddr character varying, max integer);
-- DROP TYPE geocoded_address;
 CREATE TYPE geocoded_address AS
    (lat double precision,
     lon double precision,
     address text,
     gid integer,
     state integer,
     county integer);
 ALTER TYPE geocoded_address OWNER TO postgres;


CREATE OR REPLACE FUNCTION concat_agg_accum(text, text)
  RETURNS text AS
$BODY$select $1 || ', ' || $2$BODY$
  LANGUAGE 'sql' IMMUTABLE STRICT;
ALTER FUNCTION concat_agg_accum(text, text) OWNER TO postgres;


CREATE AGGREGATE concat_agg (
    BASETYPE = text,
    SFUNC = concat_agg_accum,
    STYPE = text
);

--The following function is used to increment the last character of a word.
--We are doing this to reproduct the functionality of the like command because
-- the like command is not optimized at this time
CREATE OR REPLACE FUNCTION increment_last_char(word character varying)
  RETURNS character varying AS
$BODY$
DECLARE
  v_len INTEGER;
  v_char VARCHAR;
BEGIN
  v_len := length(word);
  v_char := substring(word from v_len);
  RETURN substring(word from 1 for v_len -1) || chr(ascii(v_char) + 1);

END
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION increment_last_char(word character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION increment_last_char(word character varying) TO public;

-- Function: get_address_without_city(character varying)
-- DROP FUNCTION get_address_without_city(character varying);
CREATE OR REPLACE FUNCTION get_address_without_city(character varying)
  RETURNS SETOF character varying AS
$BODY$
  SELECT substring($1, E'(?i)(.+)\\s' || name || '[,\\s]*') as city
    FROM (select distinct replace(name, '.', '\.?') as name from placecu where lower(name) like 'st.%') p
   WHERE texticregexeq($1, E'(?i)\\s(' || name || ')[,\\s]*')
   ORDER BY char_length(substring($1, E'(?i)(.+)\\s' || name || '[,\\s]*')) DESC;
$BODY$
  LANGUAGE 'sql' STABLE STRICT;
ALTER FUNCTION get_address_without_city(character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_address_without_city(character varying) TO public;


-- Function: get_address_street_type(rawaddr character varying)
-- DROP FUNCTION get_address_street_type(rawaddr character varying);
CREATE OR REPLACE FUNCTION get_address_street_type(rawaddr character varying)
  RETURNS address_lookup_value AS
$BODY$
DECLARE
  comma_pos INTEGER;
  st_type_pos INTEGER;
  cnt INTEGER;
  without_city VARCHAR;
  tmp VARCHAR;
  result address_lookup_value;
  verbose BOOLEAN := TRUE;
BEGIN  
  --See if we can simplify by seperating on first comma
  comma_pos := position(',' in rawaddr);
  IF (comma_pos > 0) THEN
    tmp := substring(rawaddr from 0 for comma_pos);
  ELSE
    tmp := rawaddr;
  END IF;

  SELECT INTO cnt count(0)  
    FROM street_type_lookup 
    WHERE texticregexeq(tmp, E'(?i)\\s(' || name || E')(?:\\s|$|,|\\.)');
  
  IF verbose THEN
    RAISE NOTICE 'get_address_street_type: type_cnt "%"', cnt;
  END IF;

  IF (cnt > 1) then

    SELECT INTO st_type_pos, result.value, result.name, result.abbrev
           char_length(substring(tmp, E'(?i)(.+)\\s('  || name || E')(?:\\s|$|,|\\.)')) as pos,
           substring(tmp, E'(?i)\\s('  || name || E')(?:\\s|$|,|\\.)') as street_type, name, abbrev 
      FROM street_type_lookup 
      WHERE texticregexeq(tmp, E'(?i)\\s(' || name || E')(?:\\s|$|,|\\.)') order by pos desc limit 1;
    
	--This is some convoluted logic, but it was the only way I could come up with to solve the worst case.
    -- The worst case is an address without commas that has a st in it (i.e. 111 St. Clair St. St. Louis MS 12345)
    -- The question becomes, how to get the middle Note, this is only applicable if the value is 'st'.  No other
    -- street type abbreviations start the name of a city.  So to get started...
    
    --Check if value is 'st' and didn't have comma;  Otherwise assume that values in result are good
    IF ((lower(result.value) = 'st') and (comma_pos = 0)) THEN
      --This will cut the last city name out of the address
      SELECT INTO without_city * from get_address_without_city(tmp);
      
	  --If got value back without city name in it, then...
      IF (without_city IS NOT NULL) THEN        
        --Get the count of the street types again
		SELECT INTO cnt count(0)  
          FROM street_type_lookup 
          WHERE texticregexeq(without_city, E'(?i)\\s(' || name || E')(?:\\s|$|,|.)');
  
        --If count was still greater than 1, then get the last value by using offset
		IF (cnt > 1) THEN
            SELECT INTO result.value, result.name, result.abbrev
                   substring(without_city, E'(?i)\\s('  || name || E')(?:\\s|$|,|\\.)') as street_type, name, abbrev 
              FROM street_type_lookup 
              WHERE texticregexeq(without_city, E'(?i)\\s(' || name || E')(?:\\s|$|,|\\.)') OFFSET cnt -1;
        ELSE
			--If only have one, then use it.
            SELECT INTO result.value, result.name, result.abbrev
                   substring(without_city, E'(?i)\\s('  || name || E')(?:\\s|$|,|\\.)') as street_type, name, abbrev 
              FROM street_type_lookup 
              WHERE texticregexeq(without_city, E'(?i)\\s(' || name || E')(?:\\s|$|,|\\.)');
        END IF;
      END IF;
    END IF;
  ELSE
    --If only have one result then parse it out
    SELECT INTO result.value, result.name, result.abbrev
           substring(tmp, E'(?i)\\s('  || name || E')(?:\\s|$|,|\\.)') as street_type, name, abbrev 
      FROM street_type_lookup 
      WHERE texticregexeq(tmp, E'(?i)\\s(' || name || E')(?:\\s|$|,|\\.)');
  END IF;
  return result;
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION get_address_street_type(rawaddr character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_address_street_type(rawaddr character varying) TO public;


-- Function: get_address_street(rawaddr character varying, predir character varying, street_type character varying)
-- DROP FUNCTION get_address_street(rawaddr character varying, predir character varying, street_type character varying);
CREATE OR REPLACE FUNCTION get_address_street(rawaddr character varying, predir character varying, street_type character varying)
  RETURNS character varying AS
$BODY$
DECLARE
  cnt INTEGER;
  tmp VARCHAR;
  result VARCHAR;
  comma_pos INTEGER;
  verbose BOOLEAN := true;
BEGIN  

  --Get position of first comma
  comma_pos := position(',' in rawaddr);

  IF verbose THEN
    RAISE NOTICE 'get_address_street - street_type "%"', street_type;
  END IF;

  IF ((street_type IS NULL) OR (char_length(coalesce(street_type, '')) = 0)) THEN
    IF (( predir IS NULL) OR (char_length(coalesce( predir, '')) = 0)) THEN
      IF(comma_pos > 0) THEN
	--we have no street type, nor pre dir, but do have comma
	result := substring(rawaddr from E'(?i)^\\d+[A-Za-z]*\\s+(.+?)(?=,).+$');
      ELSE
	--we have no street type, nor pre dir nor comma
	result := substring(rawaddr from E'(?i)^\\d+[A-Za-z]*\\s+(.+$)');
      END IF;
    ELSE
      IF(comma_pos > 0) THEN
	--we have no street type, but do have predir and comma
	result := substring(rawaddr from E'(?i)^\\d+[A-Za-z]*\\s+' || predir || '\\s+(.+?)(?=,).+$');
      ELSE
	--we have no street type, nor comma, but do have predir
	result := substring(rawaddr from E'(?i)^\\d+[A-Za-z]*\\s+' || predir || '\\s+(.+$)');
      END IF;
    END IF;
  ELSE
    tmp := substring(rawaddr from street_type || E'\\s+(\\d+[A-Za-z0-9]*)');
  
    IF (tmp IS NOT NULL) THEN  
      --This will occur for things such as US HWY 72, County Rd 432, HWY 431a,  etc
      -- so for this case the street name includes the type
      IF (predir IS NOT NULL) THEN
        --If have predir then pull from there
        result := substring(rawaddr from E'(?i)' || predir || E'\\s+(.+' || street_type || E'\\s+\\d+[A-Za-z0-9]*)');
      ELSE
        -- no predir, then pull everything from house num
        result := substring(rawaddr from E'(?i)^\\d+[A-Za-z]*\\s+(.+' || street_type || E'\\s+\\d+[A-Za-z0-9]*)');
      END IF;
    ELSE
      --No number after type, then need to pull up to type
      SELECT INTO cnt count(0)  
        FROM street_type_lookup 
       WHERE texticregexeq(rawaddr, E'(?i)\\s(' || name || E')(?:\\s|$|,|.)');

      IF ((lower(street_type) = 'st') AND (cnt > 1)) THEN
        SELECT INTO tmp * from get_address_without_city(rawaddr);

        IF (tmp IS NULL) OR (position(street_type in tmp) = 0) then
          tmp = rawaddr;
        END IF;
      ELSE
        tmp = rawaddr;
      END IF;

      IF (predir IS NOT NULL) THEN
        --If have predir then pull from there        
        result := substring(tmp from E'(?i)' || predir || E'\\s+(.+)\\s+' || street_type );
      ELSE
        -- no predir, then pull everything from house num
        result := substring(tmp from E'(?i)^\\d+[A-Za-z]*\\s+(.+)\\s+' || street_type );
      END IF;
    END IF;
  END IF;
  return trim(both ' ' from result);
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION get_address_street(rawaddr character varying, predir character varying, street_type character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_address_street(rawaddr character varying, predir character varying, street_type character varying) TO public;


-- Function: get_address_direction(rawaddr character varying, street_type character varying, getpre boolean)
-- DROP FUNCTION get_address_direction(rawaddr character varying, street_type character varying, getpre boolean);
CREATE OR REPLACE FUNCTION get_address_direction(rawaddr character varying, street_type character varying, getpre boolean)
  RETURNS address_lookup_value AS
$BODY$
DECLARE
  result address_lookup_value;
  verbose BOOLEAN := FALSE;
BEGIN

  IF getpre THEN 
    --First check if we have abbreviation
    IF ((street_type IS NULL) OR (char_length(coalesce(street_type, '')) = 0)) THEN
      SELECT INTO result.value, result.name, result.abbrev
             trim(both ' ' from substring(rawaddr, E'(?i)^(?:\\d+[A-Za-z]*\\s+)(' || abbrev || E'(?=\\.|\\s[a-z0-9])[\\.\\s])')), name, abbrev
        FROM direction_lookup
       WHERE texticregexeq(rawaddr, E'(?i)^(?:\\d+[A-Za-z]*\\s+)(' || abbrev || E'(?=\\.|\\s[a-z0-9])[\\.\\s])')
       ORDER BY name desc;
    ELSE
      SELECT INTO result.value, result.name, result.abbrev
             trim(both ' ' from substring(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || abbrev || E'[\\.\\s](?!\s*' || street_type || E'[,\\.\\s]|\\s*' || street_type || E'$))')), name, abbrev
        FROM direction_lookup
       WHERE texticregexeq(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || abbrev || E'[\\.\\s](?!\s*' || street_type || E'[,\\.\\s]|\\s*' || street_type || E'$))')
       ORDER BY name desc;
    END IF;

    IF result.value IS NULL THEN
      IF verbose THEN
        RAISE NOTICE 'get_address_direction: no pre dir abbrev in address';
      END IF;

      --If didn't get a result then check the name itself
      IF ((street_type IS NULL) OR (char_length(coalesce(street_type, '')) = 0)) THEN
        SELECT INTO result.value, result.name, result.abbrev
               substring(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || name || E'(?=\\s+[a-z0-9]{3,}))'), name, abbrev
          FROM direction_lookup
         WHERE texticregexeq(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || name || E'(?=\\s+[a-z0-9]{3,}))')
         ORDER BY name desc;
      ELSE
        SELECT INTO result.value, result.name, result.abbrev
               substring(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || name || E'(?!$|\\s+' || street_type || E'[,\\.\\s]|\\s+' || street_type || E'$))'), name, abbrev
          FROM direction_lookup
         WHERE texticregexeq(rawaddr, E'(?i)^\\d+[A-Za-z]*\\s+(' || name || E'(?!$|\\s+' || street_type || E'[,\\.\\s]|\\s+' || street_type || E'$))')
         ORDER BY name desc;
      END IF;
    END IF;
  ELSE  --Get Post Direction

    IF ((street_type IS NULL) OR (char_length(coalesce(street_type, '')) = 0)) THEN
      RAISE EXCEPTION 'get_address_direction - NULL is not valid value for street type';
    END IF;
    --First check if we have abbreviation
    SELECT INTO result.value, result.name, result.abbrev
           substring(rawaddr, E'(?i)(?:'|| street_type || E'(?:\\s+\\w+)*\\s+)((' || abbrev || E'(?=,|\\s|$|\\.)).)'), name, abbrev
      FROM direction_lookup
     WHERE texticregexeq(rawaddr, E'(?i)(?:'|| street_type || E'(?:\\s+\\w+)*\\s+)((' || abbrev || E'(?=,|\\s|$|\\.)).)')
     ORDER BY name desc;
     
    --I am very leary of this part of the function because the direction
    -- could be part of the name of the city if the value is not seperated
    -- by a comma.
    IF result.value IS NULL THEN
      IF verbose THEN
        RAISE NOTICE 'get_address_direction: no post dir abbrev in address';
      END IF;

      --If didn't get a result then check the name itself
      SELECT INTO result.value, result.name, result.abbrev
             substring(rawaddr, E'(?i)(?:'|| street_type || E'(?:\\s+\\w+)*\\s+)(' || name || E')(?=,|$|\\s)'), name, abbrev
        FROM direction_lookup
       WHERE texticregexeq(rawaddr, E'(?i)(?:'|| street_type || E'(?:\\s+\\w+)*\\s+)(' || name || E')(?=,|$|\\s)')
       ORDER BY name desc;        
    END IF;

  END IF;

  IF verbose THEN
    IF result.value IS NULL THEN
      RAISE NOTICE 'get_address_direction: no results found';
    ELSE
      RAISE NOTICE 'get_address_direction: value: %', result.value;
    END IF;
  END IF;
  return result;
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION get_address_direction(rawaddr character varying, street_type character varying, getpre boolean) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_address_direction(rawaddr character varying, street_type character varying, getpre boolean) TO public;


-- Function: get_address_city(rawaddr character varying, street character varying, street_type character varying, postdir character varying, state character varying)
-- DROP FUNCTION get_address_city(rawaddr character varying, street character varying, street_type character varying, postdir character varying, state character varying);
CREATE OR REPLACE FUNCTION get_address_city(rawaddr character varying, street character varying, street_type character varying, postdir character varying, state character varying)
  RETURNS character varying AS
$BODY$
DECLARE
  location_addr VARCHAR;
  no_period_postdir VARCHAR;
  result VARCHAR;
  tmp VARCHAR;
  comma_pos INTEGER;
  verbose BOOLEAN := FALSE;
BEGIN  

  IF verbose THEN
    RAISE NOTICE 'get_address_city: street "%"', street;
    RAISE NOTICE 'get_address_city: street_type "%"', street_type;
    RAISE NOTICE 'get_address_city: postdir "%"', postdir;
    RAISE NOTICE 'get_address_city: state "%"', state;
  END IF;

  IF street_type IS NULL THEN  
    --Get position of first comma
    comma_pos := position(',' in rawaddr);
    IF comma_pos > 0 THEN
      --If got comma, then get everything past comma
      tmp := substring(rawaddr from comma_pos + 1);
      -- check if we have another comma in string
      comma_pos := position(',' in tmp);
      IF (comma_pos > 0) THEN
        --If we have more than one comma, then the result is between the comma's
        result := substring(tmp from 0 for comma_pos);
      ELSEIF (state IS NOT NULL) THEN
        --If have state, then it is up to the state value
        result := substring(tmp from E'(?i)\\s*(.+)\\s+' || state);
      ELSE
        --Don't have state or second comma, then set result = to tmp
        result := tmp;        
      END IF;      
    END IF;
  ELSE
    --Check if we can split on secondary location within the address  
    SELECT INTO location_addr
           substring(rawaddr from E'(?i)' || street_type || E'.*[,]*\\s+' || name || E'[\.]?\\s+.*?[,]*\\s(.+$)') 
      FROM secondary_unit_lookup
     where texticregexeq(rawaddr, E'(?i)' || street_type || E'.*[,]*\\s+' || name || E'[\.]?\\s+.*?[,]*\\s(.+$)')  = true;

    no_period_postdir := replace(postdir, '.', '');

    --If had secondary unit lookup value, then pull location from there.
    IF (location_addr IS NOT NULL) THEN
      --If don't have state, then assume that this is the location    
      IF (state IS NULL) THEN
        result := trim(both ' ' from location_addr);
      ELSE
        --If have state then location is everything from beginning to state
        result := trim(both ' ' from substring(location_addr from E'(?i)(.+)' || state));
      END IF;
    ELSE
      --If didn't have secondary location, then need to do some extra checking.
      IF ((state IS NULL) OR (char_length(coalesce(state, '')) = 0)) THEN
        --If don't have state
        IF ((postdir IS NULL) OR (char_length(coalesce(postdir, '')) = 0)) THEN
          --If don't have post direction
          IF (position(street_type in street) > 0) THEN
            --If street type is part of street name (i.e. US HWY 72), then go from end of street
            result := trim(substring(rawaddr from E'(?i)' || street || E'\\s*[,]?\\s+(.+$)'));
          ELSE
            --No state, no post dir and street type is not part of street, then go from end of street type
            result := trim(substring(rawaddr from E'(?i)' || street_type || E'\.?\\s*[,]?\\s+([^,]+)(?:\\s*,?)\\s*$'));
          END IF;
        ELSE
          -- If have post direction, then city is everything after postdir to the end of
          -- the line
	  result := trim(substring(rawaddr from E'(?i)' || street_type || E'.+' || no_period_postdir || E'[\.]?(?:\\s|,)\\s*(.+$)'));
        END IF;
      ELSE
        --If do have state
        IF ((postdir IS NULL) OR (char_length(coalesce(postdir, '')) = 0)) THEN
          --If don't have post direction
          IF (position(street_type in street) > 0) THEN
            --If street type is part of street name (i.e. US HWY 72), then go from end of street to state
            result := trim(substring(rawaddr from E'(?i)' || street || E'\\s*[,]?\\s+(.+)\\s+' || state));
          ELSE
            --no post dir and street type is not part of street, then go from end of street type to state
            result := trim(substring(rawaddr from E'(?i)' || street_type || E'\.?\\s*[,]?\\s+([^,]+)(?:\\s*,?)\\s+' || state));
          END IF;
        ELSE
          -- If have post direction, then city is everything after postdir to the state
	  result := trim(substring(rawaddr from E'(?i)' || street_type || E'.+' || no_period_postdir || E'[\.]?(?:\\s|,)\\s*(.+[^,])?(?:\\s|,)\\s*' || state));
        END IF;
      END IF;
    END IF;
  END IF; 

  return trim(both ' ' from result);
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION get_address_city(rawaddr character varying, street character varying, street_type character varying, postdir character varying, state character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_address_city(rawaddr character varying, street character varying, street_type character varying, postdir character varying, state character varying) TO public;

-- Function: get_normalized_address(rawaddr character varying)
-- DROP FUNCTION get_normalized_address(rawaddr character varying);
CREATE OR REPLACE FUNCTION get_normalized_address(rawaddr character varying)
  RETURNS address_parts AS
$BODY$
DECLARE
  street_type_val VARCHAR;  
  state_val VARCHAR;
  post_dir_val VARCHAR;
  pre_dir_val VARCHAR;
  result address_parts;
  comma_pos INTEGER;
  verbose BOOLEAN := true;
BEGIN

  comma_pos := position(',' in rawaddr);

  --Get the house number from the front of the address
  result.house_num := substring(rawaddr, E'(^\\d+)');
  IF verbose THEN
    RAISE NOTICE 'get_normalized_address: house_num "%"', result.house_num;
  END IF;

  --Get Street Type
  SELECT INTO street_type_val, result.street_type, result.street_type_abbrev *
    FROM get_address_street_type(rawaddr);

  IF verbose THEN
    RAISE NOTICE 'get_normalized_address: street_type "%"', street_type_val;
  END IF;

  IF ((street_type_val IS NULL) AND (comma_pos > 0)) THEN
    --Get the state
    --First check if they enetered the abbreviation.  Have to check 
    -- abbreviation first in case they enter something like New York NY.
    -- We want to be able to parse the NY out  
    select INTO state_val, result.state, result.state_abbrev, result.state_fips
           substring(rawaddr, E'(?i),.+\\s(' || abbrev || E')(?:\\s|$)'), name, abbrev, fips 
      FROM state_lookup 
      WHERE texticregexeq(rawaddr, E'(?i),.+\\s(' || abbrev || E')(?:\\s|$)')
      ORDER BY name desc;
    
    --If didn't get from abbreviation, then check if state was enetered by full name
    IF state_val IS NULL THEN
      select INTO state_val, result.state, result.state_abbrev, result.state_fips
             substring(rawaddr, E'(?i),.+\\s(' || name || E')(?:\\s|$)'), name, abbrev, fips  
        FROM state_lookup 
        WHERE texticregexeq(rawaddr, E'(?i),.+\\s(' || name || E')(?:\\s|$)')
        ORDER BY name desc;
    END IF;

  ELSEIF street_type_val IS NOT NULL THEN
    --Get the state
    --First check if they enetered the abbreviation.  Have to check 
    -- abbreviation first in case they enter something like New York NY.
    -- We want to be able to parse the NY out  
    select INTO state_val, result.state, result.state_abbrev, result.state_fips
           substring(rawaddr, E'(?i)' || street_type_val || E'.+\\s(' || abbrev || E')(?:\\s|$)'), name, abbrev, fips 
      FROM state_lookup 
      WHERE texticregexeq(rawaddr, E'(?i)' || street_type_val || E'.+\\s(' || abbrev || E')(?:\\s|$)')
      ORDER BY name desc;
    
    --If didn't get from abbreviation, then check if state was enetered by full name
    IF state_val IS NULL THEN
      select INTO state_val, result.state, result.state_abbrev, result.state_fips
             substring(rawaddr, E'(?i)' || street_type_val || E'.+\\s(' || name || E')(?:\\s|$)'), name, abbrev, fips  
        FROM state_lookup 
        WHERE texticregexeq(rawaddr, E'(?i)' || street_type_val || E'.+\\s(' || name || E')(?:\\s|$)')
        ORDER BY name desc;
    END IF;
  END IF;

  IF verbose THEN
    RAISE NOTICE 'get_normalized_address: state_val "%"', state_val;
  END IF;

  --Try to pull pre direction from address
  SELECT INTO pre_dir_val, result.pre_dir, result.pre_dir_abbrev *
    FROM get_address_direction(rawaddr, street_type_val, true);

  IF street_type_val IS NOT NULL THEN
    --Now try to parse the post direction from the address
    SELECT INTO post_dir_val, result.post_dir, result.post_dir_abbrev *
      FROM get_address_direction(rawaddr, street_type_val, false);
  END IF;

  IF verbose THEN
    RAISE NOTICE 'get_normalized_address: pre_dir_val "%"', coalesce(pre_dir_val, 'NULL');
    RAISE NOTICE 'get_normalized_address: post_dir_val "%"', coalesce(post_dir_val, 'NULL');
  END IF;
  --Get zipcode
  IF state_val IS NOT NULL THEN
    result.zipcode := substring(rawaddr, E'(?i)(?:' || state_val || E'\\s)*([0-9]{1,5})(?:-[0-9]{0,4})?\\s*$');
  END IF;

  IF verbose THEN
    RAISE NOTICE 'get_normalized_address: pre_dir_val "%"', coalesce(pre_dir_val, 'NULL');
    RAISE NOTICE 'get_normalized_address: street "%"', result.street;
    RAISE NOTICE 'get_normalized_address: street type "%"', street_type_val;
    RAISE NOTICE 'get_normalized_address: post_dir_val "%"', coalesce(post_dir_val, 'NULL');
    RAISE NOTICE 'get_normalized_address: state "%"', state_val;
  END IF;

  --street name
  result.street := get_address_street(rawaddr, pre_dir_val, street_type_val);

  --Get City
  result.city := get_address_city(rawaddr, result.street, street_type_val, post_dir_val, state_val);

  return result;
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION get_normalized_address(rawaddr character varying) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION get_normalized_address(rawaddr character varying) TO public;


-- Function: geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, character varying, integer)
-- DROP FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, character varying, integer);
CREATE OR REPLACE FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, character varying, integer)
  RETURNS SETOF geocoded_address AS
$BODY$
DECLARE
  result geocoded_address;
BEGIN
-- $1: House Number
-- $2: Street Address
-- $3: Street Address + 1
-- $4: Street Type Abbrev
-- $5: Place
-- $6: State
-- $7: Zipcode
-- %8: Limit to query
  IF ($4 IS NULL) THEN
    for result in (SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid, r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county 
	         WHERE lower(r.fename::text) = lower($2)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
		   AND ((lower(p.name) >= lower($5) and lower(p.name) < lower(increment_last_char($5))) or coalesce(r.place, -1)=-1)
		   AND lower(s.name)=lower($6)
		   AND r.zip like $7
      LIMIT $8)
    LOOP
      return next result;
    END LOOP;
  ELSE
    for result in (SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid,r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county 
	         WHERE lower(r.fename::text) = lower($2)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
		   AND (lower(r.fetype)=lower($4) OR coalesce(r.fetype,'')='')
		   AND ((lower(p.name) >= lower($5) and lower(p.name) < lower(increment_last_char($5))) or coalesce(r.place, -1)=-1)
		   AND lower(s.name)=lower($6)
		   AND r.zip like $7
      LIMIT $8)
    LOOP
      return next result;
    END LOOP;
  END IF;
END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, character varying, integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, character varying, integer) TO public;


-- Function: geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, integer)
-- DROP FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, integer);
CREATE OR REPLACE FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, integer)
  RETURNS SETOF geocoded_address AS
$BODY$
-- $1: House Number
-- $2: Street Address
-- $3: Street Address + 1
-- $4: Street Type Abbrev
-- $5: Place
-- $6: State
-- %7: Limit to query

SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid,r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county 
	         WHERE lower(r.fename::text) = lower($2)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
		   AND (lower(r.fetype)=lower($4) OR coalesce(r.fetype,'')='')
		   AND ((lower(p.name) >= lower($5) and lower(p.name) < lower(increment_last_char($5))) or coalesce(r.place, -1)=-1)
		   AND lower(s.name)=lower($6)
      ORDER BY r.place
      LIMIT $7
$BODY$
  LANGUAGE 'sql' STABLE;
ALTER FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, character varying, integer) TO public;


-- Function: geo_live_search(integer, character varying, character varying, character varying, character varying, integer)
-- DROP FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, integer);
CREATE OR REPLACE FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, integer)
  RETURNS SETOF geocoded_address AS
$BODY$
-- $1: House Number
-- $2: Street Address
-- $3: Street Address + 1
-- $4: Street Type Abbrev
-- $5: Place
-- %6: Limit to query
SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid,r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county 
	         WHERE lower(r.fename::text) = lower($2)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
		   AND (lower(r.fetype)=lower($4) OR coalesce(r.fetype,'')='')
		   AND ((lower(p.name) >= lower($5) and lower(p.name) < lower(increment_last_char($5))) or coalesce(r.place, -1)=-1)
        ORDER BY r.place
        LIMIT $6
$BODY$
  LANGUAGE 'sql' STABLE;
ALTER FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(integer, character varying, character varying, character varying, character varying, integer) TO public;


-- Function: geo_live_search(integer, character varying, character varying, character varying, integer)
-- DROP FUNCTION geo_live_search(integer, character varying, character varying, character varying, integer);
CREATE OR REPLACE FUNCTION geo_live_search(integer, character varying, character varying, character varying, integer)
  RETURNS SETOF geocoded_address AS
$BODY$
-- $1: House Number
-- $2: Street Address
-- $3: Street Address + 1
-- $4: Street Type Abbrev
-- %5: Limit to query
SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid,r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county 
	         WHERE lower(r.fename::text) = lower($2)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
		   AND (lower(r.fetype)=lower($4) OR coalesce(r.fetype, '')='')
      ORDER BY r.place
      LIMIT $5
$BODY$
  LANGUAGE 'sql' STABLE;
ALTER FUNCTION geo_live_search(integer, character varying, character varying, character varying, integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(integer, character varying, character varying, character varying, integer) TO public;


-- Function: geo_live_search(integer, character varying, character varying, integer)
-- DROP FUNCTION geo_live_search(integer, character varying, character varying, integer);
CREATE OR REPLACE FUNCTION geo_live_search(integer, character varying, character varying, integer)
  RETURNS SETOF geocoded_address AS
$BODY$
-- $1: House Number
-- $2: Street Address
-- $3: Street Address + 1
SELECT Y(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lat, 
       X(line_interpolate_point(linemerge(r.the_geom), greatest(($1 - ladd), 1)::float / greatest((gadd - ladd), 1)::float)) as lon, 
	               $1::varchar || ' ' || coalesce(fedirp || ' ', '') || fename || coalesce(' ' || fetype, '') || coalesce(' ' || fedirs, '') || coalesce(', ' || p.name, '') || coalesce(', ' || s.name, '') || coalesce(' ' || zip::text, '') as address, 
	               r.gid,r.state, r.county
	          FROM tiger_geocode_roads r 
	     LEFT JOIN state_lookup s on r.state = s.fips 
	     LEFT JOIN uplace_lookup p on r.place=p.place and r.state=p.state and r.county=p.county
	         WHERE lower(r.fename::text) >= lower($2) and lower(r.fename::text) < lower($3)
	           AND r.gadd >= $1
	           AND r.ladd <= $1
	           AND fename IS NOT NULL 
	           AND gadd IS NOT NULL 
	           AND ladd IS NOT NULL
      ORDER BY r.place
      LIMIT $4
$BODY$
  LANGUAGE 'sql' STABLE;
ALTER FUNCTION geo_live_search(integer, character varying, character varying, integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(integer, character varying, character varying, integer) TO public;

-- Function: geo_live_search(rawaddr character varying, max integer)
-- DROP FUNCTION geo_live_search(rawaddr character varying, max integer);

CREATE OR REPLACE FUNCTION geo_live_search(rawaddr character varying, max integer)
  RETURNS SETOF geocoded_address AS
$BODY$
DECLARE
  v_rec RECORD;
  v_ret geocoded_address;
  norm_addr address_parts;
  cnt INTEGER;
  verbose BOOLEAN := true;
BEGIN

  norm_addr := get_normalized_address(rawaddr);
  
  IF verbose THEN
    RAISE NOTICE 'geo_live_search() - addr "%"', norm_addr.house_num;
    RAISE NOTICE 'geo_live_search() - streetName "%"', lower(norm_addr.street);
    RAISE NOTICE 'geo_live_search() - streetType "%"', norm_addr.street_type_abbrev;
    RAISE NOTICE 'geo_live_search() - loc "%"', norm_addr.city;
    RAISE NOTICE 'geo_live_search() - state "%"', norm_addr.state;
    RAISE NOTICE 'geo_live_search() - zipCode "%"', norm_addr.zipcode;
  END IF;

  IF (char_length(coalesce(norm_addr.street, '')) = 0) THEN
    return;
  END IF;

  IF((length(norm_addr.zipcode) > 0) AND (length(norm_addr.state) > 0) AND (length(norm_addr.city) > 0)) THEN
    --RAISE NOTICE 'geo_live_search() - through zip';   
    --SELECT count(0) into cnt FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), norm_addr.street_type_abbrev, norm_addr.city, norm_addr.state, norm_addr.zipcode || '%', max);
    --RAISE NOTICE 'count (%)', cnt;
    for v_ret in (SELECT * FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), norm_addr.street_type_abbrev, norm_addr.city, norm_addr.state, norm_addr.zipcode || '%', max)) LOOP
      RETURN NEXT v_ret;
    END LOOP;

  ELSEIF ((length(norm_addr.state) > 0) AND (length(norm_addr.city) > 0) AND (length(norm_addr.street_type_abbrev) > 0)) THEN 
    --RAISE NOTICE 'geo_live_search() - through state';   
    for v_ret in (SELECT * FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), norm_addr.street_type_abbrev, norm_addr.city, norm_addr.state, max)) LOOP
      RETURN NEXT v_ret;
    END LOOP;

  ELSEIF ((length(norm_addr.city) > 0) AND (length(norm_addr.street_type_abbrev) > 0)) THEN
    --RAISE NOTICE 'geo_live_search() - through city';
    for v_ret in (SELECT * FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), norm_addr.street_type_abbrev, norm_addr.city, max)) LOOP
      RETURN NEXT v_ret;
    END LOOP;

  ELSEIF ((length(norm_addr.street_type_abbrev) > 0)) THEN
    --RAISE NOTICE 'geo_live_search() - through street type';
    for v_ret in (SELECT * FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), norm_addr.street_type_abbrev, max)) LOOP
      RETURN NEXT v_ret;
    END LOOP;

  ELSE
    --RAISE NOTICE 'geo_live_search() - address';
    for v_ret in (SELECT * FROM geo_live_search(norm_addr.house_num, lower(norm_addr.street), increment_last_char(lower(norm_addr.street)), max)) LOOP
      RETURN NEXT v_ret;
    END LOOP;

  END IF;

END
$BODY$
  LANGUAGE 'plpgsql' STABLE;
ALTER FUNCTION geo_live_search(rawaddr character varying, max integer) OWNER TO postgres;
GRANT EXECUTE ON FUNCTION geo_live_search(rawaddr character varying, max integer) TO public;
