__doc__ = """JWForm"""
__version__ = '0.1'

from zope import interface, schema
from z3c.form import form, field, button
from plone.app.z3cform.layout import wrap_form

class IPerson(interface.Interface):
    age = schema.Int(
	title=u"Age",
	required=True)

class Person(form.Form):
     fields = field.Fields(IPerson)
     ignoreContext = True # don't use context to get widget data
     label = u"Please enter your age"
 
     @button.buttonAndHandler(u'Apply')
     def handleApply(self, action):
         data, errors = self.extractData()
         print data['age'] # ... or do stuff

PersonView = wrap_form(Person)
