/*
** libyourserver.h for libyourserver in include/libyourserver
** 
** Made by Dias Da Silva Loic <mglcel@linuxfr.net>
** 
** Started on      Fri Nov  3 15:19:30 2000 by Dias Da Silva Loic
** Last updated on Sun Nov 26 03:30:55 2000 by 
** 
** Description : The main libyourserver header


*/
#ifndef __LIBYOURSQLD_H
#define __LIBYOURSQLD_H

#define SESSION_FUNC(x) void x (int _peersock, char* _peeraddr)
#define YSRV_INIT if (pth_init () == FALSE) return ERR(INVALID_PTH_INIT)
#define YSRV_MAIN_LOOP while (pth_ctrl (PTH_CTRL_GETTHREADS) != 0) \
pth_sleep (1)
#define YSRV_KILL(x) pth_kill (); \
delete (x)

#include <iostream.h>
#include <pth.h>

#include "ysrv_consts.h"
#include "ysrv_structs.h"
#include "ysrv_configuration.h"
#include "ysrv_connexion.h"
#include "ysrv_session.h"
#include "ysrv_server.h"
#include "ysrv_errors.h"
#include "ysrv_wrappers.h"
#include "ysrv_log.h"
#include "ysrv_application.h"
#include "yourserver.h"

#ifdef DEBUG
#include "ysrv_debug.h"
#else
#define FUNC_DEBUG(x)
#endif 

#endif
