//
// ysrv_configuration.cc for libyourserver in src/libyourserver
// 
// Made by Dias Da Silva Loic <mglcel@linuxfr.net>
// 
// Started on      Fri Nov  3 15:49:48 2000 by Dias Da Silva Loic
// Last updated on Sun Nov 26 14:10:58 2000 by 
// 
// Description : The Configuration class


//
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

#include "libyourserver.h"

// Read the configuration file
// Allocate the config struct
Configuration::Configuration ()
{
  FUNC_DEBUG ("Read configuration");

  config = (s_config*) calloc (sizeof (s_config), 1);

  this->type = APPLICATION;
  this->config->IPport   = 4242;
}

// -----

// Copy a configuration struct pointer to yours
Configuration::Configuration (s_config* _config)
{
  FUNC_DEBUG ("Copy configuration pointer to server or session");

  this->config = _config;
  this->type   = OTHER;
}

// -----

Configuration::~Configuration ()
{
  FUNC_DEBUG ("Destroy a configuration instance...");

  if (this->type == APPLICATION)
    {
      free (config);
    }
}
