//
// ysrv_connexion.cc for libyourserver in src/libyourserver
// 
// Made by Dias Da Silva Loic <mglcel@linuxfr.net>
// 
// Started on      Fri Nov  3 15:46:49 2000 by Dias Da Silva Loic
// Last updated on Sun Nov 26 14:49:35 2000 by 
// 
// Description : The Connexion class


//
#include <string.h>
#include <pth.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <iostream.h>

#include "libyourserver.h"

// Connexion for servers
Connexion::Connexion (s_config* _config) : 
  Configuration (_config)
{
  FUNC_DEBUG ("Make a server connexion");

  char sockopt_val=1;
   
  bzero ((char*) &this->IPname, sizeof(this->IPname));
  bzero ((char*) &this->IPpeer, sizeof(this->IPpeer));
  
  this->IPname.sin_family      = AF_INET;
  this->IPname.sin_addr.s_addr = htonl (INADDR_ANY);
  this->IPname.sin_port        = (unsigned short) htons (this->config->IPport);
  
  if ((this->sock = socket (AF_INET, SOCK_STREAM, 0)) == -1)
      ERR (INVALID_SOCKET);
  
  (void) setsockopt (this->sock,SOL_SOCKET,
		     SO_REUSEADDR,&sockopt_val,sizeof(sockopt_val));
  
  if (bind (this->sock, (const struct sockaddr*) &this->IPname, 
	    sizeof(this->IPname)) == -1)
      ERR (INVALID_BIND);

  (void) listen(this->sock, MAX_QUEUE);
}

// -----

// Connexion for intermediate sessions
Connexion::Connexion (int _sock, s_config* _config) :
  Configuration (_config)
{
  FUNC_DEBUG ("Accept for incoming connections");

  int peer_len = sizeof(struct sockaddr_in);

  this->status = C_ACCEPT;
  if ((this->sock = pth_accept(_sock,
			       (struct sockaddr *) &this->IPpeer, 
			       (socklen_t*) &peer_len)) == -1)
    {
      ERR (INVALID_PTH_ACCEPT);
      this->status = C_ZOMBIE;
    }
  else
    this->status = C_ETA_CLIENT;
}

// -----

Connexion::~Connexion ()
{
  FUNC_DEBUG ("Deconnexion..");

  if (this->sock && this->sock != -1)
    close (this->sock);
}

// -----

int
Connexion::get_socket (void)
{
  return this->sock;
}

// -----

char*
Connexion::get_peer_addr (void)
{
  struct hostent* ret_host;
  static char ip_addr [256];

  ret_host = gethostbyname (inet_ntoa(this->IPpeer.sin_addr));
  strncpy (ip_addr, ret_host->h_name, 128);

  return ip_addr;
}
