//
// ysrv_server.cc for libyourserver in src/libyourserver
// 
// Made by Dias Da Silva Loic <mglcel@linuxfr.net>
// 
// Started on      Fri Nov  3 15:16:04 2000 by Dias Da Silva Loic
// Last updated on Sun Nov 26 14:42:38 2000 by 
// 
// Description : The Server class
//

#include <stdlib.h>
#include <stdio.h>

#include "libyourserver.h"

// Make a new server
// Make the first intermediate session
Server::Server (s_config* _config, SESSION_FUNC((*_ETA_client_func)),
		SESSION_FUNC((*_ETA_server_func)), char* _retry_msg) : 
  Connexion (_config)
{ 
  FUNC_DEBUG ("Server instance creation");

  pth_attr_t attr = pth_attr_new ();;
  session_spawn_params* params = 
    (session_spawn_params*) calloc (sizeof (session_spawn_params), 1);

  this->alive        = TRUE;
  this->head_session = NULL;
  this->nb_sessions  = 0;

  params->server      = this;
  params->socket      = this->sock;
  params->config      = this->config;
  params->session     = &this->inter_session;
  params->nb_sessions = &this->nb_sessions;
  params->eta_client  = _ETA_client_func;
  params->eta_server  = _ETA_server_func;
  params->retry       = _retry_msg;
  pth_attr_set(attr, PTH_ATTR_JOINABLE, FALSE);
  pth_attr_set(attr, PTH_ATTR_NAME, "First session");
  (void) pth_spawn(attr, ysrv_wrap_spawn_session, params);

  free (params);
  pth_attr_destroy (attr);
}

// -----

Server::~Server ()
{
  FUNC_DEBUG ("Server instance destroying...");

  this->Connexion::~Connexion ();

  this->destroy_all_sessions ();
  delete this->inter_session;
  this->alive = FALSE;
}

// -----

void
Server::destroy_all_sessions (void)
{
  FUNC_DEBUG ("Destroy all sessions");

  ll_session* cursor = this->head_session;
  ll_session* son = NULL;
  
  while (cursor)
    {
      son = cursor->next;
      delete cursor->session;
      free (cursor);
      cursor = son;
    }

  this->nb_sessions  = 0;
  this->head_session = NULL;
}

// -----

// Make a intermediate session a complete server session
int
Server::attach_session (Session* _session, SESSION_FUNC((*_ETA_client_func)),
			SESSION_FUNC((*_ETA_server_func)), char* _retry_msg)
{
  FUNC_DEBUG ("Attach session");

  pth_attr_t attr = pth_attr_new ();
  session_spawn_params* params = NULL;
  ll_session* new_session      = (ll_session*) calloc (sizeof (ll_session),1);
  ll_session* cursor           = this->head_session;
  
  new_session->next    = NULL;
  new_session->session = _session;

  if (!(params = (session_spawn_params*) 
	calloc (sizeof (session_spawn_params), 1)))
    {
      pth_attr_destroy (attr);
      return 0;
    }

  if (this->head_session)
    {
      while (cursor->next) cursor = cursor->next;
      cursor->next = new_session;
    }
  else
    this->head_session = new_session;

  params->server      = this;
  params->socket      = this->sock;
  params->config      = this->config;
  params->session     = &this->inter_session;
  params->nb_sessions = &this->nb_sessions;
  params->eta_client  = _ETA_client_func;
  params->eta_server  = _ETA_server_func;
  params->retry       = _retry_msg;
  pth_attr_set(attr, PTH_ATTR_JOINABLE, FALSE);
  pth_attr_set(attr, PTH_ATTR_NAME, "Session");
  (void) pth_spawn(attr, ysrv_wrap_spawn_session, params);

  this->nb_sessions++;
  free (params);
  pth_attr_destroy (attr);

  return 1;
}

// ------

// Detach an destroy a server session
void
Server::detach_session (Session* _session)
{
  FUNC_DEBUG ("Detach Session");

  ll_session* cursor = this->head_session;
  ll_session* father = NULL;

  while (cursor)
    {
      if (cursor->session == _session)
	break;
      
      father = cursor;
      cursor = cursor->next;
    }
  if (cursor)
    {
      if (father)
	father->next = cursor->next;
      
      if (cursor == head_session)
	head_session = cursor->next;

      delete cursor->session;
      free (cursor);

      this->nb_sessions--;
    }
}


