//
// ysrv_wrappers.cc for libyourserver in src/libyourserver
// 
// Made by  <mglcel@linuxfr.net>
// 
// Started on      Tue Nov  7 23:10:15 2000 by 
// Last updated on Sun Nov 26 14:27:58 2000 by 
// 
// Description : Wrappers from C incompatibilities



//
#include <stdio.h>
#include <iostream.h>

#include "libyourserver.h"

// Make a thread to encapsulate a server instance
void*
ysrv_wrap_spawn_server (void* _params)
{
  FUNC_DEBUG ("Spawn a server instance thread");

  server_spawn_params* params = (server_spawn_params*) _params;

  *params->server = new Server (params->config,
				params->eta_client,
				params->eta_server,
				params->retry);

  return NULL;
}

// -----

// Make a thread to encapsulate a session instance
void*
ysrv_wrap_spawn_session (void* _params)
{
  FUNC_DEBUG ("Spawn a session instance thread");

#ifdef DEBUG
  FILE* debug = fopen ("pth_debug", "a+");
#endif

  session_spawn_params* params = (session_spawn_params*) _params;

  *params->session = new Session (params->server,
				  params->socket,
				  params->config,
				  params->nb_sessions,
				  params->eta_client,
				  params->eta_server,
				  params->retry);

#ifdef DEBUG
  pth_ctrl (PTH_CTRL_DUMPSTATE, debug);
  fclose (debug);
#endif

  return NULL;
}
