/*
**  GNU Pth - The GNU Portable Threads
**  Copyright (c) 1999-2000 Ralf S. Engelschall <rse@engelschall.com>
**
**  This file is part of GNU Pth, a non-preemptive thread scheduling
**  library which can be found at http://www.gnu.org/software/pth/.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
**  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
**
**  pth_acmac.h: Autoconf macros
*/

#ifndef _PTH_ACMAC_H_
#define _PTH_ACMAC_H_

/* sig{set,long}jmp macros */
#define pth_sigjmpbuf sigjmp_buf
#define pth_sigsetjmp(buf) sigsetjmp(buf,1)
#define pth_siglongjmp(buf,val) siglongjmp(buf,val)

/* stack setup macros */
#define pth_skaddr(func,skaddr,sksize) pth_skaddr_##func(skaddr,sksize)
#define pth_sksize(func,skaddr,sksize) pth_sksize_##func(skaddr,sksize)
#define pth_skaddr_sigstack(skaddr,sksize) (/*N.A.*/)
#define pth_sksize_sigstack(skaddr,sksize) (/*N.A.*/)
#define pth_skaddr_sigaltstack(skaddr,sksize) (/*N.A.*/)
#define pth_sksize_sigaltstack(skaddr,sksize) (/*N.A.*/)
#define pth_skaddr_makecontext(skaddr,sksize) (/*N.A.*/)
#define pth_sksize_makecontext(skaddr,sksize) (/*N.A.*/)

/* mctx compile defines */
#define PTH_MCTX_MTH(which)  (PTH_MCTX_MTH_use == (PTH_MCTX_MTH_##which))
#define PTH_MCTX_DSP(which)  (PTH_MCTX_DSP_use == (PTH_MCTX_DSP_##which))
#define PTH_MCTX_STK(which)  (PTH_MCTX_STK_use == (PTH_MCTX_STK_##which))
#define PTH_MCTX_MTH_mcsc    1
#define PTH_MCTX_MTH_sjlj    2
#define PTH_MCTX_DSP_sc      1
#define PTH_MCTX_DSP_ssjlj   2
#define PTH_MCTX_DSP_sjlj    3
#define PTH_MCTX_DSP_usjlj   4
#define PTH_MCTX_DSP_sjlje   5
#define PTH_MCTX_DSP_sjljlx  6
#define PTH_MCTX_DSP_sjljisc 7
#define PTH_MCTX_DSP_sjljw32 8
#define PTH_MCTX_STK_mc      1
#define PTH_MCTX_STK_ss      2
#define PTH_MCTX_STK_sas     3
#define PTH_MCTX_STK_none    4

#endif /* _PTH_ACMAC_H_ */

