/*
** ysrv_structs.h for libyourserver in include/libyourserver
** 
** Made by Dias Da Silva Loic <mglcel@linuxfr.net>
** 
** Started on      Fri Nov  3 17:11:43 2000 by Dias Da Silva Loic
** Last updated on Sun Nov 26 14:15:09 2000 by 
** 
** Description : libyourserver structures


*/
#ifndef __YSQLD_STRUCTS_H
#define __YSQLD_STRUCTS_H

#include <sys/types.h>
#include <netinet/in.h>

class Session;

// Configuration structure
typedef struct _s_config s_config;
struct _s_config
{
  in_port_t IPport;
};

// Sessions Linked List structure definition
class Session;
typedef struct _ll_session ll_session;
struct _ll_session
{
  Session* session;
  ll_session* next;
};

// Servers Linked List structure definition
class Server;
typedef struct _ll_server ll_server;
struct _ll_server
{
  Server* server;
  ll_server* next;
};

// Session instance creation parameters
class Server;
class Session;
typedef struct _session_spawn_params session_spawn_params;
struct _session_spawn_params
{
  SESSION_FUNC((*eta_client));
  SESSION_FUNC((*eta_server));
  char* retry;
  Server* server;
  s_config* config;
  int socket;
  Session** session;
  unsigned int* nb_sessions;
};

// Server instance creation parameters
typedef struct _server_spawn_params server_spawn_params;
struct _server_spawn_params
{
  SESSION_FUNC((*eta_client));
  SESSION_FUNC((*eta_server));
  char* retry;
  Server** server;
  s_config* config;
};

#endif
