//
// ysrv_application.cc for libyourserver in src/libyourserver
// 
// Made by  <mglcel@linuxfr.net>
// 
// Started on      Sun Nov 19 15:30:19 2000 by 
// Last updated on Sun Nov 26 14:43:04 2000 by 
// 
// Description : The Application class


//
#include <stdio.h>
#include <pth.h>
#include <stdlib.h>
#include <iostream.h>
#include <sys/types.h>

#include "libyourserver.h"

Application::Application () :
  Configuration ()
{
  FUNC_DEBUG ("Application instance creation");

  this->head_server = NULL;
  this->nb_servers  = 0;
}

// -----

Application::~Application ()
{
  FUNC_DEBUG ("Application instance destroying...");

  this->destroy_all_servers ();
}

// -----

Server*
Application::create_new_server (SESSION_FUNC((*_ETA_client_func)), 
				SESSION_FUNC((*_ETA_server_func)),
				char* _retry_msg)
{
  FUNC_DEBUG ("Make a new server from an application instance");

  pth_attr_t attr = pth_attr_new ();
  ll_server* new_server = NULL;
  ll_server* cursor = this->head_server;
  server_spawn_params* params;

  if (!(params = (server_spawn_params*) 
       calloc (sizeof (server_spawn_params), 1)))
    return NULL;

  if (!(new_server = (ll_server*) calloc (sizeof (ll_server),1)))
    return NULL;

  new_server->next   = NULL;
  new_server->server = NULL;

  if (this->head_server)
    {
      while (cursor->next) cursor = cursor->next;
      cursor->next = new_server;
    }
  else
    this->head_server = new_server;

  params->server     = &new_server->server;
  params->config     = this->config;
  params->eta_client = _ETA_client_func;
  params->eta_server = _ETA_server_func;
  params->retry      = _retry_msg;
  pth_attr_set(attr, PTH_ATTR_JOINABLE, FALSE);
  pth_attr_set(attr, PTH_ATTR_NAME, "Server");
  (void) pth_spawn (attr, ysrv_wrap_spawn_server, params);

  this->nb_servers++;
  free (params);

  this->nb_servers++;
  free (params);
  pth_attr_destroy (attr);
  return new_server->server;
}

// -----

void 
Application::destroy_server (Server* _server)
{
  FUNC_DEBUG ("Destroy a server from an application instance");

  ll_server* cursor = this->head_server;
  ll_server* father = NULL;

  while (cursor)
    {
      if (cursor->server == _server)
	break;

      father = cursor;
      cursor = cursor->next;
    }
  if (cursor)
    {
      if (father)
	father->next = cursor->next;

      if (cursor == head_server)
	head_server = cursor->next;
      
      delete cursor->server;
      free (cursor);
      
      this->nb_servers--;
    }
}

// -----

void
Application::destroy_all_servers (void)
{
  FUNC_DEBUG ("Destroy all servers");

  ll_server* cursor = this->head_server;
  ll_server* son = NULL;
  
  while (cursor)
    {
      son = cursor->next;
      delete cursor->server;
      free (cursor);
      cursor = son;
    }

  this->head_server = NULL; 
}

